/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.jedit.util.CleanerService;

public class JARClassLoader
extends ClassLoader {
    private static final Object NO_CLASS = new Object();
    private static int INDEX;
    private static int live;
    private static final Map<String, Object> classHash;
    private static final Map<String, Object> resourcesHash;
    private final int id;
    private boolean delegateFirst;
    private PluginJAR jar;

    public JARClassLoader() {
        this(true);
    }

    public JARClassLoader(boolean delegateFirst) {
        this.delegateFirst = delegateFirst;
        this.id = INDEX++;
        ++live;
        CleanerService.instance.register(this, () -> --live);
    }

    public Class loadClass(String clazz, boolean resolveIt) throws ClassNotFoundException {
        Object obj;
        ClassNotFoundException pending = null;
        if (this.delegateFirst) {
            try {
                return this.loadFromParent(clazz);
            }
            catch (ClassNotFoundException cnf) {
                pending = cnf;
            }
        }
        if ((obj = classHash.get(clazz)) == NO_CLASS) {
            throw new ClassNotFoundException(clazz);
        }
        if (obj instanceof JARClassLoader) {
            JARClassLoader classLoader = (JARClassLoader)obj;
            try {
                return classLoader._loadClass(clazz, resolveIt);
            }
            catch (ClassNotFoundException cnf2) {
                classHash.put(clazz, NO_CLASS);
                throw cnf2;
            }
        }
        if (this.delegateFirst) {
            throw pending;
        }
        return this.loadFromParent(clazz);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            ZipFile zipFile;
            ZipEntry entry;
            if (this.jar != null && (entry = (zipFile = this.jar.getZipFile()).getEntry(name)) != null) {
                return zipFile.getInputStream(entry);
            }
            Object obj = resourcesHash.get(name);
            if (obj instanceof JARClassLoader) {
                JARClassLoader classLoader = (JARClassLoader)obj;
                return classLoader.getResourceAsStream(name);
            }
            return JARClassLoader.getSystemResourceAsStream(name);
        }
        catch (IOException io) {
            Log.log(9, this, io);
            return null;
        }
    }

    @Override
    public URL getResource(String name) {
        try {
            ZipFile zipFile;
            ZipEntry entry;
            if (this.jar != null && (entry = (zipFile = this.jar.getZipFile()).getEntry(name)) != null) {
                return new URL(this.getResourceAsPath(name));
            }
            Object obj = resourcesHash.get(name);
            if (obj instanceof JARClassLoader) {
                JARClassLoader classLoader = (JARClassLoader)obj;
                return classLoader.getResource(name);
            }
            URL ret = JARClassLoader.getSystemResource(name);
            if (ret != null) {
                Log.log(1, JARClassLoader.class, "Would have returned null for getResource(" + name + ")");
                Log.log(1, JARClassLoader.class, "returning(" + String.valueOf(ret) + ")");
            }
            return ret;
        }
        catch (IOException io) {
            Log.log(9, this, io);
            return null;
        }
    }

    public String getResourceAsPath(String name) {
        if (this.jar == null) {
            throw new UnsupportedOperationException("don't call getResourceAsPath() on anonymous JARClassLoader");
        }
        if (!((String)name).startsWith("/")) {
            name = "/" + (String)name;
        }
        return "jeditresource:/" + MiscUtilities.getFileName(this.jar.getPath()) + "!" + (String)name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump() {
        Log.log(1, JARClassLoader.class, "Total instances created: " + INDEX);
        Log.log(1, JARClassLoader.class, "Live instances: " + live);
        Map<String, Object> map = classHash;
        synchronized (map) {
            for (Map.Entry<String, Object> entry : classHash.entrySet()) {
                if (entry.getValue() == NO_CLASS) continue;
                Log.log(1, JARClassLoader.class, entry.getKey() + " ==> " + String.valueOf(entry.getValue()));
            }
        }
    }

    public String toString() {
        if (this.jar == null) {
            return "<anonymous>(" + this.id + ")";
        }
        return this.jar.getPath() + " (" + this.id + ")";
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        URL resource = this.getResource(name);
        class SingleElementEnumeration
        implements Enumeration<URL> {
            private URL element;

            SingleElementEnumeration(URL element) {
                this.element = element;
            }

            @Override
            public boolean hasMoreElements() {
                return this.element != null;
            }

            @Override
            public URL nextElement() {
                if (this.element != null) {
                    URL retval = this.element;
                    this.element = null;
                    return retval;
                }
                throw new NoSuchElementException();
            }
        }
        return new SingleElementEnumeration(resource);
    }

    JARClassLoader(PluginJAR jar) {
        this();
        this.jar = jar;
    }

    void activate() {
        String[] resources;
        String[] classes;
        if (this.jar.getPlugin() != null) {
            String _delegate = jEdit.getProperty("plugin." + this.jar.getPlugin().getClassName() + ".class_loader_delegate");
            boolean bl = this.delegateFirst = _delegate == null || "true".equals(_delegate);
        }
        if ((classes = this.jar.getClasses()) != null) {
            for (String aClass : classes) {
                classHash.put(aClass, this);
            }
        }
        if ((resources = this.jar.getResources()) != null) {
            for (String resource : resources) {
                resourcesHash.put(resource, this);
            }
        }
    }

    void deactivate() {
        String[] resources;
        String[] classes = this.jar.getClasses();
        if (classes != null) {
            for (String aClass : classes) {
                Object loader = classHash.get(aClass);
                if (loader != this) continue;
                classHash.remove(aClass);
            }
        }
        if ((resources = this.jar.getResources()) == null) {
            return;
        }
        for (String resource : resources) {
            Object loader = resourcesHash.get(resource);
            if (loader != this) continue;
            resourcesHash.remove(resource);
        }
    }

    private synchronized Class _loadClass(String clazz, boolean resolveIt) throws ClassNotFoundException {
        this.jar.activatePlugin();
        JARClassLoader jARClassLoader = this;
        synchronized (jARClassLoader) {
            Class<?> cls = this.findLoadedClass(clazz);
            if (cls != null) {
                if (resolveIt) {
                    this.resolveClass(cls);
                }
                return cls;
            }
            String name = MiscUtilities.classToFile(clazz);
            try {
                this.definePackage(clazz);
                ZipFile zipFile = this.jar.getZipFile();
                ZipEntry entry = zipFile.getEntry(name);
                if (entry == null) {
                    throw new ClassNotFoundException(clazz);
                }
                InputStream in = zipFile.getInputStream(entry);
                int len = (int)entry.getSize();
                byte[] data = new byte[len];
                int success = 0;
                int offset = 0;
                while (success < len) {
                    if ((success = in.read(data, offset += success, len -= success)) != -1) continue;
                    Log.log(9, this, "Failed to load class " + clazz + " from " + zipFile.getName());
                    throw new ClassNotFoundException(clazz);
                }
                cls = this.defineClass(clazz, data, 0, data.length);
                if (resolveIt) {
                    this.resolveClass(cls);
                }
                return cls;
            }
            catch (IOException io) {
                Log.log(9, this, io);
                throw new ClassNotFoundException(clazz);
            }
        }
    }

    private void definePackage(String clazz) throws IOException {
        String name;
        int idx = clazz.lastIndexOf(46);
        if (idx != -1 && this.getDefinedPackage(name = clazz.substring(0, idx)) == null) {
            this.definePackage(name, new JarFile(this.jar.getFile()).getManifest());
        }
    }

    private static String getMfValue(Attributes sectionAttrs, Attributes mainAttrs, Attributes.Name name) {
        String value = null;
        if (sectionAttrs != null) {
            value = sectionAttrs.getValue(name);
        } else if (mainAttrs != null) {
            value = mainAttrs.getValue(name);
        }
        return value;
    }

    private void definePackage(String name, Manifest mf) {
        if (mf == null) {
            this.definePackage(name, null, null, null, null, null, null, null);
            return;
        }
        Attributes sa = mf.getAttributes(name.replace('.', '/') + "/");
        Attributes ma = mf.getMainAttributes();
        URL sealBase = null;
        if (Boolean.parseBoolean(JARClassLoader.getMfValue(sa, ma, Attributes.Name.SEALED))) {
            try {
                sealBase = this.jar.getFile().toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.definePackage(name, JARClassLoader.getMfValue(sa, ma, Attributes.Name.SPECIFICATION_TITLE), JARClassLoader.getMfValue(sa, ma, Attributes.Name.SPECIFICATION_VERSION), JARClassLoader.getMfValue(sa, ma, Attributes.Name.SPECIFICATION_VENDOR), JARClassLoader.getMfValue(sa, ma, Attributes.Name.IMPLEMENTATION_TITLE), JARClassLoader.getMfValue(sa, ma, Attributes.Name.IMPLEMENTATION_VERSION), JARClassLoader.getMfValue(sa, ma, Attributes.Name.IMPLEMENTATION_VENDOR), sealBase);
    }

    private Class loadFromParent(String clazz) throws ClassNotFoundException {
        ClassLoader parentLoader = this.getClass().getClassLoader();
        Class<?> cls = parentLoader != null ? parentLoader.loadClass(clazz) : this.findSystemClass(clazz);
        return cls;
    }

    static {
        classHash = new Hashtable<String, Object>();
        resourcesHash = new HashMap<String, Object>();
    }
}

