/*
 * Decompiled with CFR 0.152.
 */
package isabelle.kodkodi;

import isabelle.kodkodi.Context;
import isabelle.kodkodi.KodkodiLexer;
import isabelle.kodkodi.KodkodiParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;

public final class Kodkodi {
    private static final int DEFAULT_PORT = 9128;
    private static boolean verbose;
    private static boolean solveAll;
    private static boolean prove;
    private static int maxSolutions;
    private static boolean cleanUpInst;
    private static int maxMsecs;
    private static int maxThreads;
    private static boolean server;
    private static ServerSocket serverSocket;
    private static Socket clientSocket;
    private static int port;
    private static PrintWriter out;
    private static BufferedReader in;

    private static void printVersion() {
        System.out.println("Kodkodi version 1.5.7 (07-Oct-2021)");
    }

    private static void printUsageAndExit(int n) {
        Kodkodi.printVersion();
        (n == 0 ? System.out : System.err).println("Usage: java isabelle.kodkodi.Kodkodi [options]\noptions:\n  -help               Show usage and exit\n  -version            Show version number and exit\n  -verbose            Produce more output\n  -solve-all          Output all solutions for each problem\n  -prove              Output minimal unsatisfiable core\n  -max-solutions      Maximum number of solutions to generate (default: inf.)\n  -clean-up-inst      Remove trivial parts of instance from output\n  -max-msecs <num>    Maximum running time in milliseconds\n  -max-threads <num>  Maximum number of simultaneous threads (default: " + Runtime.getRuntime().availableProcessors() + ")\n" + "  -server             Run as TCP server\n" + "  -port <number>      Listen to specified port (default: " + 9128 + ")\n");
        System.exit(n);
    }

    private static String callSolver(InputStream inputStream) {
        String string;
        block10: {
            string = new String();
            try {
                int n;
                KodkodiParser kodkodiParser;
                KodkodiLexer kodkodiLexer;
                block9: {
                    Object object;
                    if (maxMsecs > 0) {
                        object = new Timer();
                        ((Timer)object).schedule((TimerTask)new ExitTask(), maxMsecs);
                    }
                    object = Executors.newFixedThreadPool(maxThreads);
                    ANTLRInputStream aNTLRInputStream = new ANTLRInputStream(inputStream);
                    kodkodiLexer = new KodkodiLexer((CharStream)aNTLRInputStream);
                    kodkodiParser = KodkodiParser.create(new Context(), (ExecutorService)object, verbose, solveAll, prove, maxSolutions, cleanUpInst, kodkodiLexer);
                    n = 0;
                    try {
                        string = kodkodiParser.problems();
                    }
                    catch (RecognitionException recognitionException) {
                        if (kodkodiParser == null) break block9;
                        kodkodiParser.reportError(recognitionException);
                    }
                }
                if (kodkodiParser.getTokenStream().LA(1) != -1) {
                    System.err.println("Error: trailing tokens");
                    if (!server) {
                        System.exit(1);
                    }
                }
                n += kodkodiParser.getNumberOfSyntaxErrors() + kodkodiLexer.getNumberOfSyntaxErrors();
                if (!server) {
                    System.exit(n > 0 ? 1 : 0);
                }
            }
            catch (Throwable throwable) {
                String string2 = throwable.getMessage();
                if (string2.length() == 0) {
                    string2 = throwable.toString();
                }
                System.err.println("Error: " + string2);
                if (server) break block10;
                System.exit(1);
            }
        }
        return string;
    }

    private static void setupServer() throws IOException {
        try {
            serverSocket = new ServerSocket(port);
        }
        catch (IOException iOException) {
            System.err.println("Could not listen on port " + port + ".");
            System.exit(1);
        }
        System.out.println("Kodkod server listening for clients on port " + port + "...");
        try {
            clientSocket = serverSocket.accept();
        }
        catch (IOException iOException) {
            System.err.println("Accept failed.");
            System.exit(1);
        }
        out = new PrintWriter(clientSocket.getOutputStream(), true);
        in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
    }

    public static void solverLoop() throws IOException {
        String string = "\n";
        out.println("Say 'Bye;', or ask me a semicolon-terminated problem");
        while (true) {
            char c;
            if ((c = (char)in.read()) != ';') {
                string = string + c;
                continue;
            }
            string = string.substring(1, string.length());
            if ((string = string + c).equals("Bye;")) break;
            System.out.println("Client: " + string);
            String string2 = Kodkodi.callSolver(new ByteArrayInputStream(string.getBytes("UTF-8")));
            out.println(string2 + ";");
            string = "";
        }
        out.println("Bye;");
        out.close();
        in.close();
        clientSocket.close();
        serverSocket.close();
    }

    public static void main(String[] stringArray) {
        verbose = false;
        solveAll = false;
        prove = false;
        maxSolutions = Integer.MAX_VALUE;
        cleanUpInst = false;
        maxMsecs = 0;
        maxThreads = Runtime.getRuntime().availableProcessors();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-help")) {
                    Kodkodi.printUsageAndExit(0);
                    continue;
                }
                if (stringArray[i].equals("-version")) {
                    Kodkodi.printVersion();
                    System.exit(0);
                    continue;
                }
                if (stringArray[i].equals("-verbose")) {
                    verbose = true;
                    continue;
                }
                if (stringArray[i].equals("-solve-all")) {
                    solveAll = true;
                    continue;
                }
                if (stringArray[i].equals("-prove")) {
                    prove = true;
                    continue;
                }
                if (stringArray[i].equals("-max-solutions")) {
                    try {
                        maxSolutions = Integer.parseInt(stringArray[++i]);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        Kodkodi.printUsageAndExit(1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Kodkodi.printUsageAndExit(1);
                    }
                    continue;
                }
                if (stringArray[i].equals("-clean-up-inst")) {
                    cleanUpInst = true;
                    continue;
                }
                if (stringArray[i].equals("-max-msecs")) {
                    try {
                        maxMsecs = Integer.parseInt(stringArray[++i]);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        Kodkodi.printUsageAndExit(1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Kodkodi.printUsageAndExit(1);
                    }
                    continue;
                }
                if (stringArray[i].equals("-max-threads")) {
                    try {
                        maxThreads = Integer.parseInt(stringArray[++i]);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        Kodkodi.printUsageAndExit(1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Kodkodi.printUsageAndExit(1);
                    }
                    continue;
                }
                if (stringArray[i].equals("-server")) {
                    server = true;
                    continue;
                }
                if (stringArray[i].equals("-port")) {
                    try {
                        port = Integer.parseInt(stringArray[++i]);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        Kodkodi.printUsageAndExit(1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Kodkodi.printUsageAndExit(1);
                    }
                    continue;
                }
                Kodkodi.printUsageAndExit(1);
            }
            if (server) {
                Kodkodi.setupServer();
                Kodkodi.solverLoop();
            } else {
                InputStream inputStream = System.in;
                Kodkodi.callSolver(inputStream);
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null || string.length() == 0) {
                string = exception.toString();
            }
            System.err.println("Error: " + string);
            System.exit(1);
        }
    }

    static {
        server = false;
        serverSocket = null;
        clientSocket = null;
        port = 9128;
    }

    private static final class ExitTask
    extends TimerTask {
        private ExitTask() {
        }

        @Override
        public void run() {
            System.err.println("Ran out of time");
            System.exit(2);
        }
    }
}

