/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.queries.function.valuesource.VectorValueSource;
import org.apache.lucene.search.IndexSearcher;

public class HaversineConstFunction
extends ValueSource {
    private final double latCenter;
    private final double lonCenter;
    private final VectorValueSource p2;
    private final ValueSource latSource;
    private final ValueSource lonSource;
    private final double latCenterRad_cos;
    private static final double EARTH_MEAN_DIAMETER = 12742.0175428;

    public HaversineConstFunction(double latCenter, double lonCenter, VectorValueSource vs) {
        this.latCenter = latCenter;
        this.lonCenter = lonCenter;
        this.p2 = vs;
        this.latSource = (ValueSource)this.p2.getSources().get(0);
        this.lonSource = (ValueSource)this.p2.getSources().get(1);
        this.latCenterRad_cos = Math.cos(latCenter * (Math.PI / 180));
    }

    protected String name() {
        return "geodist";
    }

    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues latVals = this.latSource.getValues(context, readerContext);
        final FunctionValues lonVals = this.lonSource.getValues(context, readerContext);
        final double latCenterRad = this.latCenter * (Math.PI / 180);
        final double lonCenterRad = this.lonCenter * (Math.PI / 180);
        final double latCenterRad_cos = this.latCenterRad_cos;
        return new DoubleDocValues(this){

            public double doubleVal(int doc) throws IOException {
                double latRad = latVals.doubleVal(doc) * (Math.PI / 180);
                double lonRad = lonVals.doubleVal(doc) * (Math.PI / 180);
                double diffX = latCenterRad - latRad;
                double diffY = lonCenterRad - lonRad;
                double hsinX = Math.sin(diffX * 0.5);
                double hsinY = Math.sin(diffY * 0.5);
                double h = hsinX * hsinX + latCenterRad_cos * Math.cos(latRad) * hsinY * hsinY;
                return 12742.0175428 * Math.atan2(Math.sqrt(h), Math.sqrt(1.0 - h));
            }

            public String toString(int doc) throws IOException {
                return HaversineConstFunction.this.name() + "(" + latVals.toString(doc) + "," + lonVals.toString(doc) + "," + HaversineConstFunction.this.latCenter + "," + HaversineConstFunction.this.lonCenter + ")";
            }
        };
    }

    public void createWeight(Map<Object, Object> context, IndexSearcher searcher) throws IOException {
        this.latSource.createWeight(context, searcher);
        this.lonSource.createWeight(context, searcher);
    }

    public boolean equals(Object o) {
        if (!(o instanceof HaversineConstFunction)) {
            return false;
        }
        HaversineConstFunction other = (HaversineConstFunction)((Object)o);
        return this.latCenter == other.latCenter && this.lonCenter == other.lonCenter && this.p2.equals((Object)other.p2);
    }

    public int hashCode() {
        int result = this.p2.hashCode();
        long temp = Double.doubleToRawLongBits(this.latCenter);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToRawLongBits(this.lonCenter);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String description() {
        return this.name() + "(" + this.p2 + "," + this.latCenter + "," + this.lonCenter + ")";
    }
}

