/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.api.Api;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.HealthCheckHandler;
import org.apache.solr.handler.admin.LoggingHandler;
import org.apache.solr.handler.admin.PropertiesRequestHandler;
import org.apache.solr.handler.admin.SystemInfoHandler;
import org.apache.solr.handler.admin.ThreadDumpHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;

public class InfoHandler
extends RequestHandlerBase {
    protected final CoreContainer coreContainer;
    private Map<String, RequestHandlerBase> handlers = new ConcurrentHashMap<String, RequestHandlerBase>();

    public InfoHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.handlers.put("threads", new ThreadDumpHandler());
        this.handlers.put("properties", new PropertiesRequestHandler(coreContainer));
        this.handlers.put("logging", new LoggingHandler(coreContainer));
        this.handlers.put("system", new SystemInfoHandler(coreContainer));
        if (coreContainer.getHealthCheckHandler() == null) {
            throw new IllegalStateException("HealthCheckHandler needs to be initialized before creating InfoHandler");
        }
        this.handlers.put("health", coreContainer.getHealthCheckHandler());
    }

    @Override
    public final void init(NamedList<?> args) {
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.getCoreContainer();
        if (cores == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        String path = (String)req.getContext().get("path");
        this.handle(req, rsp, path);
    }

    private void handle(SolrQueryRequest req, SolrQueryResponse rsp, String path) {
        int i = path.lastIndexOf(47);
        String name = path.substring(i + 1, path.length());
        RequestHandlerBase handler = this.handlers.get(name.toLowerCase(Locale.ROOT));
        if (handler == null) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No handler by name " + name + " available names are " + this.handlers.keySet());
        }
        handler.handleRequest(req, rsp);
        rsp.setHttpCaching(false);
    }

    @Override
    public String getDescription() {
        return "System Information";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    public PropertiesRequestHandler getPropertiesHandler() {
        return (PropertiesRequestHandler)this.handlers.get("properties");
    }

    public ThreadDumpHandler getThreadDumpHandler() {
        return (ThreadDumpHandler)this.handlers.get("threads");
    }

    public LoggingHandler getLoggingHandler() {
        return (LoggingHandler)this.handlers.get("logging");
    }

    public SystemInfoHandler getSystemInfoHandler() {
        return (SystemInfoHandler)this.handlers.get("system");
    }

    public HealthCheckHandler getHealthCheckHandler() {
        return (HealthCheckHandler)this.handlers.get("health");
    }

    protected void setPropertiesHandler(PropertiesRequestHandler propertiesHandler) {
        this.handlers.put("properties", propertiesHandler);
    }

    protected void setThreadDumpHandler(ThreadDumpHandler threadDumpHandler) {
        this.handlers.put("threads", threadDumpHandler);
    }

    protected void setLoggingHandler(LoggingHandler loggingHandler) {
        this.handlers.put("logging", loggingHandler);
    }

    protected void setSystemInfoHandler(SystemInfoHandler systemInfoHandler) {
        this.handlers.put("system", systemInfoHandler);
    }

    protected void setHealthCheckHandler(HealthCheckHandler healthCheckHandler) {
        this.handlers.put("health", healthCheckHandler);
    }

    @Override
    public SolrRequestHandler getSubHandler(String subPath) {
        return this;
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public Collection<Api> getApis() {
        ArrayList<Api> list = new ArrayList<Api>();
        list.addAll(this.handlers.get("threads").getApis());
        list.addAll(this.handlers.get("properties").getApis());
        list.addAll(this.handlers.get("logging").getApis());
        list.addAll(this.handlers.get("system").getApis());
        list.addAll(this.handlers.get("health").getApis());
        return List.copyOf(list);
    }

    @Override
    public Collection<Class<? extends JerseyResource>> getJerseyResources() {
        ArrayList<Class<? extends JerseyResource>> apis = new ArrayList<Class<? extends JerseyResource>>();
        apis.addAll(this.handlers.get("threads").getJerseyResources());
        apis.addAll(this.handlers.get("properties").getJerseyResources());
        apis.addAll(this.handlers.get("logging").getJerseyResources());
        apis.addAll(this.handlers.get("system").getJerseyResources());
        apis.addAll(this.handlers.get("health").getJerseyResources());
        return apis;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        String path = request.getResource();
        String lastPath = path.substring(path.lastIndexOf(47) + 1);
        RequestHandlerBase handler = this.handlers.get(lastPath.toLowerCase(Locale.ROOT));
        if (handler != null) {
            return handler.getPermissionName(request);
        }
        return null;
    }
}

