/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorListPlugin;
import errorlist.ErrorSource;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Arrays;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public class ErrorHighlight
extends TextAreaExtension {
    private final EditPane editPane;
    private final Segment seg;
    private final Point point;

    public ErrorHighlight(EditPane editPane) {
        this.editPane = editPane;
        this.seg = new Segment();
        this.point = new Point();
    }

    public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
        ErrorSource[] errorSources = ErrorSource.getErrorSources();
        if (errorSources == null) {
            return;
        }
        FontMetrics fm = this.editPane.getTextArea().getPainter().getFontMetrics();
        for (ErrorSource errorSource : errorSources) {
            ErrorSource.Error[] errors = errorSource.getLineErrors(this.editPane.getBuffer().getSymlinkPath(), physicalLine, physicalLine);
            if (errors == null) continue;
            Arrays.stream(errors).forEach(error -> this.paintError((ErrorSource.Error)error, gfx, physicalLine, start, end, y + fm.getAscent()));
        }
    }

    public String getToolTipText(int x, int y) {
        ErrorSource[] errorSources = ErrorSource.getErrorSources();
        if (!this.editPane.getBuffer().isLoaded()) {
            return null;
        }
        JEditTextArea textArea = this.editPane.getTextArea();
        int offset = textArea.xyToOffset(x, y);
        if (offset == -1) {
            return null;
        }
        int line = textArea.getLineOfOffset(offset);
        for (ErrorSource errorSource : errorSources) {
            ErrorSource.Error[] lineErrors = errorSource.getLineErrors(this.editPane.getBuffer().getSymlinkPath(), line, line);
            if (lineErrors == null) continue;
            int lineStart = textArea.getLineStartOffset(line);
            for (ErrorSource.Error error : lineErrors) {
                int start = error.getStartOffset();
                int end = error.getEndOffset();
                if ((offset < start + lineStart || offset > end + lineStart) && (start != 0 || end != 0)) continue;
                return error.getErrorMessage();
            }
        }
        return null;
    }

    private void paintError(ErrorSource.Error error, Graphics2D gfx, int line, int _start, int _end, int y) {
        JEditTextArea textArea = this.editPane.getTextArea();
        int lineStart = textArea.getLineStartOffset(line);
        int start = error.getStartOffset();
        int end = error.getEndOffset();
        if (start == 0 && end == 0) {
            textArea.getLineText(line, this.seg);
            for (int j = 0; j < this.seg.count && Character.isWhitespace(this.seg.array[this.seg.offset + j]); ++j) {
                ++start;
            }
            end = this.seg.count;
        }
        if (start + lineStart >= _end || end + lineStart <= _start) {
            return;
        }
        int startX = start + lineStart >= _start ? textArea.offsetToXY((int)line, (int)start, (Point)this.point).x : 0;
        int endX = end + lineStart >= _end ? textArea.offsetToXY((int)line, (int)(_end - lineStart - 1), (Point)this.point).x : textArea.offsetToXY((int)line, (int)end, (Point)this.point).x;
        gfx.setColor(ErrorListPlugin.getErrorColor(error.getErrorType()));
        if ("squiggle".equals(jEdit.getProperty((String)"error-list.underlineStyle"))) {
            ErrorHighlight.paintSquiggle(gfx, startX, endX, y + 2);
        } else {
            ErrorHighlight.paintLine(gfx, startX, endX, y + 1);
        }
    }

    private static void paintLine(Graphics2D gfx, int x1, int x2, int y) {
        gfx.drawLine(x1, y, x2, y);
    }

    protected static void paintSquiggle(Graphics gfx, int x1, int x2, int y) {
        int delta = -2;
        for (int x = x1; x < x2; x += 2) {
            gfx.drawLine(x, y, x + 2, y + delta);
            y += delta;
            delta = -delta;
        }
    }
}

