{- generated by Isabelle -}

{-  Title:      Isabelle/Timing.hs
    Author:     Makarius
    LICENSE:    BSD 3-clause (Isabelle)

Support for time measurement.

See "$ISABELLE_HOME/src/Pure/General/timing.ML"
and "$ISABELLE_HOME/src/Pure/General/timing.scala"
-}

module Isabelle.Timing (
  Timing (..), zero, is_zero, is_relevant
)
where

import qualified Isabelle.Time as Time
import Isabelle.Time (Time)

data Timing = Timing {elapsed :: Time, cpu :: Time, gc :: Time}
  deriving (Show, Eq)

zero :: Timing
zero = Timing Time.zero Time.zero Time.zero

is_zero :: Timing -> Bool
is_zero t = Time.is_zero (elapsed t) && Time.is_zero (cpu t) && Time.is_zero (gc t)

is_relevant :: Timing -> Bool
is_relevant t = Time.is_relevant (elapsed t) || Time.is_relevant (cpu t) || Time.is_relevant (gc t)
