{- generated by Isabelle -}

{-  Title:      Isabelle/Options.hs
    Author:     Makarius
    LICENSE:    BSD 3-clause (Isabelle)

System options with external string representation.

See "$ISABELLE_HOME/src/Pure/System/options.ML"
and "$ISABELLE_HOME/src/Pure/System/options.scala"
-}

{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE InstanceSigs #-}

module Isabelle.Options (
  boolT, intT, realT, stringT, unknownT,

  T, typ, bool, int, real, seconds, string,
  decode
)
where

import qualified Data.Map.Strict as Map
import Data.Map.Strict (Map)
import qualified Isabelle.Properties as Properties
import Isabelle.Bytes (Bytes)
import qualified Isabelle.Value as Value
import qualified Isabelle.Time as Time
import Isabelle.Time (Time)
import Isabelle.Library
import qualified Isabelle.XML.Decode as Decode
import Isabelle.XML.Classes (Decode (..))


{- representation -}

boolT :: Bytes
boolT = "bool"

intT :: Bytes
intT = "int"

realT :: Bytes
realT = "real"

stringT :: Bytes
stringT = "string"

unknownT :: Bytes
unknownT = "unknown"

data Opt = Opt {
  _pos :: Properties.T,
  _name :: Bytes,
  _typ :: Bytes,
  _value :: Bytes }

newtype T = Options (Map Bytes Opt)


{- check -}

check_name :: T -> Bytes -> Opt
check_name (Options map) name =
  case Map.lookup name map of
    Just opt | _typ opt /= unknownT -> opt
    _ -> error (make_string ("Unknown system option " <> quote name))

check_type :: T -> Bytes -> Bytes -> Opt
check_type options name typ =
  let
    opt = check_name options name
    t = _typ opt
  in
    if t == typ then opt
    else error (make_string ("Ill-typed system option " <> quote name <> " : " <> t <> " vs. " <> typ))


{- get typ -}

typ :: T -> Bytes -> Bytes
typ options name = _typ (check_name options name)


{- get value -}

get :: Bytes -> (Bytes -> Maybe a) -> T -> Bytes -> a
get typ parse options name =
  let opt = check_type options name typ in
    case parse (_value opt) of
      Just x -> x
      Nothing ->
        error (make_string ("Malformed value for system option " <> quote name <>
          " : " <> typ <> " =\n" <> quote (_value opt)))

bool :: T -> Bytes -> Bool
bool = get boolT Value.parse_bool

int :: T -> Bytes -> Int
int = get intT Value.parse_int

real :: T -> Bytes -> Double
real = get realT Value.parse_real

seconds :: T -> Bytes -> Time
seconds options = Time.seconds . real options

string :: T -> Bytes -> Bytes
string = get stringT Just


{- decode -}

instance Decode T where
  decode :: Decode.T T
  decode =
    let
      decode_entry :: Decode.T (Bytes, Opt)
      decode_entry body =
        let
          (pos, (name, (typ, value))) =
            Decode.pair Decode.properties (Decode.pair Decode.string (Decode.pair Decode.string Decode.string)) body
        in (name, Opt { _pos = pos, _name = name, _typ = typ, _value = value })
    in Options . Map.fromList . Decode.list decode_entry
