{- generated by Isabelle -}

{-
Authors: Makarius (2021)

Constants for Isabelle/Naproche.
-}

{-# LANGUAGE OverloadedStrings #-}

module Isabelle.Naproche (
  naproche_prove, naproche_check, naproche_skipfail,
  naproche_pos_id, naproche_pos_file, naproche_pos_shift,
  naproche_isabelle,

  cancel_program, forthel_program,

  threads_command, serials_command, cert_terms_command, print_terms_command,
  print_sequents_command, define_problems_command,

  output_state_command, output_writeln_command, output_information_command,
  output_tracing_command, output_warning_command, output_legacy_feature_command,
  output_error_command, output_report_command,

  iT, is_iT, mk_this, dest_this,

  map_const, fun_const, set_const, class_const, elem_const, obj_const,
  less_const, dom_const, pair_const, app_const, thesis_const
)
where

import Isabelle.Term
import Isabelle.Bytes (Bytes)


-- options

naproche_prove, naproche_check, naproche_skipfail :: Bytes
naproche_prove = "naproche_prove"
naproche_check = "naproche_check"
naproche_skipfail = "naproche_skipfail"

naproche_pos_id, naproche_pos_file, naproche_pos_shift :: Bytes
naproche_pos_id = "naproche_pos_id"
naproche_pos_file = "naproche_pos_file"
naproche_pos_shift = "naproche_pos_shift"

naproche_isabelle :: Bytes
naproche_isabelle = "naproche_isabelle"


-- programs in Haskell
-- (see "$NAPROCHE_HOME/src/SAD/Main.hs")

cancel_program :: Bytes
cancel_program = "cancel"

forthel_program :: Bytes
forthel_program = "forthel"


-- commands in ML

threads_command, serials_command, cert_terms_command, print_terms_command,
  print_sequents_command, define_problems_command :: Bytes
threads_command = "Naproche.threads"
serials_command = "Naproche.serials"
cert_terms_command = "Naproche.cert_terms"
print_terms_command = "Naproche.print_terms"
print_sequents_command = "Naproche.print_sequents"
define_problems_command = "Naproche.define_problems"

output_state_command, output_writeln_command, output_information_command,
  output_tracing_command, output_warning_command, output_legacy_feature_command,
  output_error_command, output_report_command :: Bytes
output_state_command = "Naproche.output_state"
output_writeln_command = "Naproche.output_writeln"
output_information_command = "Naproche.output_information"
output_tracing_command = "Naproche.output_tracing"
output_warning_command = "Naproche.output_warning"
output_legacy_feature_command = "Naproche.output_legacy_feature"
output_error_command = "Naproche.output_error"
output_report_command = "Naproche.output_report"


-- logic

iT :: Typ; is_iT :: Typ -> Bool
(iT, is_iT) = type_op0 "ZFC_Rudiments.V"

mk_this :: Typ -> Term; dest_this :: Term -> Maybe Typ
(mk_this, dest_this) = typed_op0 "Naproche.This"

map_const, fun_const, set_const, class_const, elem_const, obj_const,
  less_const, dom_const, pair_const, app_const, thesis_const :: Bytes
map_const = "Naproche.Map"
fun_const = "Naproche.Fun"
set_const = "Naproche.Set"
class_const = "Naproche.Class"
elem_const = "Naproche.Elem"
obj_const = "Naproche.Obj"
less_const = "Naproche.Less"
dom_const = "Naproche.Dom"
pair_const = "Naproche.Pair"
app_const = "Naproche.App"
thesis_const = "Naproche.Thesis"
