{- generated by Isabelle -}

{-  Title:      Isabelle/Bash.hs
    Author:     Makarius
    LICENSE:    BSD 3-clause (Isabelle)

Support for GNU bash.

See "$ISABELLE_HOME/src/Pure/System/bash.ML"
-}

{-# LANGUAGE OverloadedStrings #-}

module Isabelle.Bash (
  string, strings,

  Params,
  get_script, get_input, get_cwd, get_putenv, get_redirect,
  get_timeout, get_description,
  script, input, cwd, putenv, redirect, timeout, description,
  server_run, server_kill,
  server_uuid, server_interrupt, server_failure, server_result
)
where

import Text.Printf (printf)
import qualified Isabelle.Symbol as Symbol
import qualified Isabelle.Bytes as Bytes
import Isabelle.Bytes (Bytes)
import qualified Isabelle.Time as Time
import Isabelle.Time (Time)
import Isabelle.Library


{- concrete syntax -}

string :: Bytes -> Bytes
string str =
  if Bytes.null str then "\"\""
  else str |> Bytes.unpack |> map trans |> Bytes.concat
    where
      trans b =
        case Bytes.char b of
          '\t' -> "$'\\t'"
          '\n' -> "$'\\n'"
          '\f' -> "$'\\f'"
          '\r' -> "$'\\r'"
          c ->
            if Symbol.is_ascii_letter c || Symbol.is_ascii_digit c || c `elem` ("+,-./:_" :: String)
            then Bytes.singleton b
            else if b < 32 || b >= 127 then make_bytes (printf "$'\\x%02x'" b :: String)
            else "\\" <> Bytes.singleton b

strings :: [Bytes] -> Bytes
strings = implode_space . map string


{- server parameters -}

data Params = Params {
    _script :: Bytes,
    _input :: Bytes,
    _cwd :: Maybe Bytes,
    _putenv :: [(Bytes, Bytes)],
    _redirect :: Bool,
    _timeout :: Time,
    _description :: Bytes}
  deriving (Show, Eq)

get_script :: Params -> Bytes
get_script = _script

get_input :: Params -> Bytes
get_input = _input

get_cwd :: Params -> Maybe Bytes
get_cwd = _cwd

get_putenv :: Params -> [(Bytes, Bytes)]
get_putenv = _putenv

get_redirect :: Params -> Bool
get_redirect = _redirect

get_timeout :: Params -> Time
get_timeout = _timeout

get_description :: Params -> Bytes
get_description = _description

script :: Bytes -> Params
script script = Params script "" Nothing [] False Time.zero ""

input :: Bytes -> Params -> Params
input input params = params { _input = input }

cwd :: Bytes -> Params -> Params
cwd cwd params = params { _cwd = Just cwd }

putenv :: [(Bytes, Bytes)] -> Params -> Params
putenv putenv params = params { _putenv = putenv }

redirect :: Params -> Params
redirect params = params { _redirect = True }

timeout :: Time -> Params -> Params
timeout timeout params = params { _timeout = timeout }

description :: Bytes -> Params -> Params
description description params = params { _description = description }


{- server messages -}

server_run, server_kill :: Bytes
server_run = "run";
server_kill = "kill";

server_uuid, server_interrupt, server_failure, server_result :: Bytes
server_uuid = "uuid";
server_interrupt = "interrupt";
server_failure = "failure";
server_result = "result";
