{- generated by Isabelle -}

{-  Title:      Isabelle/Position.hs
    Author:     Makarius
    LICENSE:    BSD 3-clause (Isabelle)

Source positions starting from 1; values <= 0 mean "absent". Count Isabelle
symbols, not UTF8 bytes nor UTF16 characters. Position range specifies a
right-open interval offset .. end_offset (exclusive).

See "$ISABELLE_HOME/src/Pure/General/position.ML".
-}

{-# LANGUAGE OverloadedStrings #-}

module Isabelle.Position (
  T, line_of, column_of, offset_of, end_offset_of, label_of, file_of, id_of,
  start, none, label, put_file, file, file_only, put_id, id, id_only,
  symbol, symbol_explode, symbol_explode_string, shift_offsets,
  of_properties, properties_of, def_properties_of, entity_markup, make_entity_markup,
  Report, Report_Text, is_reported, is_reported_range, here,
  Range, no_range, no_range_position, range_position, range
)
where

import Prelude hiding (id)
import Data.Maybe (isJust, fromMaybe)
import Data.Bifunctor (first)
import qualified Isabelle.Properties as Properties
import qualified Isabelle.Bytes as Bytes
import qualified Isabelle.Value as Value
import Isabelle.Bytes (Bytes)
import qualified Isabelle.Markup as Markup
import qualified Isabelle.YXML as YXML
import Isabelle.Library
import qualified Isabelle.Symbol as Symbol
import Isabelle.Symbol (Symbol)


{- position -}

data T =
  Position {
    _line :: Int,
    _column :: Int,
    _offset :: Int,
    _end_offset :: Int,
    _label :: Bytes,
    _file :: Bytes,
    _id :: Bytes }
  deriving (Eq, Ord)

valid, invalid :: Int -> Bool
valid i = i > 0
invalid = not . valid

maybe_valid :: Int -> Maybe Int
maybe_valid i = if valid i then Just i else Nothing

if_valid :: Int -> Int -> Int
if_valid i i' = if valid i then i' else i


{- fields -}

line_of, column_of, offset_of, end_offset_of :: T -> Maybe Int
line_of = maybe_valid . _line
column_of = maybe_valid . _column
offset_of = maybe_valid . _offset
end_offset_of = maybe_valid . _end_offset

label_of :: T -> Maybe Bytes
label_of = proper_string . _label

file_of :: T -> Maybe Bytes
file_of = proper_string . _file

id_of :: T -> Maybe Bytes
id_of = proper_string . _id


{- make position -}

start :: T
start = Position 1 1 1 0 Bytes.empty Bytes.empty Bytes.empty

none :: T
none = Position 0 0 0 0 Bytes.empty Bytes.empty Bytes.empty

label :: Bytes -> T -> T
label label pos = pos { _label = label }

put_file :: Bytes -> T -> T
put_file file pos = pos { _file = file }

file :: Bytes -> T
file file = put_file file start

file_only :: Bytes -> T
file_only file = put_file file none

put_id :: Bytes -> T -> T
put_id id pos = pos { _id = id }

id :: Bytes -> T
id id = put_id id start

id_only :: Bytes -> T
id_only id = put_id id none


{- count position -}

count_line :: Symbol -> Int -> Int
count_line "\n" line = if_valid line (line + 1)
count_line _ line = line

count_column :: Symbol -> Int -> Int
count_column "\n" column = if_valid column 1
count_column s column = if Symbol.not_eof s then if_valid column (column + 1) else column

count_offset :: Symbol -> Int -> Int
count_offset s offset = if Symbol.not_eof s then if_valid offset (offset + 1) else offset

symbol :: Symbol -> T -> T
symbol s pos =
  pos {
    _line = count_line s (_line pos),
    _column = count_column s (_column pos),
    _offset = count_offset s (_offset pos) }

symbol_explode :: BYTES a => a -> T -> T
symbol_explode = fold symbol . Symbol.explode . make_bytes

symbol_explode_string :: String -> T -> T
symbol_explode_string = symbol_explode


{- shift offsets -}

shift_offsets :: Int -> T -> T
shift_offsets shift pos = pos { _offset = offset', _end_offset = end_offset' }
  where
    offset = _offset pos
    end_offset = _end_offset pos
    offset' = if invalid offset || invalid shift then offset else offset + shift
    end_offset' = if invalid end_offset || invalid shift then end_offset else end_offset + shift


{- markup properties -}

get_string :: Properties.T -> Bytes -> Bytes
get_string props name = fromMaybe "" (Properties.get_value Just props name)

get_int :: Properties.T -> Bytes -> Int
get_int props name = fromMaybe 0 (Properties.get_value Value.parse_int props name)

of_properties :: Properties.T -> T
of_properties props =
  none {
    _line = get_int props Markup.lineN,
    _offset = get_int props Markup.offsetN,
    _end_offset = get_int props Markup.end_offsetN,
    _label = get_string props Markup.labelN,
    _file = get_string props Markup.fileN,
    _id = get_string props Markup.idN }

string_entry :: Bytes -> Bytes -> Properties.T
string_entry k s = if Bytes.null s then [] else [(k, s)]

int_entry :: Bytes -> Int -> Properties.T
int_entry k i = if invalid i then [] else [(k, Value.print_int i)]

properties_of :: T -> Properties.T
properties_of pos =
  int_entry Markup.lineN (_line pos) ++
  int_entry Markup.offsetN (_offset pos) ++
  int_entry Markup.end_offsetN (_end_offset pos) ++
  string_entry Markup.labelN (_label pos) ++
  string_entry Markup.fileN (_file pos) ++
  string_entry Markup.idN (_id pos)

def_properties_of :: T -> Properties.T
def_properties_of = properties_of #> map (first Markup.def_name)

entity_markup :: Bytes -> (Bytes, T) -> Markup.T
entity_markup kind (name, pos) =
  Markup.entity kind name |> Markup.properties (def_properties_of pos)

make_entity_markup :: Bool -> Int -> Bytes -> (Bytes, T) -> Markup.T
make_entity_markup def serial kind (name, pos) =
  let
    props =
      if def then (Markup.defN, Value.print_int serial) : properties_of pos
      else (Markup.refN, Value.print_int serial) : def_properties_of pos
  in Markup.entity kind name |> Markup.properties props


{- reports -}

type Report = (T, Markup.T)
type Report_Text = (Report, Bytes)

is_reported :: T -> Bool
is_reported pos = isJust (offset_of pos) && isJust (id_of pos)

is_reported_range :: T -> Bool
is_reported_range pos = is_reported pos && isJust (end_offset_of pos)


{- here: user output -}

here :: T -> Bytes
here pos = if Bytes.null s2 then "" else s1 <> m1 <> s2 <> m2
  where
    props = properties_of pos
    (m1, m2) = YXML.output_markup (Markup.properties props Markup.position)
    (s1, s2) =
      case (line_of pos, file_of pos) of
        (Just i, Nothing) -> (" ", "(line " <> Value.print_int i <> ")")
        (Just i, Just name) -> (" ", "(line " <> Value.print_int i <> " of " <> quote name <> ")")
        (Nothing, Just name) -> (" ", "(file " <> quote name <> ")")
        _ -> if is_reported pos then ("", "\092<^here>") else ("", "")


{- range -}

type Range = (T, T)

no_range :: Range
no_range = (none, none)

no_range_position :: T -> T
no_range_position pos = pos { _end_offset = 0 }

range_position :: Range -> T
range_position (pos, pos') = pos { _end_offset = _offset pos' }

range :: Range -> Range
range (pos, pos') = (range_position (pos, pos'), no_range_position pos')
