{- generated by Isabelle -}

{-  Title:      Isabelle/Isabelle_System.hs
    Author:     Makarius
    LICENSE:    BSD 3-clause (Isabelle)

Isabelle system support.

See "$ISABELLE_HOME/src/Pure/System/isabelle_system.ML"
and "$ISABELLE_HOME/src/Pure/System/isabelle_system.scala"
-}

{-# LANGUAGE OverloadedStrings #-}

module Isabelle.Isabelle_System (
  bash_process, bash_process0
)
where

import Data.Maybe (fromMaybe)
import Control.Exception (throw, AsyncException (UserInterrupt))
import Network.Socket (Socket)
import qualified Isabelle.Bytes as Bytes
import Isabelle.Bytes (Bytes)
import qualified Isabelle.Byte_Message as Byte_Message
import qualified Isabelle.Time as Time
import Isabelle.Timing (Timing (..))
import qualified Isabelle.Options as Options
import qualified Isabelle.Bash as Bash
import qualified Isabelle.Process_Result as Process_Result
import qualified Isabelle.XML.Encode as Encode
import qualified Isabelle.YXML as YXML
import qualified Isabelle.Value as Value
import qualified Isabelle.Server as Server
import qualified Isabelle.Isabelle_Thread as Isabelle_Thread
import Isabelle.Library


{- bash_process -}

absolute_path :: Bytes -> Bytes  -- FIXME dummy
absolute_path = id

bash_process :: Options.T -> Bash.Params -> IO Process_Result.T
bash_process options = bash_process0 address password
  where
    address = Options.string options "bash_process_address"
    password = Options.string options "bash_process_password"

bash_process0 :: Bytes -> Bytes -> Bash.Params -> IO Process_Result.T
bash_process0 address password params = do
  Server.connection port password
    (\socket -> do
        isabelle_tmp <- getenv "ISABELLE_TMP"
        Byte_Message.write_message socket (run isabelle_tmp)
        loop Nothing socket)
  where
    port =
      case Bytes.try_unprefix Server.localhost_prefix address of
        Just port -> make_string port
        Nothing -> errorWithoutStackTrace "Bad bash_process server address"

    script = Bash.get_script params
    input = Bash.get_input params
    cwd = Bash.get_cwd params
    putenv = Bash.get_putenv params
    redirect = Bash.get_redirect params
    timeout = Bash.get_timeout params
    description = Bash.get_description params

    run :: Bytes -> [Bytes]
    run isabelle_tmp =
     [Bash.server_run, script, input,
      YXML.string_of_body (Encode.option (Encode.string . absolute_path) cwd),
      YXML.string_of_body
      (Encode.list (Encode.pair Encode.string Encode.string)
        (("ISABELLE_TMP", isabelle_tmp) : putenv)),
      Value.print_bool redirect,
      Value.print_real (Time.get_seconds timeout),
      description]

    kill :: Maybe Bytes -> IO ()
    kill maybe_uuid = do
      case maybe_uuid of
        Just uuid ->
          Server.connection port password (\socket ->
            Byte_Message.write_message socket [Bash.server_kill, uuid])
        Nothing -> return ()

    err = errorWithoutStackTrace "Malformed result from bash_process server"
    the = fromMaybe err

    loop :: Maybe Bytes -> Socket -> IO Process_Result.T
    loop maybe_uuid socket = do
      result <- Isabelle_Thread.bracket_resource (kill maybe_uuid) (Byte_Message.read_message socket)
      case result of
        Just [head, uuid] | head == Bash.server_uuid -> loop (Just uuid) socket
        Just [head] | head == Bash.server_interrupt -> throw UserInterrupt
        Just [head, msg] | head == Bash.server_failure -> errorWithoutStackTrace $ make_string msg
        Just (head : a : b : c : d : lines) | head == Bash.server_result ->
          let
            rc = the $ Value.parse_int a
            elapsed = Time.ms $ the $ Value.parse_int b
            cpu = Time.ms $ the $ Value.parse_int c
            timing = Timing elapsed cpu Time.zero
            n = the $ Value.parse_int d
            out_lines = take n lines
            err_lines = drop n lines
          in return $ Process_Result.make rc out_lines err_lines timing
        _ -> err
