/*
    Title:      KodkodiClient.java
    Author:     Hesam Samimi, UCLA
    License:    See COPYRIGHT and the copyright notice below for details.
*/

/*
 * Copyright (c) 1995 - 2008 Sun Microsystems, Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   - Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *
 *   - Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 *   - Neither the name of Sun Microsystems nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */ 

/*
  Requires Kodkodi server up on the localhost (via "kodkodi -server").
*/

package isabelle.kodkodi;

import java.io.*;
import java.net.*;

public class KodkodiClient
{
    private static final int DEFAULT_PORT = 9128;

    public static void main(String[] args) throws IOException {
        int port = DEFAULT_PORT;
        Socket kkSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;

        try {
            kkSocket = new Socket("localhost", port);
            out = new PrintWriter(kkSocket.getOutputStream(), true);
            in = new BufferedReader(
                             new InputStreamReader(kkSocket.getInputStream()));
        } catch (UnknownHostException e) {
            System.err.println("Unknown host \"localhost\".");
            System.exit(1);
        } catch (IOException e) {
            System.err.println("Unable to connect to \"localhost\".");
            System.exit(1);
        }

        BufferedReader stdIn = new BufferedReader(
                                           new InputStreamReader(System.in));
        String fromServer;
        String fromUser = "\n";
        char charIn;
        fromServer = in.readLine();
        System.out.println("Server: " + fromServer);
        while (true) {
            fromServer = "";
            System.out.print("> ");
            while ((charIn = (char)stdIn.read()) != ';') {
                fromUser += charIn;
            }
            fromUser = fromUser.substring(1,fromUser.length());
            fromUser += charIn;
            if (fromUser.equals("Bye;")) {
                out.println(fromUser);
                break;
            } else {
                out.println(fromUser);
                fromUser = "";
                while ((charIn = (char)in.read()) != ';') {
                    fromServer += charIn;
                }
                System.out.println("Server: " + fromServer);
            }
        }
        out.close();
        in.close();
        stdIn.close();
        kkSocket.close();
    }
}
