/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.mutable.FlatHashTable$;
import scala.collection.mutable.FlatHashTable$NullSentinel$;
import scala.collection.mutable.HashTable$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.hashing.package$;

public interface FlatHashTable<A>
extends HashUtils<A> {
    public static void $init$(FlatHashTable $this) {
        $this._loadFactor_$eq(FlatHashTable$.MODULE$.defaultLoadFactor());
        $this.table_$eq(new Object[$this.initialCapacity()]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), $this.initialCapacity()));
        $this.sizemap_$eq(null);
        $this.seedvalue_$eq($this.tableSizeSeed());
    }

    private boolean tableDebug() {
        return false;
    }

    public int _loadFactor();

    public void _loadFactor_$eq(int var1);

    public Object[] table();

    public void table_$eq(Object[] var1);

    public int tableSize();

    public void tableSize_$eq(int var1);

    public int threshold();

    public void threshold_$eq(int var1);

    public int[] sizemap();

    public void sizemap_$eq(int[] var1);

    public int seedvalue();

    public void seedvalue_$eq(int var1);

    public static int capacity$(FlatHashTable $this, int expectedSize) {
        return $this.capacity(expectedSize);
    }

    default public int capacity(int expectedSize) {
        return HashTable$.MODULE$.nextPositivePowerOfTwo(expectedSize);
    }

    public static int initialSize$(FlatHashTable $this) {
        return $this.initialSize();
    }

    default public int initialSize() {
        return 32;
    }

    public static int size$(FlatHashTable $this) {
        return $this.size();
    }

    default public int size() {
        return this.tableSize();
    }

    private int initialCapacity() {
        return this.capacity(this.initialSize());
    }

    public static int randomSeed$(FlatHashTable $this) {
        return $this.randomSeed();
    }

    default public int randomSeed() {
        return FlatHashTable$.MODULE$.seedGenerator().get().nextInt();
    }

    public static int tableSizeSeed$(FlatHashTable $this) {
        return $this.tableSizeSeed();
    }

    default public int tableSizeSeed() {
        return Integer.bitCount(this.table().length - 1);
    }

    public static void init$(FlatHashTable $this, ObjectInputStream in, Function1 f) {
        $this.init(in, f);
    }

    default public void init(ObjectInputStream in, Function1<A, BoxedUnit> f) {
        this._loadFactor_$eq(in.readInt());
        if (this._loadFactor() <= 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        int size = in.readInt();
        this.tableSize_$eq(0);
        if (size < 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.table_$eq(new Object[this.capacity(FlatHashTable$.MODULE$.sizeForThreshold(size, this._loadFactor()))]);
        this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold(this._loadFactor(), this.table().length));
        this.seedvalue_$eq(in.readInt());
        boolean smDefined = in.readBoolean();
        if (smDefined) {
            this.sizeMapInit(this.table().length);
        } else {
            this.sizemap_$eq(null);
        }
        for (int index = 0; index < size; ++index) {
            Object elem = this.entryToElem(in.readObject());
            f.apply(elem);
            this.addElem(elem);
        }
    }

    public static void serializeTo$(FlatHashTable $this, ObjectOutputStream out) {
        $this.serializeTo(out);
    }

    default public void serializeTo(ObjectOutputStream out) {
        out.writeInt(this._loadFactor());
        out.writeInt(this.tableSize());
        out.writeInt(this.seedvalue());
        out.writeBoolean(this.isSizeMapDefined());
        this.iterator().foreach((Function1)(JProcedure1 & Serializable)x$0 -> out.writeObject(x$0));
    }

    public static Option findEntry$(FlatHashTable $this, Object elem) {
        return $this.findEntry(elem);
    }

    default public Option<A> findEntry(A elem) {
        None$ none$;
        Object object = this.findElemImpl(elem);
        if (object == null) {
            none$ = None$.MODULE$;
        } else {
            Object entry = object;
            none$ = Some$.MODULE$.apply(this.entryToElem(entry));
        }
        return none$;
    }

    public static boolean containsElem$(FlatHashTable $this, Object elem) {
        return $this.containsElem(elem);
    }

    default public boolean containsElem(A elem) {
        return this.findElemImpl(elem) != null;
    }

    private Object findElemImpl(A elem) {
        Object searchEntry = this.elemToEntry(elem);
        int h = this.index(searchEntry.hashCode());
        Object curEntry = this.table()[h];
        while (curEntry != null && !BoxesRunTime.equals((Object)curEntry, (Object)searchEntry)) {
            h = (h + 1) % this.table().length;
            curEntry = this.table()[h];
        }
        return curEntry;
    }

    public static boolean addElem$(FlatHashTable $this, Object elem) {
        return $this.addElem(elem);
    }

    default public boolean addElem(A elem) {
        return this.addEntry(this.elemToEntry(elem));
    }

    public static boolean addEntry$(FlatHashTable $this, Object newEntry) {
        return $this.addEntry(newEntry);
    }

    default public boolean addEntry(Object newEntry) {
        int h = this.index(newEntry.hashCode());
        Object curEntry = this.table()[h];
        while (curEntry != null) {
            if (BoxesRunTime.equals((Object)curEntry, (Object)newEntry)) {
                return false;
            }
            h = (h + 1) % this.table().length;
            curEntry = this.table()[h];
        }
        this.table()[h] = newEntry;
        this.tableSize_$eq(this.tableSize() + 1);
        this.nnSizeMapAdd(h);
        if (this.tableSize() >= this.threshold()) {
            this.growTable();
        }
        return true;
    }

    public static boolean removeElem$(FlatHashTable $this, Object elem) {
        return $this.removeElem(elem);
    }

    default public boolean removeElem(A elem) {
        if (this.tableDebug()) {
            this.checkConsistent();
        }
        Object removalEntry = this.elemToEntry(elem);
        int h = this.index(removalEntry.hashCode());
        Object curEntry = this.table()[h];
        while (curEntry != null) {
            if (BoxesRunTime.equals((Object)curEntry, (Object)removalEntry)) {
                int h0 = h;
                int h1 = (h0 + 1) % this.table().length;
                while (this.table()[h1] != null) {
                    int h2 = this.index(this.table()[h1].hashCode());
                    if (h2 != h1 && this.precedes$1(h2, h0)) {
                        this.table()[h0] = this.table()[h1];
                        h0 = h1;
                    }
                    h1 = (h1 + 1) % this.table().length;
                }
                this.table()[h0] = null;
                this.tableSize_$eq(this.tableSize() - 1);
                this.nnSizeMapRemove(h0);
                if (this.tableDebug()) {
                    this.checkConsistent();
                }
                return true;
            }
            h = (h + 1) % this.table().length;
            curEntry = this.table()[h];
        }
        return false;
    }

    public static Iterator iterator$(FlatHashTable $this) {
        return $this.iterator();
    }

    default public Iterator<A> iterator() {
        return new AbstractIterator<A>(this){
            private int i;
            private final FlatHashTable $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.i = 0;
            }

            public boolean hasNext() {
                while (this.i < this.$outer.table().length && this.$outer.table()[this.i] == null) {
                    ++this.i;
                }
                return this.i < this.$outer.table().length;
            }

            public Object next() {
                Object object;
                if (this.hasNext()) {
                    ++this.i;
                    object = this.$outer.entryToElem(this.$outer.table()[this.i - 1]);
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return object;
            }
        };
    }

    private void growTable() {
        Object[] oldtable = this.table();
        this.table_$eq(new Object[this.table().length * 2]);
        this.tableSize_$eq(0);
        this.nnSizeMapReset(this.table().length);
        this.seedvalue_$eq(this.tableSizeSeed());
        this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold(this._loadFactor(), this.table().length));
        for (int i = 0; i < oldtable.length; ++i) {
            Object entry = oldtable[i];
            if (entry == null) continue;
            this.addEntry(entry);
        }
        if (this.tableDebug()) {
            this.checkConsistent();
        }
    }

    private void checkConsistent() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.table().length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            if (this.table()[i] != null && !this.containsElem(this.entryToElem(this.table()[i]))) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)("" + i + " " + this.table()[i] + " " + Predef$.MODULE$.wrapRefArray(this.table()).mkString()));
            }
        });
    }

    public static void nnSizeMapAdd$(FlatHashTable $this, int h) {
        $this.nnSizeMapAdd(h);
    }

    default public void nnSizeMapAdd(int h) {
        if (this.sizemap() != null) {
            int p = h >> this.sizeMapBucketBitSize();
            int[] nArray = this.sizemap();
            nArray[p] = nArray[p] + 1;
        }
    }

    public static void nnSizeMapRemove$(FlatHashTable $this, int h) {
        $this.nnSizeMapRemove(h);
    }

    default public void nnSizeMapRemove(int h) {
        if (this.sizemap() != null) {
            int[] nArray = this.sizemap();
            int n = h >> this.sizeMapBucketBitSize();
            nArray[n] = nArray[n] - 1;
        }
    }

    public static void nnSizeMapReset$(FlatHashTable $this, int tableLength) {
        $this.nnSizeMapReset(tableLength);
    }

    default public void nnSizeMapReset(int tableLength) {
        if (this.sizemap() != null) {
            int nsize = this.calcSizeMapSize(tableLength);
            if (this.sizemap().length != nsize) {
                this.sizemap_$eq(new int[nsize]);
            } else {
                Arrays.fill(this.sizemap(), 0);
            }
        }
    }

    public static int totalSizeMapBuckets$(FlatHashTable $this) {
        return $this.totalSizeMapBuckets();
    }

    default public int totalSizeMapBuckets() {
        return (this.table().length - 1) / this.sizeMapBucketSize() + 1;
    }

    public static int calcSizeMapSize$(FlatHashTable $this, int tableLength) {
        return $this.calcSizeMapSize(tableLength);
    }

    default public int calcSizeMapSize(int tableLength) {
        return (tableLength >> this.sizeMapBucketBitSize()) + 1;
    }

    public static void sizeMapInit$(FlatHashTable $this, int tableLength) {
        $this.sizeMapInit(tableLength);
    }

    default public void sizeMapInit(int tableLength) {
        this.sizemap_$eq(new int[this.calcSizeMapSize(tableLength)]);
    }

    public static void sizeMapInitAndRebuild$(FlatHashTable $this) {
        $this.sizeMapInitAndRebuild();
    }

    default public void sizeMapInitAndRebuild() {
        this.sizeMapInit(this.table().length);
        int totalbuckets = this.totalSizeMapBuckets();
        int tableidx = 0;
        Object[] tbl = this.table();
        int tableuntil = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.sizeMapBucketSize()), tbl.length);
        for (int bucketidx = 0; bucketidx < totalbuckets; ++bucketidx) {
            int currbucketsz = 0;
            while (tableidx < tableuntil) {
                if (tbl[tableidx] != null) {
                    ++currbucketsz;
                }
                ++tableidx;
            }
            this.sizemap()[bucketidx] = currbucketsz;
            tableuntil += this.sizeMapBucketSize();
        }
    }

    public static void printSizeMap$(FlatHashTable $this) {
        $this.printSizeMap();
    }

    default public void printSizeMap() {
        Predef$.MODULE$.println((Object)Predef$.MODULE$.wrapIntArray(this.sizemap()).mkString("szmap: [", ", ", "]"));
    }

    public static void printContents$(FlatHashTable $this) {
        $this.printContents();
    }

    default public void printContents() {
        Predef$.MODULE$.println((Object)Predef$.MODULE$.wrapRefArray(this.table()).mkString("[", ", ", "]"));
    }

    public static void sizeMapDisable$(FlatHashTable $this) {
        $this.sizeMapDisable();
    }

    default public void sizeMapDisable() {
        this.sizemap_$eq(null);
    }

    public static boolean isSizeMapDefined$(FlatHashTable $this) {
        return $this.isSizeMapDefined();
    }

    default public boolean isSizeMapDefined() {
        return this.sizemap() != null;
    }

    public static boolean alwaysInitSizeMap$(FlatHashTable $this) {
        return $this.alwaysInitSizeMap();
    }

    default public boolean alwaysInitSizeMap() {
        return false;
    }

    public static int index$(FlatHashTable $this, int hcode) {
        return $this.index(hcode);
    }

    default public int index(int hcode) {
        int improved = this.improve(hcode, this.seedvalue());
        int ones = this.table().length - 1;
        return improved >>> 32 - Integer.bitCount(ones) & ones;
    }

    public static void clearTable$(FlatHashTable $this) {
        $this.clearTable();
    }

    default public void clearTable() {
        for (int i = this.table().length - 1; i >= 0; --i) {
            this.table()[i] = null;
        }
        this.tableSize_$eq(0);
        this.nnSizeMapReset(this.table().length);
    }

    public static Contents hashTableContents$(FlatHashTable $this) {
        return $this.hashTableContents();
    }

    default public Contents<A> hashTableContents() {
        return new Contents(this._loadFactor(), this.table(), this.tableSize(), this.threshold(), this.seedvalue(), this.sizemap());
    }

    public static void initWithContents$(FlatHashTable $this, Contents c) {
        $this.initWithContents(c);
    }

    default public void initWithContents(Contents<A> c) {
        if (c != null) {
            this._loadFactor_$eq(c.loadFactor());
            this.table_$eq(c.table());
            this.tableSize_$eq(c.tableSize());
            this.threshold_$eq(c.threshold());
            this.seedvalue_$eq(c.seedvalue());
            this.sizemap_$eq(c.sizemap());
        }
        if (this.alwaysInitSizeMap() && this.sizemap() == null) {
            this.sizeMapInitAndRebuild();
        }
    }

    private boolean precedes$1(int i, int j) {
        int d = this.table().length >> 1;
        return i <= j ? j - i < d : i - j > d;
    }

    public static class Contents<A> {
        private final int loadFactor;
        private final Object[] table;
        private final int tableSize;
        private final int threshold;
        private final int seedvalue;
        private final int[] sizemap;

        public Contents(int loadFactor, Object[] table, int tableSize, int threshold, int seedvalue, int[] sizemap) {
            this.loadFactor = loadFactor;
            this.table = table;
            this.tableSize = tableSize;
            this.threshold = threshold;
            this.seedvalue = seedvalue;
            this.sizemap = sizemap;
        }

        public int loadFactor() {
            return this.loadFactor;
        }

        public Object[] table() {
            return this.table;
        }

        public int tableSize() {
            return this.tableSize;
        }

        public int threshold() {
            return this.threshold;
        }

        public int seedvalue() {
            return this.seedvalue;
        }

        public int[] sizemap() {
            return this.sizemap;
        }
    }

    public static interface HashUtils<A> {
        public static int sizeMapBucketBitSize$(HashUtils $this) {
            return $this.sizeMapBucketBitSize();
        }

        default public int sizeMapBucketBitSize() {
            return 5;
        }

        public static int sizeMapBucketSize$(HashUtils $this) {
            return $this.sizeMapBucketSize();
        }

        default public int sizeMapBucketSize() {
            return 1 << this.sizeMapBucketBitSize();
        }

        public static int improve$(HashUtils $this, int hcode, int seed) {
            return $this.improve(hcode, seed);
        }

        default public int improve(int hcode, int seed) {
            return Integer.rotateRight(package$.MODULE$.byteswap32(hcode), seed);
        }

        public static Object elemToEntry$(HashUtils $this, Object elem) {
            return $this.elemToEntry(elem);
        }

        default public Object elemToEntry(A elem) {
            return elem == null ? FlatHashTable$NullSentinel$.MODULE$ : elem;
        }

        public static Object entryToElem$(HashUtils $this, Object entry) {
            return $this.entryToElem(entry);
        }

        default public A entryToElem(Object entry) {
            return (A)(entry == FlatHashTable$NullSentinel$.MODULE$ ? null : entry);
        }
    }
}

