/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Build_Log;
import isabelle.Bytes;
import isabelle.Compress;
import isabelle.Document_Build$;
import isabelle.Export$;
import isabelle.File$;
import isabelle.Isabelle_System$;
import isabelle.ML_Heap$;
import isabelle.ML_Settings;
import isabelle.ML_Settings$;
import isabelle.Markup$;
import isabelle.Options;
import isabelle.Path;
import isabelle.Path$;
import isabelle.PostgreSQL;
import isabelle.PostgreSQL$;
import isabelle.Progress;
import isabelle.Rich_Text;
import isabelle.SHA1;
import isabelle.SHA1$;
import isabelle.SQL;
import isabelle.SQL$;
import isabelle.SQLite$;
import isabelle.SSH;
import isabelle.SSH$;
import isabelle.Sessions;
import isabelle.Sessions$;
import isabelle.Space$;
import isabelle.Store$;
import isabelle.Store$Build_Info$;
import isabelle.Store$Source_File$;
import isabelle.Store$Sources$;
import isabelle.Store$private_data$;
import isabelle.Store$private_data$Session_Info$;
import isabelle.Store$private_data$Sources$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class Store {
    private final Options options;
    private final Option<Path> private_dir;
    private final boolean build_cluster;
    private final Rich_Text.Cache cache;
    private final ML_Settings ml_settings;
    private final Option private_output_dir;
    private final Path system_output_dir;
    private final Path user_output_dir;
    private final Path output_dir;
    private final List input_dirs;
    private final List clean_dirs;

    public static Store apply(Options options, Option<Path> option, boolean bl, Rich_Text.Cache cache) {
        return Store$.MODULE$.apply(options, option, bl, cache);
    }

    public static Path heap(String string) {
        return Store$.MODULE$.heap(string);
    }

    public static Path log(String string) {
        return Store$.MODULE$.log(string);
    }

    public static Path log_db(String string) {
        return Store$.MODULE$.log_db(string);
    }

    public static Path log_gz(String string) {
        return Store$.MODULE$.log_gz(string);
    }

    public static String read_build_uuid(Path path, String string) {
        return Store$.MODULE$.read_build_uuid(path, string);
    }

    public static Option<Path> apply$default$2() {
        return Store$.MODULE$.apply$default$2();
    }

    public static boolean apply$default$3() {
        return Store$.MODULE$.apply$default$3();
    }

    public static Rich_Text.Cache apply$default$4() {
        return Store$.MODULE$.apply$default$4();
    }

    public Store(Options options, Option<Path> private_dir, boolean build_cluster, Rich_Text.Cache cache) {
        this.options = options;
        this.private_dir = private_dir;
        this.build_cluster = build_cluster;
        this.cache = cache;
        this.ml_settings = ML_Settings$.MODULE$.apply(options, ML_Settings$.MODULE$.apply$default$2());
        this.private_output_dir = private_dir.map((Function1 & Serializable)dir -> dir.$plus(Path$.MODULE$.basic("heaps")).$plus(Path$.MODULE$.basic(this.ml_settings().ml_identifier())));
        this.system_output_dir = Path$.MODULE$.variable("ISABELLE_HEAPS_SYSTEM").$plus(Path$.MODULE$.basic(this.ml_settings().ml_identifier()));
        this.user_output_dir = Path$.MODULE$.variable("ISABELLE_HEAPS").$plus(Path$.MODULE$.basic(this.ml_settings().ml_identifier()));
        this.output_dir = (Path)this.private_output_dir().getOrElse(this::$init$$$anonfun$2);
        List list = this.private_output_dir().toList();
        this.input_dirs = (this.system_heaps() ? (List)new .colon.colon((Object)this.system_output_dir(), (List)Nil$.MODULE$) : (List)new .colon.colon((Object)this.user_output_dir(), (List)new .colon.colon((Object)this.system_output_dir(), (List)Nil$.MODULE$))).$colon$colon$colon(list);
        List list2 = this.private_output_dir().toList();
        this.clean_dirs = (this.system_heaps() ? (List)new .colon.colon((Object)this.user_output_dir(), (List)new .colon.colon((Object)this.system_output_dir(), (List)Nil$.MODULE$)) : (List)new .colon.colon((Object)this.user_output_dir(), (List)Nil$.MODULE$)).$colon$colon$colon(list2);
    }

    public Options options() {
        return this.options;
    }

    public boolean build_cluster() {
        return this.build_cluster;
    }

    public Rich_Text.Cache cache() {
        return this.cache;
    }

    public String toString() {
        return "Store(output_dir = " + this.output_dir().absolute() + ")";
    }

    public ML_Settings ml_settings() {
        return this.ml_settings;
    }

    public Option<Path> private_output_dir() {
        return this.private_output_dir;
    }

    public Path system_output_dir() {
        return this.system_output_dir;
    }

    public Path user_output_dir() {
        return this.user_output_dir;
    }

    public Option<String> source_file(String raw_name) {
        if (Path$.MODULE$.is_wellformed(raw_name)) {
            if (Path$.MODULE$.is_valid(raw_name)) {
                Path path = Path$.MODULE$.explode(raw_name);
                Option path1 = path.is_absolute() || path.is_current() ? Store.check$1(path) : Store.check$1(Path$.MODULE$.explode("~~/src/Pure").$plus(path)).orElse(() -> this.$anonfun$1(path));
                return Some$.MODULE$.apply((Object)File$.MODULE$.platform_path((Path)path1.getOrElse(() -> Store.source_file$$anonfun$1(path))));
            }
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)raw_name);
    }

    public boolean system_heaps() {
        return BoxesRunTime.unboxToBoolean((Object)this.options().bool().apply("system_heaps"));
    }

    public Path output_dir() {
        return this.output_dir;
    }

    public List<Path> input_dirs() {
        return this.input_dirs;
    }

    public List<Path> clean_dirs() {
        return this.clean_dirs;
    }

    public Path presentation_dir() {
        if (this.private_dir.isDefined()) {
            return ((Path)this.private_dir.get()).$plus(Path$.MODULE$.basic("browser_info"));
        }
        if (this.system_heaps()) {
            return Path$.MODULE$.explode("$ISABELLE_BROWSER_INFO_SYSTEM");
        }
        return Path$.MODULE$.explode("$ISABELLE_BROWSER_INFO");
    }

    public Path output_heap(String name) {
        return this.output_dir().$plus(Store$.MODULE$.heap(name));
    }

    public Path output_log(String name) {
        return this.output_dir().$plus(Store$.MODULE$.log(name));
    }

    public Path output_log_db(String name) {
        return this.output_dir().$plus(Store$.MODULE$.log_db(name));
    }

    public Path output_log_gz(String name) {
        return this.output_dir().$plus(Store$.MODULE$.log_gz(name));
    }

    public Session get_session(String name) {
        Option heap = this.input_dirs().view().map((Function1 & Serializable)_$3 -> _$3.$plus(Store$.MODULE$.heap(name))).find((Function1 & Serializable)_$4 -> _$4.is_file());
        Option log_db = this.input_dirs().view().map((Function1 & Serializable)_$5 -> _$5.$plus(Store$.MODULE$.log_db(name))).find((Function1 & Serializable)_$6 -> _$6.is_file());
        return new Session(name, (Option<Path>)heap, (Option<Path>)log_db, this.input_dirs());
    }

    public Session output_session(String name, boolean store_heap) {
        None$ heap = store_heap ? Some$.MODULE$.apply((Object)this.output_heap(name)) : None$.MODULE$;
        None$ log_db = !this.build_database_server() ? Some$.MODULE$.apply((Object)this.output_log_db(name)) : None$.MODULE$;
        return new Session(name, (Option<Path>)heap, (Option<Path>)log_db, (List<Path>)((List)new .colon.colon((Object)this.output_dir(), (List)Nil$.MODULE$)));
    }

    public boolean output_session$default$2() {
        return false;
    }

    public List<Path> session_heaps(Sessions.Background session_background, String logic) {
        String logic_name = Isabelle_System$.MODULE$.default_logic((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{logic}));
        return session_background.sessions_structure().selection(logic_name).build_requirements((List<String>)((List)new .colon.colon((Object)logic_name, (List)Nil$.MODULE$))).map((Function1 & Serializable)name -> this.get_session((String)name).the_heap());
    }

    public String session_heaps$default$2() {
        return "";
    }

    public SHA1.Shasum make_shasum(List<SHA1.Shasum> ancestors) {
        if (ancestors.isEmpty()) {
            return SHA1$.MODULE$.shasum_meta_info(SHA1$.MODULE$.digest(this.ml_settings().polyml_exe()));
        }
        return SHA1$.MODULE$.flat_shasum(ancestors);
    }

    public SHA1.Shasum heap_shasum(Option<SQL.Database> database_server, String name) {
        Option option = Store.get_database$1(database_server, name).orElse(() -> this.heap_shasum$$anonfun$1(name));
        if (option instanceof Some) {
            SHA1.Digest digest = (SHA1.Digest)((Some)option).value();
            return SHA1$.MODULE$.shasum(digest, name);
        }
        if (None$.MODULE$.equals(option)) {
            return SHA1$.MODULE$.no_shasum();
        }
        throw new MatchError((Object)option);
    }

    public boolean build_database_server() {
        return BoxesRunTime.unboxToBoolean((Object)this.options().bool().apply("build_database_server"));
    }

    public boolean build_database() {
        return BoxesRunTime.unboxToBoolean((Object)this.options().bool().apply("build_database"));
    }

    public SSH.Server open_server() {
        return PostgreSQL$.MODULE$.open_server(this.options(), this.options().string().apply("build_database_host"), BoxesRunTime.unboxToInt((Object)this.options().int().apply("build_database_port")), this.options().string().apply("build_database_ssh_host"), BoxesRunTime.unboxToInt((Object)this.options().int().apply("build_database_ssh_port")), this.options().string().apply("build_database_ssh_user"));
    }

    public PostgreSQL.Database open_database_server(SSH.Server server) {
        String string = this.options().string().apply("build_database_user");
        String string2 = this.options().string().apply("build_database_password");
        String string3 = this.options().string().apply("build_database_name");
        String string4 = this.options().string().apply("build_database_host");
        int n = BoxesRunTime.unboxToInt((Object)this.options().int().apply("build_database_port"));
        String string5 = this.options().string().apply("build_database_ssh_host");
        int n2 = BoxesRunTime.unboxToInt((Object)this.options().int().apply("build_database_ssh_port"));
        String string6 = this.options().string().apply("build_database_ssh_user");
        return PostgreSQL$.MODULE$.open_database_server(this.options(), string, string2, string3, server, string4, n, string5, n2, string6);
    }

    public SSH.Server open_database_server$default$1() {
        return SSH$.MODULE$.no_server();
    }

    public Option<SQL.Database> maybe_open_database_server(SSH.Server server, boolean guard) {
        if (guard) {
            return Some$.MODULE$.apply((Object)this.open_database_server(server));
        }
        return None$.MODULE$;
    }

    public SSH.Server maybe_open_database_server$default$1() {
        return SSH$.MODULE$.no_server();
    }

    public boolean maybe_open_database_server$default$2() {
        return this.build_database_server();
    }

    public Option<SQL.Database> maybe_open_heaps_database(Option<SQL.Database> database_server, SSH.Server server) {
        if (database_server.isDefined()) {
            return None$.MODULE$;
        }
        return this.maybe_open_database_server(server, this.build_cluster());
    }

    public SSH.Server maybe_open_heaps_database$default$2() {
        return SSH$.MODULE$.no_server();
    }

    public <A> Option<A> maybe_using_heaps_database(Option<SQL.Database> database_server, SSH.Server server, Function1<SQL.Database, A> f) {
        return (Option)package$.MODULE$.using_optional(this.maybe_open_heaps_database(database_server, server), (Function1 & Serializable)heaps_database -> database_server.orElse(() -> Store.maybe_using_heaps_database$$anonfun$1$$anonfun$1(heaps_database)).map(f));
    }

    public <A> SSH.Server maybe_using_heaps_database$default$2() {
        return SSH$.MODULE$.no_server();
    }

    public void in_heaps_database(List<Session> sessions, Option<SQL.Database> database_server, SSH.Server server, Progress progress) {
        if (sessions.nonEmpty()) {
            this.maybe_using_heaps_database(database_server, server, (Function1)(JProcedure1 & Serializable)db -> {
                long slice = Space$.MODULE$.MiB(BoxesRunTime.unboxToDouble((Object)this.options().real().apply("build_database_slice")));
                sessions.foreach((Function1)(JProcedure1 & Serializable)_$7 -> ML_Heap$.MODULE$.store((SQL.Database)db, (Session)_$7, slice, this.cache().compress(), progress));
            });
            return;
        }
    }

    public SSH.Server in_heaps_database$default$3() {
        return SSH$.MODULE$.no_server();
    }

    public Progress in_heaps_database$default$4() {
        return new Progress();
    }

    public SQL.Database open_build_database(Path path, SSH.Server server) {
        if (this.build_database_server() || this.build_cluster()) {
            return this.open_database_server(server);
        }
        return SQLite$.MODULE$.open_database(path, true);
    }

    public SSH.Server open_build_database$default$2() {
        return SSH$.MODULE$.no_server();
    }

    public Option<SQL.Database> maybe_open_build_database(Path path, SSH.Server server) {
        if (this.build_database()) {
            return Some$.MODULE$.apply((Object)this.open_build_database(path, server));
        }
        return None$.MODULE$;
    }

    public Path maybe_open_build_database$default$1() {
        return Path$.MODULE$.explode("$ISABELLE_HOME_USER/build.db");
    }

    public SSH.Server maybe_open_build_database$default$2() {
        return SSH$.MODULE$.no_server();
    }

    public Option<SQL.Database> try_open_database(String name, boolean output, SSH.Server server, boolean server_mode) {
        if (server_mode) {
            return this.check$2(output, this.open_database_server(server));
        }
        if (output) {
            return Some$.MODULE$.apply((Object)SQLite$.MODULE$.open_database(this.output_log_db(name), SQLite$.MODULE$.open_database$default$2()));
        }
        return ((IterableOps)this.input_dirs().view().map((Function1 & Serializable)dir -> {
            Path path = dir.$plus(Store$.MODULE$.log_db(name));
            return Tuple2$.MODULE$.apply(dir, (Object)path);
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path dir = (Path)tuple2._1();
                Path path = (Path)tuple2._2();
                return path.is_file();
            }
            throw new MatchError((Object)tuple2);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path dir = (Path)tuple2._1();
                Path path = (Path)tuple2._2();
                return this.check$2(output, SQLite$.MODULE$.open_database(path, SQLite$.MODULE$.open_database$default$2())).map((Function1 & Serializable)db -> db);
            }
            throw new MatchError((Object)tuple2);
        })).headOption();
    }

    public boolean try_open_database$default$2() {
        return false;
    }

    public SSH.Server try_open_database$default$3() {
        return SSH$.MODULE$.no_server();
    }

    public boolean try_open_database$default$4() {
        return this.build_database_server();
    }

    public Nothing$ error_database(String name) {
        return (Nothing$)package$.MODULE$.error().apply((Object)("Missing build database for session " + package$.MODULE$.quote().apply((Object)name)));
    }

    public SQL.Database open_database(String name, boolean output, SSH.Server server) {
        return (SQL.Database)this.try_open_database(name, output, server, this.try_open_database$default$4()).getOrElse(() -> this.open_database$$anonfun$1(name));
    }

    public boolean open_database$default$2() {
        return false;
    }

    public SSH.Server open_database$default$3() {
        return SSH$.MODULE$.no_server();
    }

    public void clean_output(Option<SQL.Database> database_server, String name, boolean session_init, Progress progress) {
        boolean bl;
        Option<SQL.Database> option = database_server;
        if (option instanceof Some) {
            SQL.Database db = (SQL.Database)((Some)option).value();
            ML_Heap$.MODULE$.clean_entry(db, name);
            bl = this.clean_session_info(db, name);
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        boolean relevant_db = bl;
        List del = this.clean_dirs().flatMap((Function1 & Serializable)dir -> (IterableOnce)((List)new .colon.colon((Object)Store$.MODULE$.heap(name), (List)new .colon.colon((Object)Store$.MODULE$.log_db(name), (List)new .colon.colon((Object)Store$.MODULE$.log(name), (List)new .colon.colon((Object)Store$.MODULE$.log_gz(name), (List)Nil$.MODULE$))))).map((Function1 & Serializable)file -> {
            Path path = dir.$plus((Path)file);
            return Tuple2$.MODULE$.apply(file, (Object)path);
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path file = (Path)tuple2._1();
                Path path = (Path)tuple2._2();
                return path.is_file();
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path file = (Path)tuple2._1();
                Path path = (Path)tuple2._2();
                return path.file().delete();
            }
            throw new MatchError((Object)tuple2);
        }));
        if (database_server.isEmpty() && session_init) {
            package$.MODULE$.using(this.open_database(name, true, this.open_database$default$3()), (Function1 & Serializable)_$8 -> this.clean_session_info((SQL.Database)_$8, name));
        }
        if (relevant_db || del.nonEmpty()) {
            if (del.forall((Function1 & Serializable)x -> Store.clean_output$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)x)))) {
                progress.echo("Cleaned " + name, progress.echo$default$2());
                return;
            }
            progress.echo(name + " FAILED to clean", progress.echo$default$2());
            return;
        }
    }

    public boolean clean_output$default$3() {
        return false;
    }

    public Progress clean_output$default$4() {
        return new Progress();
    }

    public Tuple2<Object, SHA1.Shasum> check_output(Option<SQL.Database> database_server, String name, SHA1.Shasum sources_shasum, SHA1.Shasum input_shasum, boolean build_thorough, boolean fresh_build, boolean store_heap) {
        Option<SQL.Database> option = database_server;
        if (option instanceof Some) {
            SQL.Database db2 = (SQL.Database)((Some)option).value();
            if (this.session_info_exists(db2)) {
                return this.check$3(name, fresh_build, build_thorough, sources_shasum, input_shasum, store_heap, db2);
            }
            return Store.no_check$1();
        }
        if (None$.MODULE$.equals(option)) {
            return (Tuple2)package$.MODULE$.using_option(this.try_open_database(name, this.try_open_database$default$2(), this.try_open_database$default$3(), this.try_open_database$default$4()), (Function1 & Serializable)db -> this.check$3(name, fresh_build, build_thorough, sources_shasum, input_shasum, store_heap, (SQL.Database)db)).getOrElse(Store::check_output$$anonfun$2);
        }
        throw new MatchError(option);
    }

    public boolean check_output$default$5() {
        return false;
    }

    public boolean check_output$default$6() {
        return false;
    }

    public boolean check_output$default$7() {
        return false;
    }

    public boolean session_info_exists(SQL.Database db) {
        return Store$private_data$.MODULE$.tables().forall((Function1 & Serializable)table -> db.exists_table((SQL.Table)table));
    }

    public boolean session_info_defined(SQL.Database db, String name) {
        List list = (List)new .colon.colon((Object)Store$private_data$Session_Info$.MODULE$.session_name(), (List)Nil$.MODULE$);
        String string = Store$private_data$Session_Info$.MODULE$.session_name().where_equal(name);
        boolean bl = Store$private_data$Session_Info$.MODULE$.table().select$default$2();
        return db.execute_query_statementB(Store$private_data$Session_Info$.MODULE$.table().select((List<SQL.Column>)list, bl, string));
    }

    public boolean clean_session_info(SQL.Database db, String name) {
        Export$.MODULE$.clean_session(db, name);
        Document_Build$.MODULE$.clean_session(db, name);
        return BoxesRunTime.unboxToBoolean(Store$private_data$.MODULE$.transaction_lock(db, true, "Store.clean_session_info", Store$private_data$.MODULE$.transaction_lock$default$4(), () -> this.clean_session_info$$anonfun$1(db, name)));
    }

    public void write_session_info(SQL.Database db, String session_name, Sources sources, Build_Log.Session_Info build_log, Build_Info build) {
        Store$private_data$.MODULE$.transaction_lock(db, Store$private_data$.MODULE$.transaction_lock$default$2(), "Store.write_session_info", Store$private_data$.MODULE$.transaction_lock$default$4(), (Function0 & Serializable)() -> {
            this.write_session_info$$anonfun$1(sources, db, session_name, build_log, build);
            return BoxedUnit.UNIT;
        });
    }

    public List<Tuple2<String, String>> read_session_timing(SQL.Database db, String session) {
        return (List)Store$private_data$.MODULE$.transaction_lock(db, Store$private_data$.MODULE$.transaction_lock$default$2(), "Store.read_session_timing", Store$private_data$.MODULE$.transaction_lock$default$4(), () -> this.read_session_timing$$anonfun$1(db, session));
    }

    public Bytes read_command_timings(SQL.Database db, String session) {
        return (Bytes)Store$private_data$.MODULE$.transaction_lock(db, Store$private_data$.MODULE$.transaction_lock$default$2(), "Store.read_command_timings", Store$private_data$.MODULE$.transaction_lock$default$4(), () -> Store.read_command_timings$$anonfun$1(db, session));
    }

    public List<List<Tuple2<String, String>>> read_theory_timings(SQL.Database db, String session) {
        return (List)Store$private_data$.MODULE$.transaction_lock(db, Store$private_data$.MODULE$.transaction_lock$default$2(), "Store.read_theory_timings", Store$private_data$.MODULE$.transaction_lock$default$4(), () -> this.read_theory_timings$$anonfun$1(db, session));
    }

    public List<List<Tuple2<String, String>>> read_ml_statistics(SQL.Database db, String session) {
        return (List)Store$private_data$.MODULE$.transaction_lock(db, Store$private_data$.MODULE$.transaction_lock$default$2(), "Store.read_ml_statistics", Store$private_data$.MODULE$.transaction_lock$default$4(), () -> this.read_ml_statistics$$anonfun$1(db, session));
    }

    public List<List<Tuple2<String, String>>> read_task_statistics(SQL.Database db, String session) {
        return (List)Store$private_data$.MODULE$.transaction_lock(db, Store$private_data$.MODULE$.transaction_lock$default$2(), "Store.read_task_statistics", Store$private_data$.MODULE$.transaction_lock$default$4(), () -> this.read_task_statistics$$anonfun$1(db, session));
    }

    public List<String> read_theories(SQL.Database db, String session) {
        return this.read_theory_timings(db, session).flatMap((Function1 & Serializable)props -> Markup$.MODULE$.Name().unapply((List<Tuple2<String, String>>)props));
    }

    public List<String> read_errors(SQL.Database db, String session) {
        return (List)Store$private_data$.MODULE$.transaction_lock(db, Store$private_data$.MODULE$.transaction_lock$default$2(), "Store.read_errors", Store$private_data$.MODULE$.transaction_lock$default$4(), () -> this.read_errors$$anonfun$1(db, session));
    }

    public Option<Build_Info> read_build(SQL.Database db, String session) {
        return (Option)Store$private_data$.MODULE$.transaction_lock(db, Store$private_data$.MODULE$.transaction_lock$default$2(), "Store.read_build", Store$private_data$.MODULE$.transaction_lock$default$4(), () -> this.read_build$$anonfun$1(db, session));
    }

    public List<Source_File> read_sources(SQL.Database db, String session, String name) {
        return (List)Store$private_data$.MODULE$.transaction_lock(db, Store$private_data$.MODULE$.transaction_lock$default$2(), "Store.read_sources", Store$private_data$.MODULE$.transaction_lock$default$4(), () -> this.read_sources$$anonfun$1(db, session, name));
    }

    public String read_sources$default$3() {
        return "";
    }

    private final Path $init$$$anonfun$2() {
        if (this.system_heaps()) {
            return this.system_output_dir();
        }
        return this.user_output_dir();
    }

    private static final Option check$1(Path p) {
        if (p.is_file()) {
            return Some$.MODULE$.apply((Object)p);
        }
        return None$.MODULE$;
    }

    private final Option $anonfun$1(Path path$1) {
        Path ml_sources = this.ml_settings().ml_sources();
        if (ml_sources.is_dir()) {
            return Store.check$1(ml_sources.$plus(path$1));
        }
        return None$.MODULE$;
    }

    private static final Path source_file$$anonfun$1(Path path$2) {
        return path$2;
    }

    private static final Option get_database$1(Option database_server$1, String name$3) {
        return database_server$1.flatMap((Function1 & Serializable)db -> ML_Heap$.MODULE$.read_digests((SQL.Database)db, (Iterable<String>)((Iterable)new .colon.colon((Object)name$3, (List)Nil$.MODULE$))).valuesIterator().nextOption().map((Function1 & Serializable)digest -> digest));
    }

    private final Option heap_shasum$$anonfun$1(String name$5) {
        return this.get_session(name$5).heap_digest();
    }

    private static final Option maybe_using_heaps_database$$anonfun$1$$anonfun$1(Option heaps_database$1) {
        return heaps_database$1;
    }

    private final Option check$2(boolean output$1, SQL.Database db) {
        if (output$1 || this.session_info_exists(db)) {
            return Some$.MODULE$.apply((Object)db);
        }
        db.close();
        return None$.MODULE$;
    }

    private final SQL.Database open_database$$anonfun$1(String name$7) {
        throw this.error_database(name$7);
    }

    private static final /* synthetic */ boolean clean_output$$anonfun$2(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    private static final Tuple2 no_check$1() {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)SHA1$.MODULE$.no_shasum());
    }

    /*
     * Unable to fully structure code
     */
    private final Tuple2 check$3(String name$10, boolean fresh_build$1, boolean build_thorough$1, SHA1.Shasum sources_shasum$1, SHA1.Shasum input_shasum$1, boolean store_heap$1, SQL.Database db) {
        block3: {
            var8_8 = this.read_build(db, name$10);
            if (!(var8_8 instanceof Some)) break block3;
            build = (Build_Info)((Some)var8_8).value();
            output_shasum = this.heap_shasum((Option<SQL.Database>)(db.is_postgresql() != false ? Some$.MODULE$.apply((Object)db) : None$.MODULE$), name$10);
            if (fresh_build$1 || !build.ok() || !Sessions$.MODULE$.eq_sources(build_thorough$1, build.sources(), sources_shasum$1)) ** GOTO lbl-1000
            v0 = build.input_heaps();
            var12_11 = input_shasum$1;
            if (v0 != null ? v0.equals(var12_11) == false : var12_11 != null) ** GOTO lbl-1000
            v1 = build.output_heap();
            var13_12 = output_shasum;
            if (v1 != null ? v1.equals(var13_12) == false : var13_12 != null) ** GOTO lbl-1000
            if (!store_heap$1 || !output_shasum.is_empty()) {
                v2 = true;
            } else lbl-1000:
            // 4 sources

            {
                v2 = false;
            }
            current = v2;
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)current), (Object)output_shasum);
        }
        if (None$.MODULE$.equals(var8_8)) {
            return Store.no_check$1();
        }
        throw new MatchError(var8_8);
    }

    private static final Tuple2 check_output$$anonfun$2() {
        return Store.no_check$1();
    }

    private final boolean clean_session_info$$anonfun$1(SQL.Database db$3, String name$11) {
        boolean already_defined = this.session_info_defined(db$3, name$11);
        db$3.execute_statement(SQL$.MODULE$.multi((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Store$private_data$Session_Info$.MODULE$.table().delete(Store$private_data$Session_Info$.MODULE$.session_name().where_equal(name$11)), Store$private_data$Sources$.MODULE$.table().delete(Store$private_data$Sources$.MODULE$.where_equal(name$11, Store$private_data$Sources$.MODULE$.where_equal$default$2()))})), db$3.execute_statement$default$2());
        return already_defined;
    }

    private final void write_session_info$$anonfun$1(Sources sources$1, SQL.Database db$4, String session_name$1, Build_Log.Session_Info build_log$1, Build_Info build$1) {
        sources$1.iterator().toList().grouped(200).foreach((Function1)(JProcedure1 & Serializable)source_files -> Store$private_data$.MODULE$.write_sources(db$4, session_name$1, (Iterable<Source_File>)source_files));
        Store$private_data$.MODULE$.write_session_info(db$4, this.cache().compress(), session_name$1, build_log$1, build$1);
    }

    private final List read_session_timing$$anonfun$1(SQL.Database db$6, String session$1) {
        return Store$private_data$.MODULE$.read_session_timing(db$6, session$1, this.cache());
    }

    private static final Bytes read_command_timings$$anonfun$1(SQL.Database db$7, String session$2) {
        return Store$private_data$.MODULE$.read_command_timings(db$7, session$2);
    }

    private final List read_theory_timings$$anonfun$1(SQL.Database db$8, String session$3) {
        return Store$private_data$.MODULE$.read_theory_timings(db$8, session$3, this.cache());
    }

    private final List read_ml_statistics$$anonfun$1(SQL.Database db$9, String session$4) {
        return Store$private_data$.MODULE$.read_ml_statistics(db$9, session$4, this.cache());
    }

    private final List read_task_statistics$$anonfun$1(SQL.Database db$10, String session$5) {
        return Store$private_data$.MODULE$.read_task_statistics(db$10, session$5, this.cache());
    }

    private final List read_errors$$anonfun$1(SQL.Database db$11, String session$6) {
        return Store$private_data$.MODULE$.read_errors(db$11, session$6, this.cache());
    }

    private final Option read_build$$anonfun$1(SQL.Database db$12, String session$7) {
        if (this.session_info_exists(db$12)) {
            return Store$private_data$.MODULE$.read_build(db$12, session$7);
        }
        return None$.MODULE$;
    }

    private final List read_sources$$anonfun$1(SQL.Database db$13, String session$8, String name$12) {
        return Store$private_data$.MODULE$.read_sources(db$13, session$8, name$12, this.cache().compress());
    }

    public static class Build_Info
    implements Product,
    Serializable {
        private final SHA1.Shasum sources;
        private final SHA1.Shasum input_heaps;
        private final SHA1.Shasum output_heap;
        private final int return_code;
        private final String uuid;

        public static Build_Info apply(SHA1.Shasum shasum, SHA1.Shasum shasum2, SHA1.Shasum shasum3, int n, String string) {
            return Store$Build_Info$.MODULE$.apply(shasum, shasum2, shasum3, n, string);
        }

        public static Build_Info fromProduct(Product product) {
            return Store$Build_Info$.MODULE$.fromProduct(product);
        }

        public static Build_Info unapply(Build_Info build_Info) {
            return Store$Build_Info$.MODULE$.unapply(build_Info);
        }

        public Build_Info(SHA1.Shasum sources, SHA1.Shasum input_heaps, SHA1.Shasum output_heap, int return_code, String uuid) {
            this.sources = sources;
            this.input_heaps = input_heaps;
            this.output_heap = output_heap;
            this.return_code = return_code;
            this.uuid = uuid;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sources()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.input_heaps()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.output_heap()));
            n = Statics.mix((int)n, (int)this.return_code());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.uuid()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Build_Info)) return false;
            Build_Info build_Info = (Build_Info)object;
            if (this.return_code() != build_Info.return_code()) return false;
            SHA1.Shasum shasum = this.sources();
            SHA1.Shasum shasum2 = build_Info.sources();
            if (shasum == null) {
                if (shasum2 != null) {
                    return false;
                }
            } else if (!((Object)shasum).equals(shasum2)) return false;
            SHA1.Shasum shasum3 = this.input_heaps();
            SHA1.Shasum shasum4 = build_Info.input_heaps();
            if (shasum3 == null) {
                if (shasum4 != null) {
                    return false;
                }
            } else if (!((Object)shasum3).equals(shasum4)) return false;
            SHA1.Shasum shasum5 = this.output_heap();
            SHA1.Shasum shasum6 = build_Info.output_heap();
            if (shasum5 == null) {
                if (shasum6 != null) {
                    return false;
                }
            } else if (!((Object)shasum5).equals(shasum6)) return false;
            String string = this.uuid();
            String string2 = build_Info.uuid();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!build_Info.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Build_Info;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Build_Info";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "sources";
                }
                case 1: {
                    return "input_heaps";
                }
                case 2: {
                    return "output_heap";
                }
                case 3: {
                    return "return_code";
                }
                case 4: {
                    return "uuid";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SHA1.Shasum sources() {
            return this.sources;
        }

        public SHA1.Shasum input_heaps() {
            return this.input_heaps;
        }

        public SHA1.Shasum output_heap() {
            return this.output_heap;
        }

        public int return_code() {
            return this.return_code;
        }

        public String uuid() {
            return this.uuid;
        }

        public boolean ok() {
            return this.return_code() == 0;
        }

        public Build_Info copy(SHA1.Shasum sources, SHA1.Shasum input_heaps, SHA1.Shasum output_heap, int return_code, String uuid) {
            return new Build_Info(sources, input_heaps, output_heap, return_code, uuid);
        }

        public SHA1.Shasum copy$default$1() {
            return this.sources();
        }

        public SHA1.Shasum copy$default$2() {
            return this.input_heaps();
        }

        public SHA1.Shasum copy$default$3() {
            return this.output_heap();
        }

        public int copy$default$4() {
            return this.return_code();
        }

        public String copy$default$5() {
            return this.uuid();
        }

        public SHA1.Shasum _1() {
            return this.sources();
        }

        public SHA1.Shasum _2() {
            return this.input_heaps();
        }

        public SHA1.Shasum _3() {
            return this.output_heap();
        }

        public int _4() {
            return this.return_code();
        }

        public String _5() {
            return this.uuid();
        }
    }

    public static final class Session {
        private final String name;
        private final Option heap;
        private final Option log_db;
        private final List<Path> dirs;

        public Session(String name, Option<Path> heap, Option<Path> log_db, List<Path> dirs) {
            this.name = name;
            this.heap = heap;
            this.log_db = log_db;
            this.dirs = dirs;
        }

        public String name() {
            return this.name;
        }

        public Option<Path> heap() {
            return this.heap;
        }

        public Option<Path> log_db() {
            return this.log_db;
        }

        public String log_db_name() {
            return Store$.MODULE$.log_db(this.name()).implode();
        }

        public boolean defined() {
            return this.heap().isDefined() || this.log_db().isDefined();
        }

        public Path the_heap() {
            return (Path)this.heap().getOrElse(this::the_heap$$anonfun$1);
        }

        public Option<SHA1.Digest> heap_digest() {
            return this.heap().flatMap(Store$::isabelle$Store$Session$$_$heap_digest$$anonfun$1);
        }

        public String toString() {
            return this.name();
        }

        private final Path the_heap$$anonfun$1() {
            return (Path)package$.MODULE$.error().apply((Object)("Missing heap image for session " + package$.MODULE$.quote().apply((Object)this.name()) + " -- expected in:\n" + package$.MODULE$.cat_lines().apply((Object)this.dirs.map(Store$::isabelle$Store$Session$$_$the_heap$$anonfun$1$$anonfun$1))));
        }
    }

    public static class Source_File
    implements Product,
    Serializable {
        private final String name;
        private final SHA1.Digest digest;
        private final boolean compressed;
        private final Bytes body;
        private final Compress.Cache cache;

        public static Source_File apply(String string, SHA1.Digest digest, boolean bl, Bytes bytes, Compress.Cache cache) {
            return Store$Source_File$.MODULE$.apply(string, digest, bl, bytes, cache);
        }

        public static Source_File fromProduct(Product product) {
            return Store$Source_File$.MODULE$.fromProduct(product);
        }

        public static Source_File unapply(Source_File source_File) {
            return Store$Source_File$.MODULE$.unapply(source_File);
        }

        public Source_File(String name, SHA1.Digest digest, boolean compressed, Bytes body, Compress.Cache cache) {
            this.name = name;
            this.digest = digest;
            this.compressed = compressed;
            this.body = body;
            this.cache = cache;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.digest()));
            n = Statics.mix((int)n, (int)(this.compressed() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.body()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cache()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Source_File)) return false;
            Source_File source_File = (Source_File)object;
            if (this.compressed() != source_File.compressed()) return false;
            String string = this.name();
            String string2 = source_File.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            SHA1.Digest digest = this.digest();
            SHA1.Digest digest2 = source_File.digest();
            if (digest == null) {
                if (digest2 != null) {
                    return false;
                }
            } else if (!((Object)digest).equals(digest2)) return false;
            Bytes bytes = this.body();
            Bytes bytes2 = source_File.body();
            if (bytes == null) {
                if (bytes2 != null) {
                    return false;
                }
            } else if (!((Object)bytes).equals(bytes2)) return false;
            Compress.Cache cache = this.cache();
            Compress.Cache cache2 = source_File.cache();
            if (cache == null) {
                if (cache2 != null) {
                    return false;
                }
            } else if (!cache.equals(cache2)) return false;
            if (!source_File.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Source_File;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Source_File";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "digest";
                }
                case 2: {
                    return "compressed";
                }
                case 3: {
                    return "body";
                }
                case 4: {
                    return "cache";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public SHA1.Digest digest() {
            return this.digest;
        }

        public boolean compressed() {
            return this.compressed;
        }

        public Bytes body() {
            return this.body;
        }

        public Compress.Cache cache() {
            return this.cache;
        }

        public String toString() {
            return this.name();
        }

        public Bytes bytes() {
            if (this.compressed()) {
                return this.body().uncompress(this.cache());
            }
            return this.body();
        }

        public Source_File copy(String name, SHA1.Digest digest, boolean compressed, Bytes body, Compress.Cache cache) {
            return new Source_File(name, digest, compressed, body, cache);
        }

        public String copy$default$1() {
            return this.name();
        }

        public SHA1.Digest copy$default$2() {
            return this.digest();
        }

        public boolean copy$default$3() {
            return this.compressed();
        }

        public Bytes copy$default$4() {
            return this.body();
        }

        public Compress.Cache copy$default$5() {
            return this.cache();
        }

        public String _1() {
            return this.name();
        }

        public SHA1.Digest _2() {
            return this.digest();
        }

        public boolean _3() {
            return this.compressed();
        }

        public Bytes _4() {
            return this.body();
        }

        public Compress.Cache _5() {
            return this.cache();
        }
    }

    public static class Sources
    implements Iterable<Source_File> {
        private final Map<String, Source_File> rep;

        public static Sources load(Sessions.Base base, Compress.Cache cache) {
            return Store$Sources$.MODULE$.load(base, cache);
        }

        public static Compress.Cache load$default$2() {
            return Store$Sources$.MODULE$.load$default$2();
        }

        public Sources(Map<String, Source_File> rep) {
            this.rep = rep;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            IterableOps.$init$((IterableOps)this);
            IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
            Iterable.$init$((Iterable)this);
        }

        public String toString() {
            return ((IterableOnceOps)this.rep.values().toList().sortBy(Store$::isabelle$Store$Sources$$_$toString$$anonfun$1, (Ordering)Ordering.String$.MODULE$)).mkString("Sources(", ", ", ")");
        }

        public Iterator<Source_File> iterator() {
            return this.rep.valuesIterator();
        }

        public Option<Source_File> get(String name) {
            return this.rep.get((Object)name);
        }

        public Source_File apply(String name) {
            return (Source_File)this.get(name).getOrElse(() -> Store$.isabelle$Store$Sources$$_$apply$$anonfun$1(name));
        }
    }
}

