/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Component_Stack;
import isabelle.Component_Stack$Download_Platform$;
import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.Scala_Project$;
import isabelle.Url$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_Stack$
implements Serializable {
    public static final Component_Stack$Download_Platform$ Download_Platform;
    private static final List platforms;
    private static final String default_url;
    private static final String default_version;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_Stack$ MODULE$;

    private Component_Stack$() {
    }

    static {
        MODULE$ = new Component_Stack$();
        platforms = (List)new .colon.colon((Object)Component_Stack$Download_Platform$.MODULE$.apply("arm64-darwin", "osx-aarch64"), (List)new .colon.colon((Object)Component_Stack$Download_Platform$.MODULE$.apply("arm64-linux", "linux-aarch64"), (List)new .colon.colon((Object)Component_Stack$Download_Platform$.MODULE$.apply("x86_64-darwin", "osx-x86_64"), (List)new .colon.colon((Object)Component_Stack$Download_Platform$.MODULE$.apply("x86_64-linux", "linux-x86_64"), (List)new .colon.colon((Object)Component_Stack$Download_Platform$.MODULE$.apply("x86_64-windows", "windows-x86_64"), (List)Nil$.MODULE$)))));
        default_url = "https://github.com/commercialhaskell/stack/releases/download";
        default_version = "2.15.7";
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_stack", "build component for GHC stack", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef base_url = ObjectRef.create((Object)this.default_url());
            ObjectRef version = ObjectRef.create((Object)this.default_version());
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                base_url$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"V:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                version$1.elem = arg;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_stack((String)base_url.elem, (String)version.elem, (Path)target_dir.elem, progress);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_Stack$.class);
    }

    public List<Component_Stack.Download_Platform> platforms() {
        return platforms;
    }

    public String default_url() {
        return default_url;
    }

    public String default_version() {
        return default_version;
    }

    public void build_stack(String base_url, String version, Path target_dir, Progress progress) {
        String component = "stack-" + version;
        Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component)), Components$Directory$.MODULE$.apply$default$2());
        Components.Directory component_dir = directory.create(progress, directory.create$default$2());
        this.platforms().foreach((Function1)(JProcedure1 & Serializable)platform -> {
            Path platform_dir = Isabelle_System$.MODULE$.make_directory(component_dir.path().$plus(Path$.MODULE$.explode(platform.platform_name())));
            String url = Url$.MODULE$.append_path(base_url, "v" + version + "/stack-" + version + "-" + platform.download_name() + ".tar.gz");
            Path exe = Path$.MODULE$.explode("stack").exe_if(platform.is_windows());
            Isabelle_System$.MODULE$.with_tmp_file("archive", "tar.gz", Isabelle_System$.MODULE$.with_tmp_file$default$3(), (JProcedure1 & Serializable)archive_file -> Isabelle_System$.MODULE$.with_tmp_dir("tmp", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)tmp_dir -> {
                Isabelle_System$.MODULE$.download_file(url, (Path)archive_file, progress);
                Isabelle_System$.MODULE$.extract((Path)archive_file, (Path)tmp_dir, true);
                Isabelle_System$.MODULE$.move_file(tmp_dir.$plus(exe), platform_dir);
                File$.MODULE$.set_executable(platform_dir.$plus(exe), File$.MODULE$.set_executable$default$2());
            }));
        });
        component_dir.write_settings("\nISABELLE_STACK=\"$COMPONENT/${ISABELLE_WINDOWS_PLATFORM64:-${ISABELLE_APPLE_PLATFORM64:-$ISABELLE_PLATFORM64}}/stack\"\n");
        File$.MODULE$.write(component_dir.README(), "This is stack " + version + " -- the Haskell Tool Stack.\n\nSee also https://www.haskellstack.org and executables from\n" + base_url + "\n\nThe downloaded files were renamed and made executable.\n\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
        Isabelle_System$.MODULE$.download_file("https://raw.githubusercontent.com/commercialhaskell/stack/master/LICENSE", component_dir.LICENSE(), Isabelle_System$.MODULE$.download_file$default$3());
    }

    public String build_stack$default$1() {
        return this.default_url();
    }

    public String build_stack$default$2() {
        return this.default_version();
    }

    public Path build_stack$default$3() {
        return Path$.MODULE$.current();
    }

    public Progress build_stack$default$4() {
        return new Progress();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_stack [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -U URL       download URL (default: \"" + this.default_url() + "\")\n    -V VERSION   version (default: \"" + this.default_version() + "\")\n\n  Build component for GHC stack.\n";
    }
}

