/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Completion$;
import isabelle.Completion$History$;
import isabelle.Completion$Item$;
import isabelle.Completion$Language_Context$;
import isabelle.Completion$Names$;
import isabelle.Completion$Result$;
import isabelle.Completion$Semantic$;
import isabelle.Completion$Word_Parsers$;
import isabelle.File$;
import isabelle.Isabelle_System$;
import isabelle.Library;
import isabelle.Long_Name$;
import isabelle.Markup;
import isabelle.Multi_Map;
import isabelle.Scan;
import isabelle.Scan$Parsers$;
import isabelle.Symbol;
import isabelle.Symbol$;
import isabelle.Symbol$Argument$;
import isabelle.Text;
import isabelle.Text$Range$;
import isabelle.Word$;
import isabelle.XML;
import isabelle.XML$Encode$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.parsing.combinator.Parsers;
import scala.util.parsing.input.Reader;

public final class Completion {
    private final Set<String> keywords;
    private final Scan.Lexicon words_lex;
    private final Multi_Map<String, String> words_map;
    private final Scan.Lexicon abbrevs_lex;
    private final Multi_Map<String, Tuple2<String, String>> abbrevs_map;

    public static char caret_indicator() {
        return Completion$.MODULE$.caret_indicator();
    }

    public static Option<String> clean_name(String string) {
        return Completion$.MODULE$.clean_name(string);
    }

    public static Function1<String, Object> completed(String string) {
        return Completion$.MODULE$.completed(string);
    }

    public static Completion empty() {
        return Completion$.MODULE$.empty();
    }

    public static Completion make(List<String> list, List<Tuple2<String, String>> list2) {
        return Completion$.MODULE$.make(list, list2);
    }

    public static String report_names(List<Tuple2<String, String>> list, List<Tuple2<String, Tuple2<String, String>>> list2, int n) {
        return Completion$.MODULE$.report_names(list, list2, n);
    }

    public static String report_no_completion(List<Tuple2<String, String>> list) {
        return Completion$.MODULE$.report_no_completion(list);
    }

    public static String report_theories(List<Tuple2<String, String>> list, List<String> list2, int n) {
        return Completion$.MODULE$.report_theories(list, list2, n);
    }

    public static Tuple2<String, String> split_template(String string) {
        return Completion$.MODULE$.split_template(string);
    }

    public static int report_names$default$3() {
        return Completion$.MODULE$.report_names$default$3();
    }

    public static int report_theories$default$3() {
        return Completion$.MODULE$.report_theories$default$3();
    }

    public Completion(Set<String> keywords, Scan.Lexicon words_lex, Multi_Map<String, String> words_map, Scan.Lexicon abbrevs_lex, Multi_Map<String, Tuple2<String, String>> abbrevs_map) {
        this.keywords = keywords;
        this.words_lex = words_lex;
        this.words_map = words_map;
        this.abbrevs_lex = abbrevs_lex;
        this.abbrevs_map = abbrevs_map;
    }

    private boolean is_symbol(String name) {
        return Symbol$.MODULE$.symbols().defined(name);
    }

    private boolean is_keyword(String name) {
        return !this.is_symbol(name) && this.keywords.apply((Object)name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean is_keyword_template(String name, boolean template) {
        if (!this.is_keyword(name)) return false;
        Object object = this.words_map.getOrElse(name, () -> Completion.is_keyword_template$$anonfun$1(name));
        String string = name;
        if ((object == null ? string != null : !object.equals(string)) != template) return false;
        return true;
    }

    public Completion add_keyword(String keyword) {
        return new Completion((Set<String>)((Set)this.keywords.$plus((Object)keyword)), this.words_lex, this.words_map, this.abbrevs_lex, this.abbrevs_map);
    }

    public Completion add_keywords(List<String> names) {
        Set keywords1 = (Set)names.foldLeft(this.keywords, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                String k;
                Set ks = (Set)tuple2._1();
                if (ks.apply((Object)(k = (String)tuple2._2()))) {
                    return ks;
                }
                return (Set)ks.$plus((Object)k);
            }
            throw new MatchError((Object)tuple2);
        });
        if (this.keywords == keywords1) {
            return this;
        }
        return new Completion((Set<String>)keywords1, this.words_lex, this.words_map, this.abbrevs_lex, this.abbrevs_map);
    }

    public Completion add_symbols() {
        List words = Symbol$.MODULE$.symbols().entries().flatMap((Function1 & Serializable)entry -> {
            Nil$ nil$;
            String sym = entry.symbol();
            String word = "\\" + entry.name();
            Symbol.Argument argument = entry.argument();
            Symbol.Argument argument2 = Symbol$Argument$.none;
            Symbol.Argument argument3 = argument;
            if (!(argument2 != null ? !argument2.equals(argument3) : argument3 != null)) {
                nil$ = scala.package$.MODULE$.Nil();
            } else {
                Symbol.Argument argument4 = Symbol$Argument$.cartouche;
                Symbol.Argument argument5 = argument;
                if (!(argument4 != null ? !argument4.equals(argument5) : argument5 != null)) {
                    nil$ = (List)new .colon.colon((Object)"", (List)Nil$.MODULE$);
                } else {
                    Symbol.Argument argument6 = Symbol$Argument$.space_cartouche;
                    Symbol.Argument argument7 = argument;
                    if (!(argument6 != null ? !argument6.equals(argument7) : argument7 != null)) {
                        nil$ = (List)new .colon.colon((Object)" ", (List)Nil$.MODULE$);
                    } else {
                        throw new MatchError((Object)argument);
                    }
                }
            }
            Nil$ seps = nil$;
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)sym);
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)word);
            List list = (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)sym), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)sym), (List)Nil$.MODULE$));
            return seps.map((Function1 & Serializable)sep -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)word);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)(sym + sep + "\\<open>\u0007\\<close>"));
            }).$colon$colon$colon(list);
        });
        return new Completion(this.keywords, this.words_lex.$plus$plus((IterableOnce<String>)words.map((Function1 & Serializable)_$9 -> (String)_$9._1())), (Multi_Map)this.words_map.$plus$plus((IterableOnce)words), this.abbrevs_lex, this.abbrevs_map);
    }

    public Completion add_abbrevs(List<Tuple2<String, String>> abbrevs) {
        return (Completion)abbrevs.foldLeft((Object)this, (Function2 & Serializable)(_$10, _$11) -> _$10.add_abbrev((Tuple2<String, String>)_$11));
    }

    private Completion add_abbrev(Tuple2<String, String> abbrev) {
        Tuple2<String, String> tuple2 = abbrev;
        if (tuple2 != null) {
            Tuple2 tuple22;
            Tuple2 tuple23;
            String string = (String)tuple2._1();
            if ("".equals(string)) {
                return this;
            }
            String abbr = string;
            String text = (String)tuple2._2();
            String rev_abbr = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(abbr));
            boolean is_word = Completion$Word_Parsers$.MODULE$.is_word(abbr);
            if (!is_word) {
                tuple23 = Tuple2$.MODULE$.apply((Object)this.words_lex, this.words_map);
            } else {
                String string2 = text;
                String string3 = "";
                tuple23 = (string2 == null ? string3 != null : !string2.equals(string3)) ? Tuple2$.MODULE$.apply((Object)this.words_lex.$plus(abbr), (Object)this.words_map.$plus(abbrev)) : Tuple2$.MODULE$.apply((Object)this.words_lex.$minus$minus((Iterable<String>)((Iterable)new .colon.colon((Object)abbr, (List)Nil$.MODULE$))), (Object)this.words_map.$minus(abbr));
            }
            Tuple2 tuple24 = tuple23;
            Scan.Lexicon words_lex1 = (Scan.Lexicon)tuple24._1();
            Multi_Map words_map1 = (Multi_Map)tuple24._2();
            if (is_word) {
                tuple22 = Tuple2$.MODULE$.apply((Object)this.abbrevs_lex, this.abbrevs_map);
            } else {
                String string4 = text;
                String string5 = "";
                if (string4 == null ? string5 != null : !string4.equals(string5)) {
                    String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)rev_abbr);
                    tuple22 = Tuple2$.MODULE$.apply((Object)this.abbrevs_lex.$plus(rev_abbr), (Object)this.abbrevs_map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, abbrev)));
                } else {
                    tuple22 = Tuple2$.MODULE$.apply((Object)this.abbrevs_lex.$minus$minus((Iterable<String>)((Iterable)new .colon.colon((Object)rev_abbr, (List)Nil$.MODULE$))), (Object)this.abbrevs_map.$minus(rev_abbr));
                }
            }
            Tuple2 tuple25 = tuple22;
            Scan.Lexicon abbrevs_lex1 = (Scan.Lexicon)tuple25._1();
            Multi_Map abbrevs_map1 = (Multi_Map)tuple25._2();
            return new Completion(this.keywords, words_lex1, words_map1, abbrevs_lex1, abbrevs_map1);
        }
        throw new MatchError(tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Result> complete(History history, boolean unicode, boolean explicit, int start, CharSequence text, int caret, Language_Context language_context) {
        Tuple2 tuple2;
        None$ none$;
        None$ abbrevs_result;
        int length = text.length();
        Library.Reverse reverse_in = new Library.Reverse(text.subSequence(0, caret));
        Parsers.ParseResult parseResult = Scan$Parsers$.MODULE$.parse(Scan$Parsers$.MODULE$.literal(this.abbrevs_lex), reverse_in);
        if (parseResult instanceof Parsers.Success && ((Parsers.Success)parseResult).scala$util$parsing$combinator$Parsers$Success$$$outer() == Scan$Parsers$.MODULE$) {
            List<Tuple2<String, String>> abbrevs;
            Parsers.Success success = Scan$Parsers$.MODULE$.Success().unapply((Parsers.Success)parseResult);
            String string = (String)success._1();
            Reader reader = success._2();
            String reverse_abbr = string;
            List<Tuple2<String, String>> list = abbrevs = this.abbrevs_map.get_list(reverse_abbr);
            Nil$ nil$ = scala.package$.MODULE$.Nil();
            List<Tuple2<String, String>> list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                v1 = None$.MODULE$;
            } else {
                boolean ok;
                String abbr;
                if (!(list instanceof .colon.colon)) throw new MatchError(list);
                Tuple2 tuple22 = (Tuple2)((.colon.colon)list).head();
                List list3 = ((.colon.colon)list).next$access$1();
                if (tuple22 == null) throw new MatchError(list);
                String string2 = abbr = (String)tuple22._1();
                String string3 = Completion$.isabelle$Completion$$$antiquote;
                boolean bl = !(string2 != null ? !string2.equals(string3) : string3 != null) ? language_context.antiquotes() : (ok = language_context.symbols() || Completion$.isabelle$Completion$$$default_abbrevs.exists((Function1 & Serializable)_$12 -> {
                    Object object = _$12._1();
                    String string = abbr;
                    return !(object != null ? !object.equals(string) : string != null);
                }));
                v1 = ok ? Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)abbr, abbrevs)) : None$.MODULE$;
            }
        } else {
            v1 = abbrevs_result = None$.MODULE$;
        }
        if (abbrevs_result.isDefined()) {
            none$ = None$.MODULE$;
        } else {
            Some some;
            boolean word_context = caret < length && Completion$Word_Parsers$.MODULE$.is_word_char(text.charAt(caret));
            Option<String> option = Completion$Word_Parsers$.MODULE$.read_symbol(text.subSequence(0, caret));
            if (option instanceof Some) {
                String symbol = (String)((Some)option).value();
                some = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)symbol, (Object)""));
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                some = Completion$Word_Parsers$.MODULE$.read_word(text.subSequence(0, caret));
            }
            Some result = some;
            none$ = result.map((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    String full_word;
                    String word = (String)tuple2._1();
                    String underscores = (String)tuple2._2();
                    List<String> complete_words = this.words_lex.completions(word);
                    Nil$ completions = complete_words.contains((Object)(full_word = word + underscores)) && this.is_keyword_template(full_word, false) ? scala.package$.MODULE$.Nil() : (List)complete_words.map((Function1 & Serializable)complete_word -> {
                        boolean ok = this.is_keyword((String)complete_word) ? !word_context && language_context.is_outer() : language_context.symbols() || Completion$Word_Parsers$.MODULE$.is_symboloid(word);
                        return Tuple2$.MODULE$.apply(complete_word, (Object)BoxesRunTime.boxToBoolean((boolean)ok));
                    }).withFilter((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            String complete_word = (String)tuple2._1();
                            boolean ok = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                            return ok;
                        }
                        throw new MatchError((Object)tuple2);
                    }).flatMap((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            String complete_word = (String)tuple2._1();
                            boolean ok = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                            return this.words_map.get_list(complete_word).map((Function1 & Serializable)completion -> Tuple2$.MODULE$.apply((Object)complete_word, completion));
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    return Tuple2$.MODULE$.apply((Object)full_word, (Object)completions);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        None$ words_result = none$;
        Option option = abbrevs_result.orElse(() -> Completion.complete$$anonfun$1((Option)words_result));
        if (!(option instanceof Some) || (tuple2 = (Tuple2)((Some)option).value()) == null) return None$.MODULE$;
        String original = (String)tuple2._1();
        List completions = (List)tuple2._2();
        if (!completions.nonEmpty()) return None$.MODULE$;
        Text.Range range = Text$Range$.MODULE$.apply(-original.length(), 0).$plus(caret).$plus(start);
        boolean immediate = explicit || !Completion$Word_Parsers$.MODULE$.is_word(original) && !Completion$Word_Parsers$.MODULE$.is_symboloid(original) && Character.codePointCount(original, 0, original.length()) > 1;
        boolean unique = completions.length() == 1;
        List items = ((List)((IterableOps)completions.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String complete_word = (String)tuple2._1();
                String name0 = (String)tuple2._2();
                Tuple2 $9$ = tuple2;
                return true;
            }
            return false;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String complete_word = (String)tuple2._1();
                String name0 = (String)tuple2._2();
                Tuple2 $9$ = tuple2;
                String name1 = Completion.decode1$1(unicode, name0);
                String name2 = Completion.decode2$1(unicode, name0);
                return Tuple3$.MODULE$.apply((Object)$9$, (Object)name1, (Object)name2);
            }
            throw new MatchError((Object)tuple2);
        })).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple3 tuple3 = x$1;
            if (tuple3 != null && (tuple2 = (Tuple2)tuple3._1()) != null) {
                String complete_word = (String)tuple2._1();
                String name0 = (String)tuple2._2();
                String name1 = (String)tuple3._2();
                String name2 = (String)tuple3._3();
                String string = name1;
                String string2 = original;
                return string == null ? string2 != null : !string.equals(string2);
            }
            throw new MatchError((Object)tuple3);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple3 tuple3 = x$1;
            if (tuple3 != null && (tuple2 = (Tuple2)tuple3._1()) != null) {
                List list;
                String complete_word = (String)tuple2._1();
                String name0 = (String)tuple2._2();
                String name1 = (String)tuple3._2();
                String name2 = (String)tuple3._3();
                Tuple3 $10$ = tuple3;
                Tuple2<String, String> tuple22 = Completion$.MODULE$.split_template(name1);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                String s1 = (String)tuple22._1();
                String s2 = (String)tuple22._2();
                Tuple2<String, String> $11$ = tuple22;
                Tuple3 tuple32 = Tuple3$.MODULE$.apply($11$, (Object)s1, (Object)s2);
                Tuple2 $11$2 = (Tuple2)tuple32._1();
                String s12 = (String)tuple32._2();
                String s22 = (String)tuple32._3();
                int move = -s22.length();
                if (this.is_symbol(name0)) {
                    String string = name1;
                    String string2 = name2;
                    list = !(string != null ? !string.equals(string2) : string2 != null) ? (List)new .colon.colon((Object)name1, (List)Nil$.MODULE$) : (List)new .colon.colon((Object)name1, (List)new .colon.colon((Object)("(symbol " + package$.MODULE$.quote().apply((Object)name2) + ")"), (List)Nil$.MODULE$));
                } else {
                    list = this.is_keyword_template(complete_word, true) ? (List)new .colon.colon((Object)name1, (List)new .colon.colon((Object)("(template " + package$.MODULE$.quote().apply((Object)complete_word) + ")"), (List)Nil$.MODULE$)) : (move != 0 ? (List)new .colon.colon((Object)name1, (List)new .colon.colon((Object)"(template)", (List)Nil$.MODULE$)) : (this.is_keyword(complete_word) ? (List)new .colon.colon((Object)name1, (List)new .colon.colon((Object)"(keyword)", (List)Nil$.MODULE$)) : (List)new .colon.colon((Object)name1, (List)Nil$.MODULE$)));
                }
                List description = list;
                return Tuple4$.MODULE$.apply((Object)$10$, (Object)$11$2, (Object)BoxesRunTime.boxToInteger((int)move), (Object)description);
            }
            throw new MatchError((Object)tuple3);
        })).map((Function1 & Serializable)x$1 -> {
            Tuple4 tuple4 = x$1;
            if (tuple4 != null) {
                Tuple2 tuple2;
                Tuple3 tuple3 = (Tuple3)tuple4._1();
                Tuple2 tuple22 = (Tuple2)tuple4._2();
                if (tuple3 != null && (tuple2 = (Tuple2)tuple3._1()) != null) {
                    String complete_word = (String)tuple2._1();
                    String name0 = (String)tuple2._2();
                    String name1 = (String)tuple3._2();
                    String name2 = (String)tuple3._3();
                    if (tuple22 != null) {
                        String s1 = (String)tuple22._1();
                        String s2 = (String)tuple22._2();
                        int move = BoxesRunTime.unboxToInt((Object)tuple4._3());
                        List description = (List)tuple4._4();
                        return Completion$Item$.MODULE$.apply(range, original, name1, (List<String>)description, s1 + s2, move, immediate);
                    }
                }
            }
            throw new MatchError((Object)tuple4);
        });
        if (!items.isEmpty()) return Some$.MODULE$.apply((Object)Completion$Result$.MODULE$.apply(range, original, unique, (List<Item>)((List)((StrictOptimizedSeqOps)items.sortBy((Function1 & Serializable)_$13 -> _$13.name(), (Ordering)Ordering.String$.MODULE$)).sorted(history.ordering()))));
        return None$.MODULE$;
    }

    private static final String is_keyword_template$$anonfun$1(String name$1) {
        return name$1;
    }

    private static final Option complete$$anonfun$1(Option words_result$1) {
        return words_result$1;
    }

    private static final String decode1$1(boolean unicode$1, String s) {
        if (unicode$1) {
            return Symbol$.MODULE$.decode(s);
        }
        return s;
    }

    private static final String decode2$1(boolean unicode$2, String s) {
        if (unicode$2) {
            return s;
        }
        return Symbol$.MODULE$.decode(s);
    }

    public static final class History {
        private final SortedMap<String, Object> rep;

        public static History empty() {
            return Completion$History$.MODULE$.empty();
        }

        public static History load() {
            return Completion$History$.MODULE$.load();
        }

        public History(SortedMap<String, Object> rep) {
            this.rep = rep;
        }

        public String toString() {
            return this.rep.mkString("Completion.History(", ",", ")");
        }

        public int frequency(String name) {
            return BoxesRunTime.unboxToInt((Object)Completion$.MODULE$.isabelle$Completion$$$default_frequency(Symbol$.MODULE$.encode(name)).getOrElse(() -> this.frequency$$anonfun$1(name)));
        }

        public History $plus(Tuple2<String, Object> entry) {
            Tuple2<String, Object> tuple2 = entry;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String name = (String)tuple2._1();
            int freq = BoxesRunTime.unboxToInt((Object)tuple2._2());
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)name, (Object)BoxesRunTime.boxToInteger((int)freq));
            String name2 = (String)tuple22._1();
            int freq2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
            String string = name2;
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this;
            }
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)name2);
            return new History((SortedMap<String, Object>)((SortedMap)this.rep.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToInteger((int)(this.frequency(name2) + freq2))))));
        }

        public Ordering<Item> ordering() {
            return new Ordering<Item>(this){
                private final /* synthetic */ History $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    PartialOrdering.$init$((PartialOrdering)this);
                    Ordering.$init$((Ordering)this);
                }

                public int compare(Item item1, Item item2) {
                    return new RichInt(Predef$.MODULE$.intWrapper(this.$outer.frequency(item2.name()))).compare((Object)BoxesRunTime.boxToInteger((int)this.$outer.frequency(item1.name())));
                }
            };
        }

        public void save() {
            Isabelle_System$.MODULE$.make_directory(Completion$.isabelle$Completion$$$COMPLETION_HISTORY.dir());
            File$.MODULE$.write_backup(Completion$.isabelle$Completion$$$COMPLETION_HISTORY, Symbol$.MODULE$.encode_yxml((List<XML.Tree>)((List)XML$Encode$.MODULE$.list(XML$Encode$.MODULE$.pair(XML$Encode$.MODULE$.string(), XML$Encode$.MODULE$.int())).apply((Object)this.rep.toList()))));
        }

        private final int frequency$$anonfun$1(String name$2) {
            return BoxesRunTime.unboxToInt((Object)this.rep.getOrElse((Object)name$2, Completion$::isabelle$Completion$History$$_$frequency$$anonfun$1$$anonfun$1));
        }
    }

    public static class History_Variable {
        private History history = Completion$History$.MODULE$.empty();

        public History value() {
            History history;
            History_Variable history_Variable = this;
            synchronized (history_Variable) {
                history = this.history;
            }
            return history;
        }

        public void load() {
            History h = Completion$History$.MODULE$.load();
            History_Variable history_Variable = this;
            synchronized (history_Variable) {
                this.history = h;
            }
        }

        public void update(Item item, int freq) {
            History_Variable history_Variable = this;
            synchronized (history_Variable) {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)item.name());
                this.history = this.history.$plus((Tuple2<String, Object>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)freq)));
            }
        }

        public int update$default$2() {
            return 1;
        }
    }

    public static class Item
    implements Product,
    Serializable {
        private final Text.Range range;
        private final String original;
        private final String name;
        private final List description;
        private final String replacement;
        private final int move;
        private final boolean immediate;

        public static Item apply(Text.Range range, String string, String string2, List<String> list, String string3, int n, boolean bl) {
            return Completion$Item$.MODULE$.apply(range, string, string2, list, string3, n, bl);
        }

        public static Item fromProduct(Product product) {
            return Completion$Item$.MODULE$.fromProduct(product);
        }

        public static Item unapply(Item item) {
            return Completion$Item$.MODULE$.unapply(item);
        }

        public Item(Text.Range range, String original, String name, List<String> description, String replacement, int move, boolean immediate) {
            this.range = range;
            this.original = original;
            this.name = name;
            this.description = description;
            this.replacement = replacement;
            this.move = move;
            this.immediate = immediate;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.range()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.original()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.description()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.replacement()));
            n = Statics.mix((int)n, (int)this.move());
            n = Statics.mix((int)n, (int)(this.immediate() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)7);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Item)) return false;
            Item item = (Item)object;
            if (this.move() != item.move()) return false;
            if (this.immediate() != item.immediate()) return false;
            Text.Range range = this.range();
            Text.Range range2 = item.range();
            if (range == null) {
                if (range2 != null) {
                    return false;
                }
            } else if (!((Object)range).equals(range2)) return false;
            String string = this.original();
            String string2 = item.original();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = item.name();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            List<String> list = this.description();
            List<String> list2 = item.description();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            String string5 = this.replacement();
            String string6 = item.replacement();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (!item.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Item;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "Item";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return BoxesRunTime.boxToInteger((int)this._6());
                }
                case 6: {
                    return BoxesRunTime.boxToBoolean((boolean)this._7());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "range";
                }
                case 1: {
                    return "original";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "description";
                }
                case 4: {
                    return "replacement";
                }
                case 5: {
                    return "move";
                }
                case 6: {
                    return "immediate";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Text.Range range() {
            return this.range;
        }

        public String original() {
            return this.original;
        }

        public String name() {
            return this.name;
        }

        public List<String> description() {
            return this.description;
        }

        public String replacement() {
            return this.replacement;
        }

        public int move() {
            return this.move;
        }

        public boolean immediate() {
            return this.immediate;
        }

        public Item copy(Text.Range range, String original, String name, List<String> description, String replacement, int move, boolean immediate) {
            return new Item(range, original, name, description, replacement, move, immediate);
        }

        public Text.Range copy$default$1() {
            return this.range();
        }

        public String copy$default$2() {
            return this.original();
        }

        public String copy$default$3() {
            return this.name();
        }

        public List<String> copy$default$4() {
            return this.description();
        }

        public String copy$default$5() {
            return this.replacement();
        }

        public int copy$default$6() {
            return this.move();
        }

        public boolean copy$default$7() {
            return this.immediate();
        }

        public Text.Range _1() {
            return this.range();
        }

        public String _2() {
            return this.original();
        }

        public String _3() {
            return this.name();
        }

        public List<String> _4() {
            return this.description();
        }

        public String _5() {
            return this.replacement();
        }

        public int _6() {
            return this.move();
        }

        public boolean _7() {
            return this.immediate();
        }
    }

    public static class Language_Context
    implements Product,
    Serializable {
        private final String language;
        private final boolean symbols;
        private final boolean antiquotes;

        public static Language_Context ML_inner() {
            return Completion$Language_Context$.MODULE$.ML_inner();
        }

        public static Language_Context ML_outer() {
            return Completion$Language_Context$.MODULE$.ML_outer();
        }

        public static Language_Context SML_outer() {
            return Completion$Language_Context$.MODULE$.SML_outer();
        }

        public static Language_Context apply(Markup.Language language) {
            return Completion$Language_Context$.MODULE$.apply(language);
        }

        public static Language_Context apply(String string, boolean bl, boolean bl2) {
            return Completion$Language_Context$.MODULE$.apply(string, bl, bl2);
        }

        public static Language_Context fromProduct(Product product) {
            return Completion$Language_Context$.MODULE$.fromProduct(product);
        }

        public static Language_Context inner() {
            return Completion$Language_Context$.MODULE$.inner();
        }

        public static Language_Context outer() {
            return Completion$Language_Context$.MODULE$.outer();
        }

        public static Language_Context unapply(Language_Context language_Context) {
            return Completion$Language_Context$.MODULE$.unapply(language_Context);
        }

        public Language_Context(String language, boolean symbols, boolean antiquotes) {
            this.language = language;
            this.symbols = symbols;
            this.antiquotes = antiquotes;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.language()));
            n = Statics.mix((int)n, (int)(this.symbols() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.antiquotes() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Language_Context)) return false;
            Language_Context language_Context = (Language_Context)object;
            if (this.symbols() != language_Context.symbols()) return false;
            if (this.antiquotes() != language_Context.antiquotes()) return false;
            String string = this.language();
            String string2 = language_Context.language();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!language_Context.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Language_Context;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Language_Context";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "language";
                }
                case 1: {
                    return "symbols";
                }
                case 2: {
                    return "antiquotes";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String language() {
            return this.language;
        }

        public boolean symbols() {
            return this.symbols;
        }

        public boolean antiquotes() {
            return this.antiquotes;
        }

        public boolean is_outer() {
            String string = this.language();
            String string2 = "";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }

        public Language_Context copy(String language, boolean symbols, boolean antiquotes) {
            return new Language_Context(language, symbols, antiquotes);
        }

        public String copy$default$1() {
            return this.language();
        }

        public boolean copy$default$2() {
            return this.symbols();
        }

        public boolean copy$default$3() {
            return this.antiquotes();
        }

        public String _1() {
            return this.language();
        }

        public boolean _2() {
            return this.symbols();
        }

        public boolean _3() {
            return this.antiquotes();
        }
    }

    public static class Names
    extends Semantic
    implements Product,
    Serializable {
        private final int total;
        private final List names;

        public static Names apply(int n, List<Tuple2<String, Tuple2<String, String>>> list) {
            return Completion$Names$.MODULE$.apply(n, list);
        }

        public static Names fromProduct(Product product) {
            return Completion$Names$.MODULE$.fromProduct(product);
        }

        public static Names unapply(Names names) {
            return Completion$Names$.MODULE$.unapply(names);
        }

        public Names(int total, List<Tuple2<String, Tuple2<String, String>>> names) {
            this.total = total;
            this.names = names;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.total());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.names()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Names)) return false;
            Names names = (Names)object;
            if (this.total() != names.total()) return false;
            List<Tuple2<String, Tuple2<String, String>>> list = this.names();
            List<Tuple2<String, Tuple2<String, String>>> list2 = names.names();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!names.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Names;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Names";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "total";
            }
            if (1 == n2) {
                return "names";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int total() {
            return this.total;
        }

        public List<Tuple2<String, Tuple2<String, String>>> names() {
            return this.names;
        }

        public Option<Result> complete(Text.Range range, History history, boolean unicode, String original) {
            List items = ((List)((IterableOps)this.names().withFilter(Completion$::isabelle$Completion$Names$$_$_$$anonfun$13).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    String xname = (String)tuple2._1();
                    if (tuple22 != null) {
                        String kind = (String)tuple22._1();
                        String name = (String)tuple22._2();
                        Tuple2 $3$ = tuple2;
                        String xname1 = this.decode$1(unicode, xname);
                        return Tuple2$.MODULE$.apply((Object)$3$, (Object)xname1);
                    }
                }
                throw new MatchError((Object)tuple2);
            })).withFilter(arg_0 -> Completion$.isabelle$Completion$Names$$_$_$$anonfun$15(original, arg_0)).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    String xname = (String)tuple2._1();
                    if (tuple23 != null) {
                        Tuple2 tuple24;
                        String kind = (String)tuple23._1();
                        String name = (String)tuple23._2();
                        String xname1 = (String)tuple22._2();
                        Tuple2 $4$ = tuple22;
                        String string = kind;
                        String string2 = "";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            v1 = Tuple2$.MODULE$.apply((Object)name, package$.MODULE$.quote().apply((Object)this.decode$1(unicode, name)));
                        } else {
                            String string3 = xname;
                            String string4 = name;
                            v1 = tuple24 = Tuple2$.MODULE$.apply((Object)Long_Name$.MODULE$.qualify(kind, name), (Object)(Word$.MODULE$.informal(kind) + (String)(!(string3 != null ? !string3.equals(string4) : string4 != null) ? "" : " " + package$.MODULE$.quote().apply((Object)this.decode$1(unicode, name)))));
                        }
                        if (tuple24 == null) {
                            throw new MatchError((Object)tuple24);
                        }
                        String full_name = (String)tuple24._1();
                        String descr_name = (String)tuple24._2();
                        Tuple2 $5$ = tuple24;
                        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$5$, (Object)full_name, (Object)descr_name);
                        Tuple2 $5$2 = (Tuple2)tuple3._1();
                        String full_name2 = (String)tuple3._2();
                        String descr_name2 = (String)tuple3._3();
                        return Tuple2$.MODULE$.apply((Object)$4$, (Object)$5$2);
                    }
                }
                throw new MatchError((Object)tuple22);
            })).map(arg_0 -> Completion$.isabelle$Completion$Names$$_$_$$anonfun$17(original, range, arg_0));
            if (items.isEmpty()) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply((Object)Completion$Result$.MODULE$.apply(range, original, this.names().length() == 1, (List<Item>)((List)items.sorted(history.ordering()))));
        }

        public Names copy(int total, List<Tuple2<String, Tuple2<String, String>>> names) {
            return new Names(total, names);
        }

        public int copy$default$1() {
            return this.total();
        }

        public List<Tuple2<String, Tuple2<String, String>>> copy$default$2() {
            return this.names();
        }

        public int _1() {
            return this.total();
        }

        public List<Tuple2<String, Tuple2<String, String>>> _2() {
            return this.names();
        }

        private final String decode$1(boolean unicode$3, String s) {
            if (unicode$3) {
                return Symbol$.MODULE$.decode(s);
            }
            return s;
        }
    }

    public static class Result
    implements Product,
    Serializable {
        private final Text.Range range;
        private final String original;
        private final boolean unique;
        private final List items;

        public static Result apply(Text.Range range, String string, boolean bl, List<Item> list) {
            return Completion$Result$.MODULE$.apply(range, string, bl, list);
        }

        public static Result empty(Text.Range range) {
            return Completion$Result$.MODULE$.empty(range);
        }

        public static Result fromProduct(Product product) {
            return Completion$Result$.MODULE$.fromProduct(product);
        }

        public static Option<Result> merge(History history, Seq<Option<Result>> seq) {
            return Completion$Result$.MODULE$.merge(history, seq);
        }

        public static Result unapply(Result result) {
            return Completion$Result$.MODULE$.unapply(result);
        }

        public Result(Text.Range range, String original, boolean unique, List<Item> items) {
            this.range = range;
            this.original = original;
            this.unique = unique;
            this.items = items;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.range()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.original()));
            n = Statics.mix((int)n, (int)(this.unique() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.items()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Result)) return false;
            Result result = (Result)object;
            if (this.unique() != result.unique()) return false;
            Text.Range range = this.range();
            Text.Range range2 = result.range();
            if (range == null) {
                if (range2 != null) {
                    return false;
                }
            } else if (!((Object)range).equals(range2)) return false;
            String string = this.original();
            String string2 = result.original();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            List<Item> list = this.items();
            List<Item> list2 = result.items();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!result.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Result;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Result";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "range";
                }
                case 1: {
                    return "original";
                }
                case 2: {
                    return "unique";
                }
                case 3: {
                    return "items";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Text.Range range() {
            return this.range;
        }

        public String original() {
            return this.original;
        }

        public boolean unique() {
            return this.unique;
        }

        public List<Item> items() {
            return this.items;
        }

        public Result copy(Text.Range range, String original, boolean unique, List<Item> items) {
            return new Result(range, original, unique, items);
        }

        public Text.Range copy$default$1() {
            return this.range();
        }

        public String copy$default$2() {
            return this.original();
        }

        public boolean copy$default$3() {
            return this.unique();
        }

        public List<Item> copy$default$4() {
            return this.items();
        }

        public Text.Range _1() {
            return this.range();
        }

        public String _2() {
            return this.original();
        }

        public boolean _3() {
            return this.unique();
        }

        public List<Item> _4() {
            return this.items();
        }
    }

    public static abstract class Semantic {
        public static int ordinal(Semantic semantic) {
            return Completion$Semantic$.MODULE$.ordinal(semantic);
        }
    }
}

