/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Caddy_Setup;
import isabelle.Caddy_Setup$Platform_Info$;
import isabelle.Components;
import isabelle.Components$;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_Platform$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Library$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.SSH;
import isabelle.Scala_Project$;
import isabelle.Url$;
import isabelle.Word$;
import isabelle.package$;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Caddy_Setup$
implements Serializable {
    public static final Caddy_Setup$Platform_Info$ Platform_Info;
    private static final List all_platforms;
    private static final Isabelle_Tool isabelle_tool;
    public static final Caddy_Setup$ MODULE$;

    private Caddy_Setup$() {
    }

    static {
        MODULE$ = new Caddy_Setup$();
        all_platforms = (List)new .colon.colon((Object)Caddy_Setup$Platform_Info$.MODULE$.apply("arm64-darwin", "v{V}/xcaddy_{V}_mac_arm64.tar.gz"), (List)new .colon.colon((Object)Caddy_Setup$Platform_Info$.MODULE$.apply("arm64-linux", "v{V}/xcaddy_{V}_linux_arm64.tar.gz"), (List)new .colon.colon((Object)Caddy_Setup$Platform_Info$.MODULE$.apply("x86_64-darwin", "v{V}/xcaddy_{V}_mac_amd64.tar.gz"), (List)new .colon.colon((Object)Caddy_Setup$Platform_Info$.MODULE$.apply("x86_64-linux", "v{V}/xcaddy_{V}_linux_amd64.tar.gz"), (List)new .colon.colon((Object)Caddy_Setup$Platform_Info$.MODULE$.apply("x86_64-windows", "v{V}/xcaddy_{V}_windows_amd64.zip"), (List)Nil$.MODULE$)))));
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("caddy_setup", "dynamic setup of Caddy component", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)this.default_target_dir());
            ObjectRef xcaddy_url = ObjectRef.create((Object)this.default_xcaddy_url());
            ObjectRef xcaddy_version = ObjectRef.create((Object)this.default_xcaddy_version());
            ObjectRef caddy_modules = ObjectRef.create((Object)this.default_caddy_modules());
            ObjectRef caddy_version = ObjectRef.create((Object)this.default_caddy_version());
            BooleanRef force = BooleanRef.create((boolean)false);
            BooleanRef verbose = BooleanRef.create((boolean)false);
            Object[] objectArray = new Tuple2[7];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"N:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                caddy_modules$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                xcaddy_url$1.elem = arg;
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"V:");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)arg -> {
                caddy_version$1.elem = arg;
            });
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"W:");
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (JProcedure1 & Serializable)arg -> {
                xcaddy_version$1.elem = arg;
            });
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"f");
            objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (JProcedure1 & Serializable)_$2 -> {
                force$1.elem = true;
            });
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"v");
            objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (JProcedure1 & Serializable)_$3 -> {
                verbose$1.elem = true;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(verbose.elem, Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.caddy_setup((String)caddy_version.elem, (String)caddy_modules.elem, (String)xcaddy_url.elem, (String)xcaddy_version.elem, (Path)target_dir.elem, progress, force.elem);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Caddy_Setup$.class);
    }

    public List<Caddy_Setup.Platform_Info> all_platforms() {
        return all_platforms;
    }

    public Path default_target_dir() {
        return Components$.MODULE$.default_components_base();
    }

    public String default_caddy_version() {
        return Isabelle_System$.MODULE$.getenv_strict("ISABELLE_CADDY_SETUP_VERSION", Isabelle_System$.MODULE$.getenv_strict$default$2());
    }

    public String default_caddy_modules() {
        return Isabelle_System$.MODULE$.getenv_strict("ISABELLE_CADDY_SETUP_MODULES", Isabelle_System$.MODULE$.getenv_strict$default$2());
    }

    public String default_xcaddy_url() {
        return "https://github.com/caddyserver/xcaddy/releases/download";
    }

    public String default_xcaddy_version() {
        return "0.4.4";
    }

    public List<String> show_settings() {
        return ((List)new .colon.colon((Object)"ISABELLE_CADDY_SETUP_VERSION", (List)new .colon.colon((Object)"ISABELLE_CADDY_SETUP_MODULES", (List)Nil$.MODULE$))).map((Function1 & Serializable)a -> {
            String b = Isabelle_System$.MODULE$.getenv((String)a, Isabelle_System$.MODULE$.getenv$default$2());
            return a + "=" + package$.MODULE$.quote().apply((Object)b);
        });
    }

    public void caddy_setup(String caddy_version, String caddy_modules, String xcaddy_url, String xcaddy_version, Path target_dir, Progress progress, boolean force) {
        String platform = Isabelle_Platform$.MODULE$.local().ISABELLE_PLATFORM(true, true);
        Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic("caddy-" + caddy_version)), Components$Directory$.MODULE$.apply$default$2());
        Components.Directory component_dir = directory.create(directory.create$default$1(), true);
        progress.echo("Component directory " + component_dir, progress.echo$default$2());
        component_dir.write_settings("\nISABELLE_CADDY_HOME=\"$COMPONENT\"\n\nif [ -n \"$ISABELLE_WINDOWS_PLATFORM64\" -a -d \"$ISABELLE_CADDY_HOME/$ISABELLE_WINDOWS_PLATFORM64\" ]; then\n  ISABELLE_CADDY=\"$ISABELLE_CADDY_HOME/$ISABELLE_WINDOWS_PLATFORM64/caddy.exe\"\nelif [ -n \"$ISABELLE_APPLE_PLATFORM64\" -a -d \"$ISABELLE_CADDY_HOME/$ISABELLE_APPLE_PLATFORM64\" ]; then\n  ISABELLE_CADDY=\"$ISABELLE_CADDY_HOME/$ISABELLE_APPLE_PLATFORM64/caddy\"\nelif [ -d \"$ISABELLE_CADDY_HOME/$ISABELLE_PLATFORM64\" ]; then\n  ISABELLE_CADDY=\"$ISABELLE_CADDY_HOME/$ISABELLE_PLATFORM64/caddy\"\nfi\n");
        ((Option)package$.MODULE$.proper_string().apply((Object)Isabelle_System$.MODULE$.getenv("ISABELLE_CADDY_HOME", Isabelle_System$.MODULE$.getenv$default$2()))).foreach((Function1)(JProcedure1 & Serializable)old -> Components$.MODULE$.update_components(false, Path$.MODULE$.explode((String)old), Components$.MODULE$.update_components$default$3()));
        Components$.MODULE$.update_components(true, component_dir.path(), Components$.MODULE$.update_components$default$3());
        Isabelle_System$.MODULE$.with_tmp_dir("tmp", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)tmp_dir -> {
            Caddy_Setup.Platform_Info platform_info = (Caddy_Setup.Platform_Info)MODULE$.all_platforms().find((Function1 & Serializable)_$1 -> {
                String string = _$1.platform();
                String string2 = platform;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).getOrElse(() -> Caddy_Setup$.$anonfun$10(platform));
            Path platform_dir = component_dir.path().$plus(platform_info.path());
            if (platform_dir.is_dir() && !force) {
                progress.echo_warning("Platform " + platform + " already installed", progress.echo_warning$default$2());
                return;
            }
            progress.echo("Platform " + platform + " ...", progress.echo$default$2());
            progress.expose_interrupt();
            Isabelle_System$.MODULE$.make_directory(platform_dir);
            Path xcaddy_dir = Isabelle_System$.MODULE$.make_directory(tmp_dir.$plus(Path$.MODULE$.explode("xcaddy")));
            String xcaddy_download = platform_info.xcaddy_download(xcaddy_url, xcaddy_version);
            String xcaddy_archive_name = (String)Url$.MODULE$.get_base_name(xcaddy_download, Url$.MODULE$.get_base_name$default$2()).getOrElse(() -> Caddy_Setup$.$anonfun$11(xcaddy_download));
            Path xcaddy_archive_path = tmp_dir.$plus(Path$.MODULE$.basic(xcaddy_archive_name));
            Isabelle_System$.MODULE$.download_file(xcaddy_download, xcaddy_archive_path, Isabelle_System$.MODULE$.download_file$default$3());
            Isabelle_System$.MODULE$.extract(xcaddy_archive_path, xcaddy_dir, Isabelle_System$.MODULE$.extract$default$3());
            progress.echo("Building caddy " + caddy_version, progress.echo$default$2());
            String string = Library$.MODULE$.make_lines((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"set -e", "xcaddy/xcaddy build v" + Bash$.MODULE$.string(caddy_version) + Word$.MODULE$.explode(caddy_modules).map((Function1 & Serializable)s -> " --with " + Bash$.MODULE$.string((String)s)).mkString(), "./caddy list-modules"}));
            boolean bl = progress.verbose();
            SSH.System system = progress.bash$default$2();
            Map<String, String> map = progress.bash$default$4();
            boolean bl2 = progress.bash$default$5();
            long l = progress.bash$default$7();
            boolean bl3 = progress.bash$default$8();
            progress.bash(string, system, (Path)tmp_dir, map, bl2, bl, l, bl3).check();
            Isabelle_System$.MODULE$.copy_file(tmp_dir.$plus(Path$.MODULE$.explode("caddy").platform_exe()), platform_dir);
        });
        File$.MODULE$.find_files(component_dir.path().file(), (Function1<File, Object>)(Function1 & Serializable)file -> File$.MODULE$.is_exe(file.getName()), File$.MODULE$.find_files$default$3(), File$.MODULE$.find_files$default$4()).foreach((Function1)(JProcedure1 & Serializable)file -> File$.MODULE$.set_executable(File$.MODULE$.path((File)file), File$.MODULE$.set_executable$default$2()));
        File$.MODULE$.write(component_dir.README(), "This installation of Caddy has been produced via \"isabelle caddy_setup\".\n\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
    }

    public String caddy_setup$default$1() {
        return this.default_caddy_version();
    }

    public String caddy_setup$default$2() {
        return this.default_caddy_modules();
    }

    public String caddy_setup$default$3() {
        return this.default_xcaddy_url();
    }

    public String caddy_setup$default$4() {
        return this.default_xcaddy_version();
    }

    public Path caddy_setup$default$5() {
        return this.default_target_dir();
    }

    public Progress caddy_setup$default$6() {
        return new Progress();
    }

    public boolean caddy_setup$default$7() {
        return false;
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle caddy_setup [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -N MODULES   non-standard modules for caddy\n                 (default: ISABELLE_CADDY_SETUP_MODULES=\"" + this.default_caddy_modules() + "\")\n    -U URL       download URL for xcaddy (default: \"" + this.default_xcaddy_url() + "\")\n    -V VERSION   version for caddy\n                 (default: ISABELLE_CADDY_SETUP_VERSION=\"" + this.default_caddy_version() + "\")\n    -W VERSION   version for xcaddy (default: \"" + this.default_xcaddy_version() + "\")\n    -f           force fresh installation of specified platforms\n    -v           verbose\n\n  Build the Caddy webserver via xcaddy and configure it as Isabelle\n  component. See also https://github.com/caddyserver/xcaddy";
    }

    private static final Caddy_Setup.Platform_Info $anonfun$10(String platform$3) {
        return (Caddy_Setup.Platform_Info)package$.MODULE$.error().apply((Object)("Bad platform " + package$.MODULE$.quote().apply((Object)platform$3)));
    }

    private static final String $anonfun$11(String xcaddy_download$1) {
        return (String)package$.MODULE$.error().apply((Object)("Malformed download URL " + package$.MODULE$.quote().apply((Object)xcaddy_download$1)));
    }
}

