/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Browser_Info;
import isabelle.Browser_Info$Config$;
import isabelle.Browser_Info$Elements$;
import isabelle.Browser_Info$Entity_Ref$;
import isabelle.Browser_Info$HTML_Document$;
import isabelle.Browser_Info$Meta_Info$;
import isabelle.Browser_Info$Meta_Info$Item$;
import isabelle.Browser_Info$Node_Context$;
import isabelle.Browser_Info$Theory_Ref$;
import isabelle.Build$;
import isabelle.Bytes$;
import isabelle.Compress;
import isabelle.Compress$Cache$;
import isabelle.Compress$Options_Zstd$;
import isabelle.Document;
import isabelle.Document_Build$;
import isabelle.Document_Info;
import isabelle.Document_Info$;
import isabelle.Export;
import isabelle.Export$;
import isabelle.Export_Theory;
import isabelle.File$;
import isabelle.File_Store$;
import isabelle.HTML$;
import isabelle.Isabelle_System$;
import isabelle.Library$;
import isabelle.Markup;
import isabelle.Markup$;
import isabelle.Markup$Elements$;
import isabelle.Markup$Language$;
import isabelle.Par_List$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.Rendering$;
import isabelle.SQL;
import isabelle.SSH;
import isabelle.SSH$;
import isabelle.Sessions;
import isabelle.Store;
import isabelle.Symbol$;
import isabelle.XML;
import isabelle.graphview.Graph_File$;
import isabelle.package$;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Browser_Info$
implements Serializable {
    private static final Path default_database;
    private static final Path default_dir;
    public static final Browser_Info$Config$ Config;
    public static final Browser_Info$Meta_Info$ Meta_Info;
    public static final Browser_Info$Elements$ Elements;
    private static final Browser_Info.Elements default_elements;
    private static final Browser_Info.Elements extra_elements;
    public static final Browser_Info$HTML_Document$ HTML_Document;
    public static final Browser_Info$Theory_Ref$ Theory_Ref;
    public static final Browser_Info$Entity_Ref$ Entity_Ref;
    public static final Browser_Info$Node_Context$ Node_Context;
    private static final Path session_graph_path;
    public static final Browser_Info$ MODULE$;

    private Browser_Info$() {
    }

    static {
        MODULE$ = new Browser_Info$();
        default_database = Path$.MODULE$.explode("$ISABELLE_BROWSER_INFO_LIBRARY");
        default_dir = Path$.MODULE$.explode("$ISABELLE_BROWSER_INFO");
        default_elements = Browser_Info$Elements$.MODULE$.apply(Rendering$.MODULE$.foreground_elements().$plus$plus(Rendering$.MODULE$.text_color_elements()).$plus(Markup$.MODULE$.TCLASS()).$plus(Markup$.MODULE$.TCONST()).$plus(Markup$.MODULE$.CONST()).$plus(Markup$.MODULE$.NUMERAL()).$plus(Markup$.MODULE$.COMMENT()).$plus(Markup$.MODULE$.ENTITY()).$plus(Markup$.MODULE$.LANGUAGE()).$plus(Markup$.MODULE$.PATH()).$plus(Markup$.MODULE$.URL()), Markup$Elements$.MODULE$.apply((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Markup$.MODULE$.THEORY(), Markup$.MODULE$.TYPE_NAME(), Markup$.MODULE$.CONSTANT(), Markup$.MODULE$.FACT(), Markup$.MODULE$.CLASS(), Markup$.MODULE$.LOCALE(), Markup$.MODULE$.FREE()})), Browser_Info$Elements$.MODULE$.$lessinit$greater$default$3());
        Markup.Elements elements = MODULE$.default_elements().html().$plus$plus(Rendering$.MODULE$.markdown_elements());
        Markup.Elements elements2 = Markup$Elements$.MODULE$.apply((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Markup$Language$.MODULE$.DOCUMENT()}));
        Markup.Elements elements3 = Browser_Info$Elements$.MODULE$.$lessinit$greater$default$2();
        extra_elements = Browser_Info$Elements$.MODULE$.apply(elements, elements3, elements2);
        session_graph_path = Path$.MODULE$.explode("session_graph.pdf");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Browser_Info$.class);
    }

    public Path default_database() {
        return default_database;
    }

    public Path default_dir() {
        return default_dir;
    }

    public void make_database(Path database, Path dir) {
        Compress.Options_Zstd options_Zstd = Compress$Options_Zstd$.MODULE$.apply(8);
        Compress.Cache cache = Compress$Cache$.MODULE$.make();
        Function1<File, Object> function1 = File_Store$.MODULE$.make_database$default$3();
        String string = File_Store$.MODULE$.make_database$default$4();
        File_Store$.MODULE$.make_database(database, dir, function1, string, options_Zstd, cache);
    }

    public Path make_database$default$1() {
        return this.default_database();
    }

    public Path make_database$default$2() {
        return this.default_dir();
    }

    public Browser_Info.Elements default_elements() {
        return default_elements;
    }

    public Browser_Info.Elements extra_elements() {
        return extra_elements;
    }

    public Browser_Info.Context context(Sessions.Structure sessions_structure, Browser_Info.Elements elements, Path root_dir, Document_Info document_info) {
        return new Browser_Info.Context(sessions_structure, elements, root_dir, document_info);
    }

    public Browser_Info.Elements context$default$2() {
        return this.default_elements();
    }

    public Path context$default$3() {
        return Path$.MODULE$.current();
    }

    public Document_Info context$default$4() {
        return Document_Info$.MODULE$.empty();
    }

    public Path session_graph_path() {
        return session_graph_path;
    }

    public void build_session(Browser_Info.Context context, Export.Session_Context session_context, Progress progress) {
        progress.expose_interrupt();
        String session_name = session_context.session_name();
        Sessions.Info session_info = session_context.sessions_structure().apply(session_name);
        Path session_dir = context.session_dir(session_name).expand();
        progress.echo("Presenting " + session_name + " in " + session_dir + " ...", progress.echo$default$2());
        Browser_Info$Meta_Info$.MODULE$.init_directory(context.chapter_dir(session_name), true);
        Browser_Info$Meta_Info$.MODULE$.clean_directory(session_dir);
        Document_Info.Session session = context.document_info().the_session(session_name);
        Bytes$.MODULE$.write(session_dir.$plus(this.session_graph_path()), Graph_File$.MODULE$.make_pdf(session_info.options(), session_context.session_base().session_graph_display()));
        List document_variants = session_info.document_variants().flatMap((Function1 & Serializable)doc -> session_context.session_db(session_context.session_db$default$1()).flatMap((Function1 & Serializable)db -> Document_Build$.MODULE$.read_document((SQL.Database)db, session_name, doc.name()).map((Function1 & Serializable)document -> {
            Path doc_path = session_dir.$plus(doc.path().pdf());
            if (Path$.MODULE$.eq_case_insensitive(doc.path().pdf(), MODULE$.session_graph_path())) {
                package$.MODULE$.error().apply((Object)("Illegal document variant " + package$.MODULE$.quote().apply((Object)doc.name()) + " (conflict with " + MODULE$.session_graph_path() + ")"));
            }
            progress.echo("Presenting document " + session_name + "/" + doc.name(), true);
            if (session_info.document_echo()) {
                progress.echo("Document at " + doc_path, progress.echo$default$2());
            }
            Bytes$.MODULE$.write(doc_path, document.pdf());
            return doc;
        })));
        XML.Elem link1 = HTML$.MODULE$.link(this.session_graph_path(), HTML$.MODULE$.text("theory dependencies"));
        List links2 = document_variants.map((Function1 & Serializable)doc -> HTML$.MODULE$.link(doc.path().pdf(), HTML$.MODULE$.text(doc.name())));
        List<XML.Tree> list = HTML$.MODULE$.break();
        List document_links = (List)Library$.MODULE$.separate(HTML$.MODULE$.nl().$colon$colon$colon(list), links2.$colon$colon((Object)link1).map((Function1 & Serializable)link -> {
            List<XML.Tree> list = HTML$.MODULE$.text("View ");
            return ((List)new .colon.colon(link, (List)Nil$.MODULE$)).$colon$colon$colon(list);
        })).flatten(Predef$.MODULE$.$conforms());
        List theories = session.used_theories().map((Function1 & Serializable)theory_name -> this.present_theory$1(progress, session_context, context, session_name, session_dir, (String)theory_name));
        String title = "Session " + session_name;
        XML.Tree tree = context.head(title, (List<XML.Tree>)((List)new .colon.colon((Object)HTML$.MODULE$.par().apply((List<XML.Tree>)document_links), (List)Nil$.MODULE$)));
        HTML$.MODULE$.write_document(session_dir, "index.html", (List<XML.Tree>)((List)new .colon.colon((Object)HTML$.MODULE$.title().apply(title + Isabelle_System$.MODULE$.isabelle_heading()), (List)Nil$.MODULE$)), (List<XML.Tree>)context.contents("Theories", (List<List<XML.Tree>>)theories, context.contents$default$3()).$colon$colon((Object)tree), (Option<Path>)Some$.MODULE$.apply((Object)context.root_dir()), HTML$.MODULE$.write_document$default$6(), HTML$.MODULE$.write_document$default$7(), HTML$.MODULE$.write_document$default$8());
        Browser_Info$Meta_Info$.MODULE$.set_build_uuid(session_dir, session.build_uuid());
        context.update_chapter(session_name, session_info.description());
    }

    public Progress build_session$default$3() {
        return new Progress();
    }

    public void build(Browser_Info.Config browser_info, Store store, Sessions.Deps deps, List<String> sessions, Progress progress, SSH.Server server) {
        Path root_dir = browser_info.presentation_dir(store).absolute();
        progress.echo("Presentation in " + root_dir, progress.echo$default$2());
        package$.MODULE$.using(Export$.MODULE$.open_database_context(store, server), (Function1 & Serializable)database_context -> {
            Browser_Info.Context context0 = this.context(deps.sessions_structure(), this.context$default$2(), root_dir, this.context$default$4());
            List sessions1 = deps.sessions_structure().build_requirements(sessions).filter((Function1 & Serializable)session_name -> BoxesRunTime.unboxToBoolean(package$.MODULE$.using(database_context.open_database((String)session_name, database_context.open_database$default$2()), (Function1 & Serializable)session_database -> {
                Option<Store.Build_Info> option = store.read_build(session_database.db(), (String)session_name);
                if (None$.MODULE$.equals(option)) {
                    return false;
                }
                if (option instanceof Some) {
                    Store.Build_Info build = (Store.Build_Info)((Some)option).value();
                    Path session_dir = context0.session_dir((String)session_name);
                    return !Browser_Info$Meta_Info$.MODULE$.check_build_uuid(session_dir, build.uuid());
                }
                throw new MatchError(option);
            })));
            Document_Info document_Info = Document_Info$.MODULE$.read((Export.Database_Context)database_context, deps, (List<String>)sessions1);
            Browser_Info.Elements elements = this.context$default$2();
            Browser_Info.Context context1 = this.context(deps.sessions_structure(), elements, root_dir, document_Info);
            context1.update_root();
            return Par_List$.MODULE$.map((JProcedure1 & Serializable)session -> package$.MODULE$.using(database_context.open_session(deps.background((String)session), database_context.open_session$default$2(), database_context.open_session$default$3()), (JProcedure1 & Serializable)session_context -> MODULE$.build_session(context1, (Export.Session_Context)session_context, progress)), sessions1, Par_List$.MODULE$.map$default$3(), Par_List$.MODULE$.map$default$4());
        });
    }

    public Progress build$default$5() {
        return new Progress();
    }

    public SSH.Server build$default$6() {
        return SSH$.MODULE$.no_server();
    }

    public static final /* synthetic */ String isabelle$Browser_Info$Meta_Info$$$_$set_build_uuid$$anonfun$1(String uuid$1, String _$1) {
        return uuid$1;
    }

    public static final String isabelle$Browser_Info$Meta_Info$Item$$$_$_$$anonfun$3() {
        return "";
    }

    public static final /* synthetic */ boolean isabelle$Browser_Info$Meta_Info$Index$$_$$plus$$anonfun$1(Browser_Info.Meta_Info.Item item$1, Browser_Info.Meta_Info.Item _$2) {
        String string = _$2.name();
        String string2 = item$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String isabelle$Browser_Info$Meta_Info$Index$$_$$plus$$anonfun$2(Browser_Info.Meta_Info.Item _$3) {
        return _$3.name();
    }

    public static final /* synthetic */ Object isabelle$Browser_Info$Meta_Info$Index$$_$json$$anonfun$1(Browser_Info.Meta_Info.Item _$4) {
        return _$4.json();
    }

    public static final /* synthetic */ Option isabelle$Browser_Info$Meta_Info$Index$$$_$_$$anonfun$6(Object x) {
        return Some$.MODULE$.apply((Object)Browser_Info$Meta_Info$Item$.MODULE$.parse(x));
    }

    public static final Path isabelle$Browser_Info$Context$$_$theory_html$$anonfun$2(Document_Info.Theory theory$2) {
        return (Path)package$.MODULE$.error().apply((Object)("Illegal global theory name " + package$.MODULE$.quote().apply((Object)theory$2.name()) + " (conflict with " + Path$.MODULE$.index_html() + ")"));
    }

    public static final Object isabelle$Browser_Info$Context$$_$preview_document$$anonfun$1() {
        return "document snapshot outdated";
    }

    public static final /* synthetic */ Tuple2 isabelle$Browser_Info$Context$$_$update_chapter$$anonfun$1$$anonfun$1(Browser_Info.Meta_Info.Item item) {
        Nil$ nil$;
        Object object = new .colon.colon((Object)HTML$.MODULE$.link(item.name() + "/index.html", HTML$.MODULE$.text(item.name())), (List)Nil$.MODULE$);
        if (item.description().isEmpty()) {
            nil$ = scala.package$.MODULE$.Nil();
        } else {
            List<XML.Tree> list = HTML$.MODULE$.break();
            nil$ = ((List)new .colon.colon((Object)HTML$.MODULE$.pre().apply(HTML$.MODULE$.text(item.description())), (List)Nil$.MODULE$)).$colon$colon$colon(list);
        }
        return Tuple2$.MODULE$.apply(object, (Object)nil$);
    }

    public static final /* synthetic */ Browser_Info.Meta_Info.Item isabelle$Browser_Info$Context$$_$_$_$$anonfun$8(Sessions.Chapter_Info ch) {
        return Browser_Info$Meta_Info$Item$.MODULE$.apply(ch.name(), ch.description());
    }

    public static final /* synthetic */ boolean isabelle$Browser_Info$Context$$_$_$_$$anonfun$9(List items1$1, Browser_Info.Meta_Info.Item item) {
        return items1$1.exists((Function1 & Serializable)_$5 -> {
            String string = _$5.name();
            String string2 = item.name();
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public static final /* synthetic */ Tuple2 isabelle$Browser_Info$Context$$_$update_root$$anonfun$1$$anonfun$1(Browser_Info.Meta_Info.Item item) {
        Nil$ nil$;
        Object object = new .colon.colon((Object)HTML$.MODULE$.link(item.name() + "/index.html", HTML$.MODULE$.text(item.name())), (List)Nil$.MODULE$);
        if (item.description().isEmpty()) {
            nil$ = scala.package$.MODULE$.Nil();
        } else {
            List<XML.Tree> list = HTML$.MODULE$.break();
            nil$ = ((List)new .colon.colon((Object)HTML$.MODULE$.pre().apply(HTML$.MODULE$.text(item.description())), (List)Nil$.MODULE$)).$colon$colon$colon(list);
        }
        return Tuple2$.MODULE$.apply(object, (Object)nil$);
    }

    public static final /* synthetic */ XML.Elem isabelle$Browser_Info$Node_Context$$anon$4$$_$make_def$$anonfun$1$$anonfun$1(XML.Elem x$1, Export_Theory.Entity x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)x$2);
        if (tuple2 != null) {
            XML.Elem elem = (XML.Elem)tuple2._1();
            Export_Theory.Entity entity = (Export_Theory.Entity)tuple2._2();
            return HTML$.MODULE$.entity_def().apply(HTML$.MODULE$.span().apply(HTML$.MODULE$.id(entity.kname()), (List<XML.Tree>)((List)new .colon.colon((Object)elem, (List)Nil$.MODULE$))));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final Option isabelle$Browser_Info$Node_Context$$anon$4$$_$logical_ref$1(String def_file$1, String kind$3, String name$2, Document_Info.Theory theory) {
        return theory.get_def(def_file$1, kind$3, name$2).map((Function1 & Serializable)_$6 -> _$6.kname());
    }

    private final Nothing$ err$3(String theory_name$2) {
        return (Nothing$)package$.MODULE$.error().apply((Object)("Missing document information for theory: " + package$.MODULE$.quote().apply((Object)theory_name$2)));
    }

    private final Document.Snapshot $anonfun$13(String theory_name$6) {
        throw this.err$3(theory_name$6);
    }

    private final Document_Info.Theory $anonfun$14(String theory_name$7) {
        throw this.err$3(theory_name$7);
    }

    private final Browser_Info.Node_Context node_context$1(Browser_Info.Context context$3, String session_name$7, String theory_name$3, String file_name, Path node_dir) {
        return Browser_Info$Node_Context$.MODULE$.make(context$3, session_name$7, theory_name$3, file_name, node_dir);
    }

    private final List present_theory$1(Progress progress$4, Export.Session_Context session_context$2, Browser_Info.Context context$2, String session_name$6, Path session_dir$4, String theory_name) {
        progress$4.expose_interrupt();
        Document.Snapshot snapshot = (Document.Snapshot)Build$.MODULE$.read_theory(session_context$2.theory(theory_name, session_context$2.theory$default$2()), Build$.MODULE$.read_theory$default$2(), Build$.MODULE$.read_theory$default$3()).getOrElse(() -> this.$anonfun$13(theory_name));
        Document_Info.Theory theory = (Document_Info.Theory)context$2.theory_by_name(session_name$6, theory_name).getOrElse(() -> this.$anonfun$14(theory_name));
        progress$4.echo("Presenting theory " + package$.MODULE$.quote().apply((Object)theory_name), true);
        Browser_Info.Elements thy_elements = theory.elements(context$2.elements());
        XML.Tree thy_html = context$2.source(this.node_context$1(context$2, session_name$6, theory_name, theory.thy_file(), session_dir$4).make_html(thy_elements, snapshot.xml_markup(snapshot.xml_markup$default$1(), thy_elements.html())));
        Path master_dir = Path$.MODULE$.explode(snapshot.node_name().master_dir());
        List files = (List)((List)snapshot.node_files().tail()).map((Function1 & Serializable)blob_name -> {
            Document.Snapshot snapshot = snapshot.switch((Document.Node.Name)blob_name);
            List<XML.Tree> xml = snapshot.xml_markup(snapshot.xml_markup$default$1(), thy_elements.html());
            return Tuple2$.MODULE$.apply(blob_name, xml);
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Document.Node.Name blob_name = (Document.Node.Name)tuple2._1();
                List xml = (List)tuple2._2();
                return xml.nonEmpty();
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Document.Node.Name blob_name = (Document.Node.Name)tuple2._1();
                List xml = (List)tuple2._2();
                progress$4.expose_interrupt();
                String file = blob_name.node();
                progress$4.echo("Presenting file " + package$.MODULE$.quote().apply((Object)file), true);
                Path file_html = session_dir$4.$plus(context$2.file_html(file));
                Path file_dir = file_html.dir();
                String html_link = HTML$.MODULE$.relative_href(file_html, (Option<Path>)Some$.MODULE$.apply((Object)session_dir$4));
                XML.Tree html = context$2.source(this.node_context$1(context$2, session_name$6, theory_name, file, file_dir).make_html(thy_elements, (List<XML.Tree>)xml));
                Path path = Path$.MODULE$.explode(file);
                Path src_path = File$.MODULE$.perhaps_relative_path(master_dir, path);
                String file_title = "File " + Symbol$.MODULE$.cartouche_decoded(src_path.implode_short());
                HTML$.MODULE$.write_document(file_dir, file_html.file_name(), (List<XML.Tree>)((List)new .colon.colon((Object)HTML$.MODULE$.title().apply(file_title), (List)Nil$.MODULE$)), (List<XML.Tree>)((List)new .colon.colon((Object)context$2.head(file_title, context$2.head$default$2()), (List)new .colon.colon((Object)html, (List)Nil$.MODULE$))), (Option<Path>)Some$.MODULE$.apply((Object)context$2.root_dir()), HTML$.MODULE$.write_document$default$6(), HTML$.MODULE$.write_document$default$7(), HTML$.MODULE$.write_document$default$8());
                return (List)new .colon.colon((Object)HTML$.MODULE$.link(html_link, HTML$.MODULE$.text(file_title)), (List)Nil$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        });
        String thy_title = "Theory " + theory.print_short();
        HTML$.MODULE$.write_document(session_dir$4, context$2.theory_html(theory).implode(), (List<XML.Tree>)((List)new .colon.colon((Object)HTML$.MODULE$.title().apply(thy_title), (List)Nil$.MODULE$)), (List<XML.Tree>)((List)new .colon.colon((Object)context$2.head(thy_title, context$2.head$default$2()), (List)new .colon.colon((Object)thy_html, (List)Nil$.MODULE$))), (Option<Path>)Some$.MODULE$.apply((Object)context$2.root_dir()), HTML$.MODULE$.write_document$default$6(), HTML$.MODULE$.write_document$default$7(), HTML$.MODULE$.write_document$default$8());
        List<XML.Tree> list = HTML$.MODULE$.text(theory.print_short());
        return (List)new .colon.colon((Object)HTML$.MODULE$.link(context$2.theory_html(theory), (List<XML.Tree>)(files.isEmpty() ? scala.package$.MODULE$.Nil() : (List)new .colon.colon((Object)HTML$.MODULE$.itemize((List<List<XML.Tree>>)files), (List)Nil$.MODULE$)).$colon$colon$colon(list)), (List)Nil$.MODULE$);
    }
}

