/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash;
import isabelle.Bash$Server$;
import isabelle.Bash$Watchdog$;
import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.Component_Bash_Process$;
import isabelle.Components;
import isabelle.Components$;
import isabelle.File$;
import isabelle.Future;
import isabelle.Isabelle_System$Settings$;
import isabelle.Library$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.SSH;
import isabelle.SSH$Local$;
import isabelle.Symbol$;
import isabelle.Timing;
import isabelle.Timing$;
import isabelle.UTF8$;
import isabelle.XML$Decode$;
import isabelle.YXML$;
import isabelle.YXML$Source$;
import isabelle.package$;
import isabelle.setup.Environment;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import scala.Byte$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.java8.JFunction0;

public final class Bash$
implements Serializable {
    public static final Bash$Watchdog$ Watchdog;
    public static final Bash$Server$ Server;
    public static final Bash$ MODULE$;

    private Bash$() {
    }

    static {
        MODULE$ = new Bash$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Bash$.class);
    }

    private String bash_chr(byte c) {
        char ch;
        char c2 = ch = (char)c;
        switch (c2) {
            case '\t': {
                return "$'\\t'";
            }
            case '\n': {
                return "$'\\n'";
            }
            case '\f': {
                return "$'\\f'";
            }
            case '\r': {
                return "$'\\r'";
            }
        }
        if (Symbol$.MODULE$.is_ascii_letter(ch) || Symbol$.MODULE$.is_ascii_digit(ch) || StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString("+,-./:_"), ch)) {
            return Symbol$.MODULE$.ascii(ch);
        }
        if (c < 0) {
            return "$'\\x" + Integer.toHexString(256 + c) + "'";
        }
        if (c < 16) {
            return "$'\\x0" + Integer.toHexString(Byte$.MODULE$.byte2int(c)) + "'";
        }
        if (c < 32 || c >= 127) {
            return "$'\\x" + Integer.toHexString(Byte$.MODULE$.byte2int(c)) + "'";
        }
        return "\\" + ch;
    }

    public String string(String s) {
        if (s.isEmpty()) {
            return "\"\"";
        }
        Object object = Predef$.MODULE$.byteArrayOps(UTF8$.MODULE$.bytes(s));
        return ArrayOps$.MODULE$.iterator$extension(object).map((Function1 & Serializable)c -> Bash$.MODULE$.bash_chr(BoxesRunTime.unboxToByte((Object)c))).mkString();
    }

    public String strings(Iterable<String> ss) {
        return ss.iterator().map((Function1 & Serializable)s -> MODULE$.string((String)s)).mkString(" ");
    }

    public String exports(Seq<String> environment) {
        return environment.iterator().map((Function1 & Serializable)a -> {
            Option<String> option = Library$.MODULE$.try_unprefix("-", (String)a);
            if (None$.MODULE$.equals(option)) {
                return "export " + MODULE$.string((String)a);
            }
            if (option instanceof Some) {
                String b = (String)((Some)option).value();
                return "unset " + MODULE$.string(b);
            }
            throw new MatchError(option);
        }).mkString("", "\n", "\n");
    }

    public String context(String script, String user_home, String isabelle_identifier, Path cwd) {
        return package$.MODULE$.if_proper(Predef$.MODULE$.wrapString(user_home), (Function0<String>)((Function0 & Serializable)() -> Bash$.context$$anonfun$1(user_home))) + package$.MODULE$.if_proper(Predef$.MODULE$.wrapString(isabelle_identifier), (Function0<String>)((Function0 & Serializable)() -> Bash$.context$$anonfun$2(isabelle_identifier))) + (String)(cwd == null || cwd.is_current() ? "" : "cd " + package$.MODULE$.quote().apply((Object)cwd.implode()) + "\n") + script;
    }

    public String context$default$2() {
        return "";
    }

    public String context$default$3() {
        return "";
    }

    public Path context$default$4() {
        return Path$.MODULE$.current();
    }

    public String isabelle$Bash$$$make_description(String description) {
        return (String)((Option)package$.MODULE$.proper_string().apply((Object)description)).getOrElse(Bash$::make_description$$anonfun$1);
    }

    public String local_bash_process() {
        return File$.MODULE$.platform_path(Path$.MODULE$.variable("ISABELLE_BASH_PROCESS"));
    }

    public String local_bash() {
        if (Platform$.MODULE$.is_unix()) {
            return "bash";
        }
        return Environment.cygwin_root() + "\\bin\\bash.exe";
    }

    public String remote_bash_process(SSH.Session ssh) {
        Path path = Component_Bash_Process$.MODULE$.home();
        Path path2 = Components$.MODULE$.provide$default$2();
        Progress progress = Components$.MODULE$.provide$default$4();
        Components.Directory component = Components$.MODULE$.provide(path, path2, ssh, progress);
        Path exe = Component_Bash_Process$.MODULE$.remote_program(component);
        String string = ssh.bash_path(exe);
        String string2 = ssh.make_command$default$1();
        boolean bl = ssh.make_command$default$2();
        String string3 = ssh.make_command$default$3();
        return ssh.make_command(string2, bl, string3, true, string);
    }

    public Bash.Process process(String script, String description, SSH.System ssh, Path cwd, Map<String, String> env, boolean redirect, Function0<BoxedUnit> cleanup) {
        return new Bash.Process(script, description, ssh, cwd, env, redirect, cleanup);
    }

    public String process$default$2() {
        return "";
    }

    public SSH.System process$default$3() {
        return SSH$Local$.MODULE$;
    }

    public Path process$default$4() {
        return Path$.MODULE$.current();
    }

    public Map<String, String> process$default$5() {
        return Isabelle_System$Settings$.MODULE$.env(Isabelle_System$Settings$.MODULE$.env$default$1());
    }

    public boolean process$default$6() {
        return false;
    }

    public Function0<BoxedUnit> process$default$7() {
        return (JFunction0.mcV.sp & Serializable)() -> {};
    }

    private static final String context$$anonfun$1(String user_home$1) {
        return MODULE$.exports((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"USER_HOME=" + user_home$1}));
    }

    private static final String context$$anonfun$2(String isabelle_identifier$1) {
        return MODULE$.exports((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ISABELLE_IDENTIFIER=" + isabelle_identifier$1}));
    }

    private static final String make_description$$anonfun$1() {
        return "bash_process";
    }

    public static final /* synthetic */ boolean isabelle$Bash$Watchdog$$$_$apply$default$2$$anonfun$1(Bash.Process _$2) {
        return true;
    }

    public static final Timing isabelle$Bash$Process$$_$get_timing$$anonfun$1() {
        return Timing$.MODULE$.zero();
    }

    private static final /* synthetic */ Option local_process_alive$$anonfun$1(long p) {
        Optional optional = OptionConverters$.MODULE$.RichOptional(ProcessHandle.of(p));
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(optional).map((Function1 & Serializable)handle -> handle.isAlive());
    }

    public static /* bridge */ /* synthetic */ Option isabelle$Bash$Process$$_$local_process_alive$$anonfun$adapted$1(Object p) {
        return Bash$.local_process_alive$$anonfun$1(BoxesRunTime.unboxToLong((Object)p));
    }

    public static final boolean isabelle$Bash$Process$$_$local_process_alive$$anonfun$2() {
        return false;
    }

    public static final /* synthetic */ boolean isabelle$Bash$Process$$_$do_cleanup$$anonfun$1(File _$3) {
        return _$3.delete();
    }

    public static final /* synthetic */ boolean isabelle$Bash$Process$$_$do_cleanup$$anonfun$2(File _$4) {
        return _$4.delete();
    }

    public static final /* synthetic */ void isabelle$Bash$Process$$_$result$$anonfun$1(Future _$7) {
        _$7.cancel();
    }

    public static final /* synthetic */ void isabelle$Bash$Process$$_$result$default$2$$anonfun$1(String _$5) {
    }

    public static final /* synthetic */ void isabelle$Bash$Process$$_$result$default$3$$anonfun$1(String _$6) {
    }

    public static final /* synthetic */ boolean isabelle$Bash$Server$$_$stop$$anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Bash.Process process = (Bash.Process)tuple2._2();
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void isabelle$Bash$Server$$_$stop$$anonfun$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Bash.Process process = (Bash.Process)tuple2._2();
            process.terminate();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Bytes isabelle$Bash$Server$$_$reply$1$$anonfun$1(String s) {
        return Bytes$.MODULE$.apply(s);
    }

    public static final /* synthetic */ List isabelle$Bash$Server$$_$handle$$anonfun$1(List _$8) {
        return _$8.map((Function1 & Serializable)_$9 -> _$9.text());
    }

    public static final /* synthetic */ void isabelle$Bash$Server$$_$handle$$anonfun$2(Bash.Process _$10) {
        _$10.terminate();
    }

    public static final Bash.Process isabelle$Bash$Server$$_$handle$$anonfun$3(String cwd$2, String putenv$1, String script$1, String description$1, boolean redirect$1) {
        Path path;
        Option option = (Option)XML$Decode$.MODULE$.option(XML$Decode$.MODULE$.string()).apply(YXML$.MODULE$.parse_body(YXML$Source$.MODULE$.apply(cwd$2), YXML$.MODULE$.parse_body$default$2(), YXML$.MODULE$.parse_body$default$3()));
        if (None$.MODULE$.equals(option)) {
            path = Path$.MODULE$.current();
        } else if (option instanceof Some) {
            String s = (String)((Some)option).value();
            path = Path$.MODULE$.explode(s);
        } else {
            throw new MatchError((Object)option);
        }
        Path path2 = path;
        Map<String, String> map = Isabelle_System$Settings$.MODULE$.env((List<Tuple2<String, String>>)((List)XML$Decode$.MODULE$.list(XML$Decode$.MODULE$.pair(XML$Decode$.MODULE$.string(), XML$Decode$.MODULE$.string())).apply(YXML$.MODULE$.parse_body(YXML$Source$.MODULE$.apply(putenv$1), YXML$.MODULE$.parse_body$default$2(), YXML$.MODULE$.parse_body$default$3()))));
        SSH.System system = MODULE$.process$default$3();
        Function0<BoxedUnit> function0 = MODULE$.process$default$7();
        return MODULE$.process(script$1, description$1, system, path2, map, redirect$1, function0);
    }

    public static final /* synthetic */ scala.collection.immutable.Map isabelle$Bash$Server$$_$handle$$anonfun$4(UUID uuid$1, Bash.Process process$1, scala.collection.immutable.Map processes) {
        UUID uUID = (UUID)Predef$.MODULE$.ArrowAssoc((Object)uuid$1);
        return (scala.collection.immutable.Map)processes.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uUID, (Object)process$1));
    }

    public static final /* synthetic */ boolean isabelle$Bash$Server$$_$_$$anonfun$5(VolatileBooleanRef is_timeout$1, Bash.Process _$11) {
        is_timeout$1.elem = true;
        return true;
    }

    public static final Process_Result isabelle$Bash$Server$$_$handle$$anonfun$5$$anonfun$1(Bash.Process process$3, String input$3, Bash.Watchdog watchdog$2) {
        return process$3.result(input$3, process$3.result$default$2(), process$3.result$default$3(), watchdog$2, false);
    }

    public static final /* synthetic */ scala.collection.immutable.Map isabelle$Bash$Server$$_$handle$$anonfun$5$$anonfun$2(UUID uuid$3, scala.collection.immutable.Map provers) {
        return (scala.collection.immutable.Map)provers.$minus((Object)uuid$3);
    }
}

