/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.textarea.TextAreaMouseHandler;

public class GenericGUIUtilities {
    public static String prettifyMenuLabel(String label) {
        int index = label.indexOf(36);
        Object result = label;
        if (index != -1) {
            result = label.substring(0, index) + label.substring(index + 1);
        }
        return result;
    }

    public static void setAutoMnemonic(AbstractButton button) {
        char mnemonic;
        Object label = button.getText();
        int index = ((String)label).indexOf(36);
        if (index != -1 && ((String)label).length() - index > 1) {
            mnemonic = Character.toLowerCase(((String)label).charAt(index + 1));
            label = ((String)label).substring(0, index) + ((String)label).substring(++index);
        } else {
            mnemonic = '\u0000';
        }
        if (mnemonic != '\u0000') {
            button.setMnemonic(mnemonic);
            button.setText((String)label);
        }
    }

    public static void adjustForScreenBounds(Rectangle desired) {
        Rectangle osbounds = OperatingSystem.getScreenBounds(desired);
        if (desired.width > osbounds.width) {
            desired.width = osbounds.width;
        }
        if (desired.x < osbounds.x) {
            desired.x = osbounds.x;
        }
        if (desired.x + desired.width > osbounds.x + osbounds.width) {
            desired.x = osbounds.x + osbounds.width - desired.width;
        }
        if (desired.height > osbounds.height) {
            desired.height = osbounds.height;
        }
        if (desired.y < osbounds.y) {
            desired.y = osbounds.y;
        }
        if (desired.y + desired.height > osbounds.y + osbounds.height) {
            desired.y = osbounds.y + osbounds.height - desired.height;
        }
    }

    public static void requestFocus(final Window win, final Component comp) {
        win.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                EventQueue.invokeLater(comp::requestFocusInWindow);
                win.removeWindowFocusListener(this);
            }
        });
    }

    public static boolean isPopupTrigger(MouseEvent evt) {
        return TextAreaMouseHandler.isRightButton(evt);
    }

    public static boolean isLeftButton(MouseEvent evt) {
        return TextAreaMouseHandler.isLeftButton(evt);
    }

    @Deprecated
    public static boolean isMiddleButton(int modifiers) {
        return TextAreaMouseHandler.isMiddleButton(modifiers);
    }

    public static boolean isMiddleButton(MouseEvent evt) {
        return TextAreaMouseHandler.isMiddleButton(evt);
    }

    @Deprecated
    public static boolean isRightButton(int modifiers) {
        return TextAreaMouseHandler.isRightButton(modifiers);
    }

    public static boolean isRightButton(MouseEvent evt) {
        return TextAreaMouseHandler.isRightButton(evt);
    }

    public static Rectangle getScreenBounds() {
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (devices.length > 1) {
            for (GraphicsDevice device : devices) {
                for (GraphicsConfiguration config : device.getConfigurations()) {
                    bounds = bounds.union(config.getBounds());
                }
            }
        }
        return bounds;
    }

    public static void showPopupMenu(JPopupMenu popup, Component comp, int x, int y) {
        GenericGUIUtilities.showPopupMenu(popup, comp, x, y, true);
    }

    public static void showPopupMenu(JPopupMenu popup, Component comp, int x, int y, boolean point) {
        Component win;
        int offsetX = 0;
        int offsetY = 0;
        int extraOffset = point ? 1 : 0;
        for (win = comp; !(win instanceof Window) && win != null; win = win.getParent()) {
            offsetX += win.getX();
            offsetY += win.getY();
        }
        if (win != null) {
            Dimension size = popup.getPreferredSize();
            Rectangle screenSize = GenericGUIUtilities.getScreenBounds();
            x = x + offsetX + size.width + win.getX() > screenSize.width && x + offsetX + win.getX() >= size.width ? (point ? (x -= size.width + extraOffset) : win.getWidth() - size.width - offsetX + extraOffset) : (x += extraOffset);
            y = y + offsetY + size.height + win.getY() > screenSize.height && y + offsetY + win.getY() >= size.height ? (point ? (y -= size.height + extraOffset) : win.getHeight() - size.height - offsetY + extraOffset) : (y += extraOffset);
            popup.show(comp, x, y);
        } else {
            popup.show(comp, x + extraOffset, y + extraOffset);
        }
    }

    public static boolean isAncestorOf(Component comp1, Component comp2) {
        while (comp2 != null) {
            if (comp1 == comp2) {
                return true;
            }
            comp2 = comp2.getParent();
        }
        return false;
    }

    public static JDialog getParentDialog(Component c) {
        return (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, c);
    }

    public static void setEnabledRecursively(Container c, boolean enabled) {
        for (Component child : c.getComponents()) {
            if (child instanceof Container) {
                GenericGUIUtilities.setEnabledRecursively((Container)child, enabled);
                continue;
            }
            child.setEnabled(enabled);
        }
        c.setEnabled(enabled);
    }

    public static void setButtonContentMargin(AbstractButton button, Insets margin) {
        UIDefaults defaults = new UIDefaults();
        defaults.put("Button.contentMargins", margin);
        defaults.put("ToggleButton.contentMargins", margin);
        button.putClientProperty("Nimbus.Overrides", defaults);
    }

    public static void makeSameSize(Component ... components) {
        if (components == null) {
            return;
        }
        int width = 0;
        int height = 0;
        for (Component component : components) {
            if (component == null) continue;
            width = Math.max(width, component.getPreferredSize().width);
            height = Math.max(height, component.getPreferredSize().height);
        }
        Dimension d = new Dimension(width, height);
        for (Component component : components) {
            if (component == null) continue;
            component.setPreferredSize(d);
        }
    }

    public static Dimension defaultTableCellSize() {
        JLabel label = new JLabel("miniminiminiminiminiminiminiminiminimini");
        UIDefaults defaults = UIManager.getDefaults();
        Object font = defaults.get("Table.font");
        if (font instanceof Font) {
            label.setFont((Font)font);
        }
        return label.getPreferredSize();
    }

    public static int defaultColumnWidth() {
        return GenericGUIUtilities.defaultTableCellSize().width;
    }

    public static int defaultRowHeight() {
        return GenericGUIUtilities.defaultTableCellSize().height;
    }
}

