/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.ProgressObserver;

class PluginManagerProgress
extends JDialog
implements ProgressObserver {
    private Thread thread;
    private final JProgressBar progress;
    private final int count;
    private int done = 1;
    private int valueSoFar;
    private final Roster roster;

    PluginManagerProgress(PluginManager dialog, Roster roster) {
        super(dialog, jEdit.getProperty("plugin-manager.progress.title"), true);
        this.roster = roster;
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        this.progress = new JProgressBar();
        this.progress.setStringPainted(true);
        this.count = roster.getOperationCount();
        int maximum = 0;
        for (int i = 0; i < this.count; ++i) {
            maximum += roster.getOperation(i).getMaximum();
        }
        this.progress.setPreferredSize(new Dimension(400, 20));
        this.progress.setMaximum(maximum);
        content.add("North", this.progress);
        JButton stop = new JButton(jEdit.getProperty("plugin-manager.progress.stop"));
        stop.addActionListener(e -> {
            roster.abortWorkThreadOperations();
            this.thread.interrupt();
            this.dispose();
        });
        JPanel panel = new JPanel(new FlowLayout(1, 0, 0));
        panel.add(stop);
        content.add("Center", panel);
        this.addWindowListener(new WindowHandler());
        this.pack();
        this.setLocationRelativeTo(dialog);
        this.setVisible(true);
    }

    @Override
    public void setValue(long value) {
        SwingUtilities.invokeLater(() -> this.progress.setValue(this.valueSoFar + (int)value));
    }

    @Override
    public void setMaximum(long value) {
    }

    @Override
    public void setStatus(String status) {
        SwingUtilities.invokeLater(() -> this.progress.setString(status));
    }

    public void done() {
        try {
            if (this.done == this.count) {
                SwingUtilities.invokeAndWait(this::dispose);
            } else {
                SwingUtilities.invokeAndWait(() -> {
                    this.valueSoFar += this.roster.getOperation(this.done - 1).getMaximum();
                    this.progress.setValue(this.valueSoFar);
                    ++this.done;
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class WindowHandler
    extends WindowAdapter {
        boolean done;

        WindowHandler() {
        }

        @Override
        public void windowOpened(WindowEvent evt) {
            if (this.done) {
                return;
            }
            this.done = true;
            PluginManagerProgress.this.thread = new Thread(() -> PluginManagerProgress.this.roster.performOperationsInWorkThread(PluginManagerProgress.this), "Plugin manager thread");
            PluginManagerProgress.this.thread.start();
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            PluginManagerProgress.this.roster.abortWorkThreadOperations();
            PluginManagerProgress.this.thread.interrupt();
        }
    }
}

