/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.io.CharsetEncoding;
import org.gjt.sp.jedit.io.Encoding;
import org.gjt.sp.jedit.jEdit;

public class EncodingServer {
    private static final String serviceClass = "org.gjt.sp.jedit.io.Encoding";

    public static Encoding getEncoding(String name) {
        try {
            return new CharsetEncoding(name);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            Object namedService = ServiceManager.getService(serviceClass, name);
            if (namedService instanceof Encoding) {
                return (Encoding)namedService;
            }
            throw new UnsupportedCharsetException("No such encoding: \"" + name + "\"");
        }
    }

    public static Set<String> getAvailableNames() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(Charset.availableCharsets().keySet());
        set.addAll(Arrays.asList(ServiceManager.getServiceNames(serviceClass)));
        return set;
    }

    public static Set<String> getSelectedNames() {
        Set<String> set = EncodingServer.getAvailableNames();
        set.removeIf(name -> jEdit.getBooleanProperty("encoding.opt-out." + name, false));
        return set;
    }

    public static Reader getTextReader(InputStream in, String encoding) throws IOException {
        return EncodingServer.getEncoding(encoding).getTextReader(in);
    }

    public static Writer getTextWriter(OutputStream out, String encoding) throws IOException {
        return EncodingServer.getEncoding(encoding).getTextWriter(out);
    }

    public static boolean hasEncoding(String name) {
        try {
            if (Charset.isSupported(name)) {
                return true;
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        return Arrays.asList(ServiceManager.getServiceNames(serviceClass)).contains(name);
    }
}

