/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.LargeFileMode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.WordWrap;
import org.gjt.sp.jedit.gui.DialogChooser;
import org.gjt.sp.jedit.gui.statusbar.AbstractLabelWidget;
import org.gjt.sp.jedit.gui.statusbar.StatusBarEventType;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.util.StandardUtilities;

public class WrapWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        return new WrapWidget(view);
    }

    private static class WrapWidget
    extends AbstractLabelWidget {
        WrapWidget(View view) {
            super(view);
        }

        @Override
        protected void singleClick(MouseEvent e) {
            Buffer buffer = this.view.getBuffer();
            WordWrap currentFoldingMode = buffer.getWordWrap();
            DialogChooser.openListChooserWindow(this.label, (Object)currentFoldingMode, listSelectionEvent -> EventQueue.invokeLater(() -> {
                JList list = (JList)StandardUtilities.castUnchecked(listSelectionEvent.getSource());
                WordWrap selectedValue = (WordWrap)((Object)((Object)((Object)list.getSelectedValue())));
                buffer.setWordWrap(selectedValue);
                EditBus.send(new BufferUpdate(buffer, null, BufferUpdate.PROPERTIES_CHANGED));
            }), (Object[])WordWrap.values());
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            WordWrap wrap = buffer.getWordWrap();
            if (this.largeBufferDeactivateWrap() && wrap == WordWrap.soft) {
                wrap = WordWrap.none;
            }
            this.label.setToolTipText(jEdit.getProperty("view.status.wrap-tooltip", new String[]{jEdit.getProperty("wrap." + String.valueOf((Object)wrap))}));
            this.label.setText("Wrap: " + String.valueOf((Object)wrap));
        }

        private boolean largeBufferDeactivateWrap() {
            Buffer buffer = this.view.getBuffer();
            LargeFileMode largeFileMode = buffer.getLargeFileMode();
            return largeFileMode.isLongBufferMode();
        }

        @Override
        public boolean test(StatusBarEventType statusBarEventType) {
            return statusBarEventType == StatusBarEventType.Buffer;
        }
    }
}

