/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.event.MouseEvent;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.AbstractLabelWidget;
import org.gjt.sp.jedit.gui.statusbar.StatusBarEventType;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class MultiSelectWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        return new MultiSelectWidget(view);
    }

    private static class MultiSelectWidget
    extends AbstractLabelWidget {
        MultiSelectWidget(View view) {
            super(view);
            this.label.setToolTipText(jEdit.getProperty("view.status.multi-tooltip"));
        }

        @Override
        protected void singleClick(MouseEvent e) {
            JEditTextArea textArea = this.view.getTextArea();
            if (textArea != null) {
                textArea.toggleMultipleSelectionEnabled();
            }
        }

        @Override
        public void update() {
            JEditTextArea textArea = this.view.getTextArea();
            if (textArea != null) {
                this.label.setEnabled(textArea.isMultipleSelectionEnabled());
                this.label.setText("Multi sel: " + textArea.isMultipleSelectionEnabled());
            }
        }

        @Override
        public boolean test(StatusBarEventType statusBarEventType) {
            return statusBarEventType == StatusBarEventType.Misc;
        }
    }
}

