/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.BufferOptions;
import org.gjt.sp.jedit.gui.DialogChooser;
import org.gjt.sp.jedit.gui.statusbar.AbstractLabelWidget;
import org.gjt.sp.jedit.gui.statusbar.StatusBarEventType;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

public class ModeWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        return new ModeWidget(view);
    }

    private static class ModeWidget
    extends AbstractLabelWidget {
        ModeWidget(View view) {
            super(view);
            this.label.setToolTipText(jEdit.getProperty("view.status.mode-tooltip"));
        }

        @Override
        protected void singleClick(MouseEvent e) {
            Object[] modes = jEdit.getModes();
            Buffer buffer = this.view.getBuffer();
            Mode currentMode = buffer.getMode();
            DialogChooser.openListChooserWindow(this.label, currentMode, listSelectionEvent -> EventQueue.invokeLater(() -> {
                JList list = (JList)StandardUtilities.castUnchecked(listSelectionEvent.getSource());
                buffer.setMode((Mode)list.getSelectedValue());
            }), modes);
        }

        @Override
        protected void rightClick(MouseEvent e) {
            new BufferOptions(this.view, this.view.getBuffer());
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            if (buffer.isLoaded()) {
                this.label.setText(buffer.getMode().toString());
            }
        }

        @Override
        public boolean test(StatusBarEventType statusBarEventType) {
            return statusBarEventType == StatusBarEventType.Buffer;
        }
    }
}

