/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;

public class ToolBarManager {
    private final Container top;
    private final Container bottom;
    private final List<Entry> topToolBars = new ArrayList<Entry>();
    private final List<Entry> bottomToolBars = new ArrayList<Entry>();

    public ToolBarManager(Container top, Container bottom) {
        this.top = top;
        this.bottom = bottom;
    }

    public void addToolBar(int group, int layer, Component toolbar) {
        Entry entry = new Entry(layer, toolbar);
        if (group == 0) {
            ToolBarManager.addToolBar(this.top, this.topToolBars, entry);
        } else if (group == 1) {
            ToolBarManager.addToolBar(this.bottom, this.bottomToolBars, entry);
        } else {
            throw new InternalError("Invalid tool bar group");
        }
    }

    public void removeToolBar(Component toolbar) {
        ToolBarManager.removeToolBar(this.top, this.topToolBars, toolbar);
        ToolBarManager.removeToolBar(this.bottom, this.bottomToolBars, toolbar);
    }

    private static void addToolBar(Container group, List<Entry> toolbars, Entry entry) {
        for (int i = 0; i < toolbars.size(); ++i) {
            if (entry.layer <= toolbars.get((int)i).layer) continue;
            toolbars.add(i, entry);
            group.add(entry.toolbar, i);
            return;
        }
        toolbars.add(entry);
        group.add(entry.toolbar);
    }

    private static void removeToolBar(Container group, List<Entry> toolbars, Component toolbar) {
        for (int i = 0; i < toolbars.size(); ++i) {
            if (toolbar != toolbars.get((int)i).toolbar) continue;
            group.remove(toolbar);
            toolbars.remove(i);
            return;
        }
    }

    private static class Entry {
        int layer;
        Component toolbar;

        Entry(int layer, Component toolbar) {
            this.layer = layer;
            this.toolbar = toolbar;
        }
    }
}

