/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import org.gjt.sp.jedit.gui.HistoryModelSaver;
import org.gjt.sp.jedit.gui.MutableListModel;

public class HistoryModel
extends DefaultListModel<String>
implements MutableListModel<String> {
    private int max;
    private static int defaultMax;
    private int maxSize;
    private static int defaultMaxSize;
    private final String name;
    private static Map<String, HistoryModel> models;
    private static boolean modified;
    private static HistoryModelSaver saver;

    public HistoryModel(String name) {
        this.name = name;
        this.max = -1;
        this.maxSize = -1;
    }

    public void addItem(String text) {
        int myMax;
        int myMaxSize;
        if (text == null || text.isEmpty()) {
            return;
        }
        int index = this.indexOf(text);
        if (index == 0) {
            return;
        }
        if (index != -1) {
            this.removeElementAt(index);
        }
        int n = myMaxSize = this.maxSize == -1 ? defaultMaxSize : this.maxSize;
        if (text.length() > myMaxSize) {
            return;
        }
        int currentSize = this.getCurrentSize();
        while (currentSize + text.length() > myMaxSize) {
            currentSize -= this.getItem(this.getSize() - 1).length();
            this.removeElementAt(this.getSize() - 1);
        }
        this.insertElementAt(text, 0);
        int n2 = myMax = this.max >= 0 ? this.max : defaultMax;
        while (this.getSize() > myMax) {
            this.removeElementAt(this.getSize() - 1);
        }
    }

    @Override
    public void insertElementAt(String obj, int index) {
        modified = true;
        super.insertElementAt(obj, index);
    }

    public String getItem(int index) {
        return (String)this.elementAt(index);
    }

    @Override
    public boolean removeElement(Object obj) {
        modified = true;
        return super.removeElement(obj);
    }

    @Override
    public void removeAllElements() {
        modified = true;
        super.removeAllElements();
    }

    public String getName() {
        return this.name;
    }

    public static HistoryModel getModel(String name) {
        HistoryModel model;
        if (models == null) {
            models = Collections.synchronizedMap(new HashMap());
        }
        if ((model = models.get(name)) == null) {
            model = new HistoryModel(name);
            models.put(name, model);
        }
        return model;
    }

    public static void loadHistory() {
        if (saver != null) {
            models = saver.load(models);
        }
    }

    public static void saveHistory() {
        if (saver != null && modified && saver.save(models)) {
            modified = false;
        }
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMax() {
        return this.max;
    }

    public void setMaxSize(int max) {
        this.maxSize = max;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public static void setDefaultMax(int max) {
        defaultMax = max;
    }

    public static int getDefaultMax() {
        return defaultMax;
    }

    public static void setDefaultMaxSize(int newMax) {
        defaultMaxSize = newMax;
    }

    public static int getDefaultMaxSize() {
        return defaultMaxSize;
    }

    public static void setSaver(HistoryModelSaver saver) {
        HistoryModel.saver = saver;
    }

    private int getCurrentSize() {
        int currentSize = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            currentSize += this.getItem(i).length();
        }
        return currentSize;
    }
}

