/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.manager.BufferManager;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.TaskManager;

public class CloseDialog
extends EnhancedDialog {
    private final View view;
    private final JList<String> bufferList;
    private final DefaultListModel<String> bufferModel;
    private final JButton save;
    private final JButton discard;
    private boolean ok;
    boolean selectAllFlag;

    public CloseDialog(View view) {
        this(view, jEdit.getBufferManager().getBuffers());
    }

    public CloseDialog(View view, Collection<Buffer> buffers) {
        super(view, jEdit.getProperty("close.title"), true);
        this.view = view;
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        Box iconBox = new Box(1);
        iconBox.add(new JLabel(UIManager.getIcon("OptionPane.warningIcon")));
        iconBox.add(Box.createGlue());
        content.add("West", iconBox);
        JPanel centerPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(jEdit.getProperty("close.caption"));
        label.setBorder(new EmptyBorder(0, 0, 6, 0));
        centerPanel.add("North", label);
        this.bufferModel = new DefaultListModel();
        this.bufferList = new JList(this.bufferModel);
        this.bufferList.setVisibleRowCount(10);
        this.bufferList.addListSelectionListener(new ListHandler());
        boolean suppressNotSavedConfirmUntitled = jEdit.getBooleanProperty("suppressNotSavedConfirmUntitled");
        suppressNotSavedConfirmUntitled = suppressNotSavedConfirmUntitled || jEdit.getBooleanProperty("autosaveUntitled");
        for (Buffer buffer : buffers) {
            if (!buffer.isDirty() || buffer.isUntitled() && suppressNotSavedConfirmUntitled) continue;
            this.bufferModel.addElement(buffer.getPath());
        }
        centerPanel.add("Center", new JScrollPane(this.bufferList));
        content.add("Center", centerPanel);
        Box buttons = new Box(0);
        buttons.add(Box.createGlue());
        JButton selectAll = new JButton(jEdit.getProperty("close.selectAll"));
        buttons.add(selectAll);
        selectAll.setMnemonic(jEdit.getProperty("close.selectAll.mnemonic").charAt(0));
        selectAll.addActionListener(e -> this.selectAll());
        buttons.add(Box.createHorizontalStrut(6));
        this.save = new JButton(jEdit.getProperty("close.save"));
        buttons.add(this.save);
        this.save.setMnemonic(jEdit.getProperty("close.save.mnemonic").charAt(0));
        this.save.addActionListener(e -> this.save());
        buttons.add(Box.createHorizontalStrut(6));
        this.discard = new JButton(jEdit.getProperty("close.discard"));
        buttons.add(this.discard);
        this.discard.setMnemonic(jEdit.getProperty("close.discard.mnemonic").charAt(0));
        this.discard.addActionListener(e -> this.discard());
        buttons.add(Box.createHorizontalStrut(6));
        JButton cancel = new JButton(jEdit.getProperty("common.cancel"));
        buttons.add(cancel);
        cancel.addActionListener(e -> this.cancel());
        buttons.add(Box.createGlue());
        this.bufferList.setSelectedIndex(0);
        content.add("South", buttons);
        content.getRootPane().setDefaultButton(cancel);
        GenericGUIUtilities.requestFocus(this, this.bufferList);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    public boolean isOK() {
        return this.ok;
    }

    @Override
    public void ok() {
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    private void updateButtons() {
        int index = this.bufferList.getSelectedIndex();
        this.save.getModel().setEnabled(index != -1);
        this.discard.getModel().setEnabled(index != -1);
    }

    private void discard() {
        List<String> paths = this.bufferList.getSelectedValuesList();
        BufferManager bufferManager = jEdit.getBufferManager();
        for (String path : paths) {
            bufferManager.getBuffer(path).ifPresent(buffer -> {
                jEdit._closeBuffer(this.view, buffer);
                this.bufferModel.removeElement(path);
            });
        }
        if (this.bufferModel.getSize() == 0) {
            this.ok = true;
            this.dispose();
        } else {
            this.bufferList.setSelectedIndex(0);
            this.bufferList.requestFocus();
        }
    }

    private void save() {
        List<String> paths = this.bufferList.getSelectedValuesList();
        BufferManager bufferManager = jEdit.getBufferManager();
        for (String path : paths) {
            bufferManager.getBuffer(path).filter(buffer -> buffer.save(this.view, null, true, true)).ifPresent(buffer -> {
                TaskManager.instance.waitForIoTasks();
                if (buffer.getBooleanProperty("BufferIORequest__error")) {
                    return;
                }
                jEdit._closeBuffer(this.view, buffer);
                this.bufferModel.removeElement(path);
            });
        }
        if (this.bufferModel.getSize() == 0) {
            this.ok = true;
            this.dispose();
        } else {
            this.bufferList.setSelectedIndex(0);
            this.bufferList.requestFocus();
        }
    }

    private void selectAll() {
        try {
            this.selectAllFlag = true;
            this.bufferList.setSelectionInterval(0, this.bufferModel.getSize() - 1);
        }
        finally {
            this.selectAllFlag = false;
        }
        this.bufferList.requestFocus();
    }

    private class ListHandler
    implements ListSelectionListener {
        private ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (CloseDialog.this.selectAllFlag) {
                return;
            }
            int index = CloseDialog.this.bufferList.getSelectedIndex();
            if (index != -1) {
                String path = CloseDialog.this.bufferModel.getElementAt(index);
                jEdit.getBufferManager().getBuffer(path).ifPresentOrElse(CloseDialog.this.view::showBuffer, () -> this.removeIndex(index, path));
            }
            CloseDialog.this.updateButtons();
        }

        private void removeIndex(int index, String path) {
            Log.log(1, this, "Buffer " + path + " is already closed");
            CloseDialog.this.bufferModel.removeElementAt(index);
        }
    }
}

