/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import java.io.Serializable;
import org.gjt.sp.jedit.bsh.LHS;
import org.gjt.sp.jedit.bsh.Modifiers;
import org.gjt.sp.jedit.bsh.Primitive;
import org.gjt.sp.jedit.bsh.Types;
import org.gjt.sp.jedit.bsh.UtilEvalError;

public class Variable
implements Serializable {
    static final int DECLARATION = 0;
    static final int ASSIGNMENT = 1;
    String name;
    Class type = null;
    String typeDescriptor;
    Object value;
    Modifiers modifiers;
    LHS lhs;

    Variable(String name, Class type, LHS lhs) {
        this.name = name;
        this.lhs = lhs;
        this.type = type;
    }

    Variable(String name, Object value, Modifiers modifiers) throws UtilEvalError {
        this(name, (Class)null, value, modifiers);
    }

    Variable(String name, String typeDescriptor, Object value, Modifiers modifiers) throws UtilEvalError {
        this(name, (Class)null, value, modifiers);
        this.typeDescriptor = typeDescriptor;
    }

    Variable(String name, Class type, Object value, Modifiers modifiers) throws UtilEvalError {
        this.name = name;
        this.type = type;
        this.modifiers = modifiers;
        this.setValue(value, 0);
    }

    public void setValue(Object value, int context) throws UtilEvalError {
        if (this.hasModifier("final") && this.value != null) {
            throw new UtilEvalError("Final variable, can't re-assign.");
        }
        if (value == null) {
            value = Primitive.getDefaultValue(this.type);
        }
        if (this.lhs != null) {
            this.lhs.assign(value, false);
            return;
        }
        if (this.type != null) {
            value = Types.castObject(value, this.type, context == 0 ? 0 : 1);
        }
        this.value = value;
    }

    Object getValue() throws UtilEvalError {
        if (this.lhs != null) {
            return this.lhs.getValue();
        }
        return this.value;
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public Modifiers getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasModifier(String name) {
        return this.modifiers != null && this.modifiers.hasModifier(name);
    }

    public String toString() {
        return "Variable: " + super.toString() + " " + this.name + ", type:" + String.valueOf(this.type) + ", value:" + String.valueOf(this.value) + ", lhs = " + String.valueOf(this.lhs);
    }
}

