/*
 * Decompiled with CFR 0.152.
 */
package console.commando;

import console.commando.CommandoDialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StringList;

public class CommandoCommand
extends EditAction {
    private URL url = null;
    private String label;
    private String path;
    private String propertyPrefix;
    private static final String pattern = "([^\\\\\\./]+)\\.xml$";
    private static final Pattern p = Pattern.compile("([^\\\\\\./]+)\\.xml$");

    public boolean isUser() {
        return this.url == null;
    }

    public boolean isOverriding() {
        if (!this.isUser()) {
            return false;
        }
        String defaultCommands = jEdit.getProperty((String)"commando.default");
        StringList sl = StringList.split((String)defaultCommands, (Object)" ");
        String cmdName = this.name.replace("commando.", "");
        return sl.contains((Object)cmdName);
    }

    public static CommandoCommand create(URL url) {
        String l = CommandoCommand.shortLabel(url.getPath());
        CommandoCommand retval = new CommandoCommand(l, url.getPath());
        retval.url = url;
        return retval;
    }

    public static CommandoCommand create(String path) {
        String l = CommandoCommand.shortLabel(path);
        File f = new File(path);
        if (f.canRead()) {
            return new CommandoCommand(l, path);
        }
        throw new RuntimeException("path: " + path + " abs: " + f.getAbsolutePath());
    }

    public String getShortLabel() {
        return this.label;
    }

    static String shortLabel(String path) {
        Matcher m = p.matcher(path);
        m.find();
        String name = m.group(1);
        name = name.replace('_', ' ');
        return name;
    }

    private CommandoCommand(String shortLabel, String path) {
        super("commando." + shortLabel);
        this.label = shortLabel;
        this.path = path;
        this.propertyPrefix = this.getName() + '.';
        jEdit.setTemporaryProperty((String)(this.getName() + ".label"), (String)this.label);
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void invoke(View view) {
        new CommandoDialog(view, this.getName());
    }

    public String getCode() {
        return "new console.commando.CommandoDialog(view,\"" + this.getName() + "\");";
    }

    protected Reader openStream() throws IOException {
        if (this.url != null) {
            return new BufferedReader(new InputStreamReader(this.url.openStream()));
        }
        return new BufferedReader(new FileReader(this.path));
    }
}

