/*
 * Decompiled with CFR 0.152.
 */
package console.commando;

import console.ConsolePlugin;
import console.commando.CommandoCommand;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.jEdit;

public class CommandoButton
extends JButton
implements ActionListener {
    private boolean visible;
    private CommandoCommand command;
    private JPopupMenu contextMenu;
    private JMenuItem hide;
    private JMenuItem customize;
    private JMenuItem unCustomize;

    public CommandoButton(CommandoCommand command) {
        this.command = command;
        this.init();
    }

    void init() {
        this.setToolTipText(jEdit.getProperty((String)"console.commando.button.tooltiptext"));
        String name = this.command.getLabel();
        this.setText(name);
        this.contextMenu = new JPopupMenu();
        this.visible = jEdit.getBooleanProperty((String)("commando.visible." + name));
        this.setVisible(this.visible);
        if (!this.command.isUser()) {
            this.hide = new JMenuItem(jEdit.getProperty((String)"commando.hide"));
            this.hide.addActionListener(this);
            this.contextMenu.add(this.hide);
        }
        this.customize = new JMenuItem(jEdit.getProperty((String)"commando.customize"));
        this.customize.addActionListener(this);
        this.contextMenu.add(this.customize);
        if (this.command.isUser()) {
            this.setToolTipText(jEdit.getProperty((String)"console.commando.button.customized.tooltiptext"));
            if (this.command.isOverriding()) {
                this.unCustomize = new JMenuItem(jEdit.getProperty((String)"commando.uncustomize"));
                this.unCustomize.setToolTipText(jEdit.getProperty((String)"commando.uncustomize.tooltiptext", (Object[])new Object[]{name}));
                this.unCustomize.addActionListener(this);
                this.contextMenu.add(this.unCustomize);
            }
        }
        this.setComponentPopupMenu(this.contextMenu);
    }

    public void unCustomizeButton() {
        String userDir = ConsolePlugin.getUserCommandDirectory();
        String name = this.command.getShortLabel() + ".xml";
        File f = new File(userDir, name);
        String path = f.getPath();
        VFSFile vf = new VFSFile(path, path, path, 0, 0L, false);
        VFSFile[] vfl = new VFSFile[]{vf};
        DockableWindowManager dwm = jEdit.getActiveView().getDockableWindowManager();
        JComponent comp = dwm.getDockable("vfs.browser");
        VFSBrowser browser = (VFSBrowser)comp;
        if (browser == null) {
            dwm.showDockableWindow("vfs.browser");
            comp = dwm.getDockable("vfs.browser");
            browser = (VFSBrowser)comp;
        }
        if (browser == null) {
            return;
        }
        browser.delete(vfl);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConsolePlugin.rescanCommands();
            }
        });
    }

    public void customize() {
        String userDir = ConsolePlugin.getUserCommandDirectory();
        try {
            String name = this.command.getShortLabel() + ".xml";
            File f = new File(userDir, name);
            if (!f.exists()) {
                int bytes;
                Reader reader = this.command.openStream();
                FileWriter writer = new FileWriter(f);
                char[] buf = new char[200];
                while ((bytes = reader.read(buf)) > 0) {
                    writer.write(buf, 0, bytes);
                }
                writer.close();
                reader.close();
                ConsolePlugin.rescanCommands();
            }
            View v = jEdit.getActiveView();
            jEdit.openFile((View)v, (String)f.getAbsolutePath());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.hide) {
            this.visible = false;
            jEdit.setBooleanProperty((String)("commando.visible." + this.getText()), (boolean)this.visible);
            this.setVisible(this.visible);
        }
        if (e.getSource() == this.customize) {
            this.customize();
        }
        if (e.getSource() == this.unCustomize) {
            this.unCustomizeButton();
        }
    }
}

