/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.ErrorMatcher;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StringList;

public class ErrorListModel
extends DefaultListModel {
    ArrayList<ErrorMatcher> m_matchers;
    StringList m_default;

    public ErrorMatcher get(int i) {
        return (ErrorMatcher)super.get(i);
    }

    public static ErrorListModel load() {
        ErrorListModel retval = new ErrorListModel();
        retval.restore();
        return retval;
    }

    public void reset() {
        jEdit.setProperty((String)"console.errors.list", (String)this.m_default.join(" "));
        this.restore();
    }

    public void save() {
        StringList visible = new StringList();
        for (ErrorMatcher matcher : this.m_matchers) {
            String key = matcher.internalName();
            if (matcher.isValid()) {
                matcher.save();
            }
            visible.add((Object)key);
        }
        jEdit.setProperty((String)"console.errors.list", (String)visible.join(" "));
    }

    public void restore() {
        super.clear();
        this.m_matchers = new ArrayList();
        this.m_default = StringList.split((String)jEdit.getProperty((String)"console.errors.default", (String)""), (Object)"\\s+");
        StringList visible = StringList.split((String)jEdit.getProperty((String)"console.errors.list", (String)""), (Object)"\\s+");
        for (String key : visible) {
            ErrorMatcher m = new ErrorMatcher(key);
            this.m_matchers.add(m);
            super.addElement(m);
        }
    }

    @Override
    public void removeElementAt(int index) {
        this.m_matchers.remove(index);
        super.removeElementAt(index);
    }

    public void insertElementAt(Object obj, int index) {
        ErrorMatcher matcher = (ErrorMatcher)obj;
        this.m_matchers.add(index, matcher);
        super.insertElementAt(obj, index);
    }

    public void addElement(Object m) {
        ErrorMatcher matcher = (ErrorMatcher)m;
        this.m_matchers.add(matcher);
        super.addElement(m);
    }
}

