/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.bufferio.IoTask;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class TextAreaTransferHandler
extends TransferHandler {
    private static JEditTextArea dragSource;
    private static boolean compoundEdit;
    private static boolean sameTextArea;
    private static int insertPos;
    private static int insertOffset;

    @Override
    protected Transferable createTransferable(JComponent c) {
        Log.log(1, this, "createTransferable()");
        JEditTextArea textArea = (JEditTextArea)c;
        if (textArea.getSelectionCount() == 0) {
            return null;
        }
        dragSource = textArea;
        return new TextAreaSelection(textArea);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        boolean returnValue;
        Log.log(1, this, "Import data");
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                returnValue = this.importFile(c, t);
            } else {
                DataFlavor[] dataFlavors;
                DataFlavor uriListStringDataFlavor = null;
                for (DataFlavor dataFlavor : dataFlavors = t.getTransferDataFlavors()) {
                    if (!this.isUriList(dataFlavor)) continue;
                    uriListStringDataFlavor = dataFlavor;
                    break;
                }
                returnValue = uriListStringDataFlavor != null && t.isDataFlavorSupported(uriListStringDataFlavor) ? this.importURIList(c, t, uriListStringDataFlavor) : this.importText(c, t);
            }
        }
        catch (Exception e) {
            Log.log(9, this, e);
            returnValue = false;
        }
        GUIUtilities.getView(c).toFront();
        GUIUtilities.getView(c).requestFocus();
        c.requestFocus();
        return returnValue;
    }

    private boolean importFile(JComponent c, Transferable t) throws Exception {
        Log.log(1, this, "=> File list");
        EditPane editPane = (EditPane)GUIUtilities.getComponentParent(c, EditPane.class);
        View view = editPane.getView();
        Buffer buffer = null;
        List data = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
        boolean browsedDirectory = false;
        BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
        for (File file : data) {
            if (file.isDirectory()) {
                if (browsedDirectory) continue;
                VFSBrowser.browseDirectory(view, file.getPath());
                browsedDirectory = true;
                continue;
            }
            Buffer _buffer = jEdit.openFile(editPane, file.getPath());
            if (_buffer == null) continue;
            buffer = _buffer;
            bufferSetManager.addBuffer(editPane, buffer);
        }
        if (buffer != null) {
            editPane.setBuffer(buffer);
        }
        view.toFront();
        view.requestFocus();
        editPane.requestFocus();
        return true;
    }

    private boolean importURIList(JComponent c, Transferable t, DataFlavor uriListStringDataFlavor) throws Exception {
        String str = (String)t.getTransferData(uriListStringDataFlavor);
        Log.log(1, this, "=> URIList \"" + str + "\"");
        EditPane editPane = (EditPane)GUIUtilities.getComponentParent(c, EditPane.class);
        View view = editPane.getView();
        JEditTextArea textArea = (JEditTextArea)c;
        if (dragSource == null) {
            boolean found = false;
            String[] components = str.split("\r\n");
            boolean browsedDirectory = false;
            for (int i = 0; i < components.length; ++i) {
                String str0 = components[i];
                int len = str0.length();
                if (len > 0 && str0.charAt(len - 1) == '\u0000') {
                    str0 = str0.substring(0, len - 1);
                }
                if (str0.length() > 0) {
                    URI uri = new URI(str0);
                    if ("file".equals(uri.getScheme())) {
                        File file = new File(uri.getPath());
                        if (file.isDirectory()) {
                            if (!browsedDirectory) {
                                VFSBrowser.browseDirectory(view, file.getPath());
                                browsedDirectory = true;
                            }
                        } else {
                            AwtRunnableQueue.INSTANCE.runAfterIoTasks(new DraggedURLLoader(textArea, uri.getPath()));
                        }
                        found = true;
                        continue;
                    }
                    Log.log(1, this, "I do not know how to handle this URI " + String.valueOf(uri) + ", ignoring.");
                    continue;
                }
                if (i == components.length - 1) continue;
                Log.log(1, this, "Odd: there is an empty line in the uri list which is not the last line.");
            }
            if (found) {
                return true;
            }
        }
        return true;
    }

    private boolean importText(JComponent c, Transferable t) throws Exception {
        String str = (String)t.getTransferData(DataFlavor.stringFlavor);
        str = str.trim();
        Log.log(1, this, "=> String \"" + str + "\"");
        JEditTextArea textArea = (JEditTextArea)c;
        if (dragSource == null) {
            String[] components;
            boolean found = false;
            for (String str0 : components = str.split("\n")) {
                VFS vfs = VFSManager.getVFSForPath(str0);
                if (!(vfs instanceof FileVFS) || str.startsWith("file://")) {
                    if (str0.startsWith("file://")) {
                        str0 = str0.substring(7);
                    }
                    ThreadUtilities.runInBackground(new DraggedURLLoader(textArea, str0));
                }
                found = true;
            }
            if (found) {
                return true;
            }
        }
        if (dragSource != null && textArea.getBuffer() == dragSource.getBuffer()) {
            compoundEdit = true;
            textArea.getBuffer().beginCompoundEdit();
        }
        sameTextArea = textArea == dragSource;
        int caret = textArea.getCaretPosition();
        Selection s = textArea.getSelectionAtOffset(caret);
        if (s != null) {
            if (sameTextArea) {
                return false;
            }
            int startPos = s.start;
            textArea.setSelectedText(s, str);
            textArea.setSelection(new Selection.Range(startPos, startPos + str.length()));
        } else if (sameTextArea) {
            Selection[] selections;
            insertPos = caret;
            insertOffset = 0;
            for (Selection selection : selections = textArea.getSelection()) {
                if (selection.end >= insertPos + insertOffset) continue;
                insertOffset -= selection.end - selection.start;
            }
        } else {
            textArea.getBuffer().insert(caret, str);
            textArea.setSelection(new Selection.Range(caret, caret + str.length()));
        }
        textArea.scrollToCaret(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportDone(JComponent c, Transferable t, int action) {
        Log.log(1, this, "Export done");
        JEditTextArea textArea = (JEditTextArea)c;
        try {
            if (action == 0) {
                Log.log(1, this, "Export impossible");
                return;
            }
            if (t == null) {
                Log.log(1, this, "=> Null transferrable");
                textArea.selectNone();
            } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                Log.log(1, this, "=> String");
                if (sameTextArea) {
                    if (action == 2) {
                        textArea.setSelectedText(null, false);
                        insertPos += insertOffset;
                    }
                    try {
                        String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                        textArea.getBuffer().insert(insertPos, str);
                        textArea.setSelection(new Selection.Range(insertPos, insertPos + str.length()));
                    }
                    catch (Exception e) {
                        Log.log(1, this, "exportDone in sameTextArea");
                        Log.log(1, this, e);
                    }
                } else if (action == 2) {
                    textArea.setSelectedText(null, false);
                } else {
                    textArea.selectNone();
                }
            }
        }
        finally {
            if (compoundEdit) {
                compoundEdit = false;
                textArea.getBuffer().endCompoundEdit();
            }
        }
        dragSource = null;
    }

    private boolean isUriList(DataFlavor flavor) {
        return "text".equals(flavor.getPrimaryType()) && "uri-list".equals(flavor.getSubType()) && flavor.getRepresentationClass() == String.class;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (dragSource != null) {
            return true;
        }
        support.setDropAction(1);
        return super.canImport(support);
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        JEditTextArea textArea = (JEditTextArea)c;
        boolean returnValue = false;
        for (DataFlavor flavor : flavors) {
            if (flavor.equals(DataFlavor.javaFileListFlavor) || this.isUriList(flavor)) {
                returnValue = true;
                break;
            }
            if (!flavor.equals(DataFlavor.stringFlavor) || !textArea.isEditable()) continue;
            returnValue = true;
            break;
        }
        Log.log(1, this, "canImport() returning " + returnValue);
        return returnValue;
    }

    private static class TextAreaSelection
    extends StringSelection {
        final JEditTextArea textArea;

        TextAreaSelection(JEditTextArea textArea) {
            super(textArea.getSelectedText());
            this.textArea = textArea;
        }
    }

    private static class DraggedURLLoader
    extends IoTask {
        private final JEditTextArea textArea;
        private final String url;

        DraggedURLLoader(JEditTextArea textArea, String url) {
            this.textArea = textArea;
            this.url = url;
        }

        @Override
        public void _run() {
            EditPane editPane = EditPane.get(this.textArea);
            jEdit.openFile(editPane, this.url);
        }
    }
}

