/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Graphics;
import java.awt.Graphics2D;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public interface StructureMatcher {
    public Match getMatch(TextArea var1);

    public void selectMatch(TextArea var1);

    public static class Highlight
    extends TextAreaExtension {
        private final TextArea textArea;

        Highlight(TextArea textArea) {
            this.textArea = textArea;
        }

        @Override
        public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
            if (!this.textArea.getPainter().isStructureHighlightEnabled()) {
                return;
            }
            Match match = this.textArea.getStructureMatch();
            if (match != null) {
                this.paintHighlight(gfx, screenLine, start, end, y, match);
            }
        }

        private int[] getOffsets(int screenLine, Match match) {
            int matchStartLine = this.textArea.getScreenLineOfOffset(match.start);
            int matchEndLine = this.textArea.getScreenLineOfOffset(match.end);
            int x1 = matchStartLine == screenLine ? match.start : this.textArea.getScreenLineStartOffset(screenLine);
            int x2 = matchEndLine == screenLine ? match.end : this.textArea.getScreenLineEndOffset(screenLine) - 1;
            return new int[]{this.textArea.offsetToXY((int)x1).x, this.textArea.offsetToXY((int)x2).x};
        }

        private void paintHighlight(Graphics gfx, int screenLine, int start, int end, int y, Match match) {
            if (!this.textArea.isStructureHighlightVisible()) {
                return;
            }
            if (match.start >= end || match.end < start) {
                return;
            }
            int matchStartLine = this.textArea.getScreenLineOfOffset(match.start);
            int matchEndLine = this.textArea.getScreenLineOfOffset(match.end);
            int height = Math.min(this.textArea.getPainter().getLineHeight(), this.textArea.getPainter().getFontHeight());
            int[] offsets = this.getOffsets(screenLine, match);
            int x1 = offsets[0];
            int x2 = offsets[1];
            gfx.setColor(this.textArea.getPainter().getStructureHighlightColor());
            gfx.drawLine(x1, y += Math.max(this.textArea.getPainter().getLineExtraSpacing(), 0), x1, y + height - 1);
            gfx.drawLine(x2, y, x2, y + height - 1);
            if (matchStartLine == screenLine || screenLine == 0) {
                gfx.drawLine(x1, y, x2, y);
            } else {
                offsets = this.getOffsets(screenLine - 1, match);
                int prevX1 = offsets[0];
                int prevX2 = offsets[1];
                gfx.drawLine(Math.min(x1, prevX1), y, Math.max(x1, prevX1), y);
                gfx.drawLine(Math.min(x2, prevX2), y, Math.max(x2, prevX2), y);
            }
            if (matchEndLine == screenLine) {
                gfx.drawLine(x1, y + height - 1, x2, y + height - 1);
            }
        }
    }

    public static class Match {
        public StructureMatcher matcher;
        public int startLine;
        public int start;
        public int endLine;
        public int end;

        public Match() {
        }

        public Match(StructureMatcher matcher) {
            this.matcher = matcher;
        }

        public Match(StructureMatcher matcher, int startLine, int start, int endLine, int end) {
            this(matcher);
            this.startLine = startLine;
            this.start = start;
            this.endLine = endLine;
            this.end = end;
        }
    }

    public static class BracketMatcher
    implements StructureMatcher {
        @Override
        public Match getMatch(TextArea textArea) {
            int bracketOffset;
            int offset = textArea.getCaretPosition() - textArea.getLineStartOffset(textArea.getCaretLine());
            if (offset != 0 && (bracketOffset = TextUtilities.findMatchingBracket(textArea.getBuffer(), textArea.getCaretLine(), offset - 1)) != -1) {
                int bracketLine = textArea.getLineOfOffset(bracketOffset);
                return new Match(this, bracketLine, bracketOffset, bracketLine, bracketOffset + 1);
            }
            return null;
        }

        @Override
        public void selectMatch(TextArea textArea) {
            textArea.selectToMatchingBracket();
        }
    }
}

