/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JList;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.LineSepListCellRenderer;
import org.gjt.sp.jedit.gui.statusbar.AbstractLabelWidget;
import org.gjt.sp.jedit.gui.statusbar.StatusBarEventType;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.jedit.misc.LineSepType;

public class LineSepWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        return new LineSepWidget(view);
    }

    private static class LineSepWidget
    extends AbstractLabelWidget {
        LineSepWidget(View view) {
            super(view);
            this.label.setToolTipText(jEdit.getProperty("view.status.linesep-tooltip"));
        }

        @Override
        protected void singleClick(MouseEvent e) {
            EventQueue.invokeLater(() -> {
                JList<LineSepType> lineSeparatorList = new JList<LineSepType>(new LineSepType[]{LineSepType.LF, LineSepType.CRLF, LineSepType.CR});
                lineSeparatorList.setSelectionMode(0);
                lineSeparatorList.setCellRenderer(new LineSepListCellRenderer());
                Buffer buffer = this.view.getBuffer();
                String property = buffer.getStringProperty("lineSeparator");
                LineSepType currentSeparator = LineSepType.fromSeparator(property);
                lineSeparatorList.setSelectedValue((Object)currentSeparator, true);
                lineSeparatorList.setBorder(BorderFactory.createEtchedBorder());
                lineSeparatorList.setVisibleRowCount(3);
                final JDialog window = new JDialog(this.view);
                window.setUndecorated(true);
                window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                        window.dispose();
                    }
                });
                lineSeparatorList.addListSelectionListener(e1 -> {
                    if (!e1.getValueIsAdjusting()) {
                        LineSepType selectedValue = (LineSepType)((Object)((Object)((Object)lineSeparatorList.getSelectedValue())));
                        if (selectedValue != null) {
                            buffer.setLineSeparator(selectedValue.getSeparator());
                        }
                        window.dispose();
                    }
                });
                window.getContentPane().add(lineSeparatorList);
                window.pack();
                window.setLocationRelativeTo(this.label);
                window.setLocation(window.getX(), window.getY() - 20);
                window.setVisible(true);
                EventQueue.invokeLater(lineSeparatorList::requestFocus);
            });
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            String lineSep = buffer.getStringProperty("lineSeparator");
            LineSepType lineSepType = LineSepType.fromSeparator(lineSep);
            this.label.setText(lineSepType.name());
        }

        @Override
        public boolean test(StatusBarEventType statusBarEventType) {
            return statusBarEventType == StatusBarEventType.Buffer;
        }
    }
}

