/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class RolloverToggleButton
extends JToggleButton {
    private final Border originalBorder;
    private final Border rolloverBorder;
    private static final AlphaComposite c = AlphaComposite.getInstance(3, 0.5f);
    private boolean revalidateBlocked;

    public RolloverToggleButton() {
        this.setBorderPainted(true);
        Color originalColor = UIManager.getColor("Button.darkShadow");
        Color rolloverColor = UIManager.getColor("Button.foreground");
        this.originalBorder = BorderFactory.createLineBorder(originalColor, 1);
        this.rolloverBorder = BorderFactory.createLineBorder(rolloverColor, 1);
        this.setBorder(this.originalBorder);
        this.setContentAreaFilled(false);
        this.addMouseListener(new MouseOverHandler());
    }

    public RolloverToggleButton(Icon icon) {
        this();
        this.setIcon(icon);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(this.originalBorder);
        this.setRequestFocusEnabled(false);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setBorderPainted(true);
        this.repaint();
    }

    @Override
    public void setBorderPainted(boolean b) {
        try {
            this.revalidateBlocked = true;
            super.setBorderPainted(b);
            this.setContentAreaFilled(false);
        }
        finally {
            this.revalidateBlocked = false;
        }
    }

    @Override
    public void revalidate() {
        if (!this.revalidateBlocked) {
            super.revalidate();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.isEnabled()) {
            super.paint(g);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(c);
            super.paint(g2);
        }
    }

    class MouseOverHandler
    extends MouseAdapter {
        MouseOverHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            RolloverToggleButton.this.setBorder(RolloverToggleButton.this.rolloverBorder);
            RolloverToggleButton.this.setContentAreaFilled(false);
            RolloverToggleButton.this.setBorderPainted(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RolloverToggleButton.this.setBorder(RolloverToggleButton.this.originalBorder);
            RolloverToggleButton.this.setContentAreaFilled(false);
            RolloverToggleButton.this.setBorderPainted(true);
        }
    }
}

