/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;

public class ExtendedGridLayoutConstraints {
    public static final int REMAINDER = Integer.MAX_VALUE;
    private int row;
    private int col;
    private int colspan;
    private int effectiveColspan;
    private int rowspan;
    private int effectiveRowspan;
    private boolean placeholder;
    private ExtendedGridLayoutConstraints mainConstraints;
    private Component component;

    public ExtendedGridLayoutConstraints(Component component) {
        this(0, 0, 1, 1, component, false, null);
    }

    public ExtendedGridLayoutConstraints(int row, Component component) {
        this(row, 0, 1, 1, component, false, null);
    }

    public ExtendedGridLayoutConstraints(int row, int colspan, int rowspan, Component component) {
        this(row, 0, colspan, rowspan, component, false, null);
    }

    private ExtendedGridLayoutConstraints(int row, int col, int colspan, int rowspan, Component component, boolean placeholder, ExtendedGridLayoutConstraints mainConstraints) {
        if (row < 0) {
            throw new IllegalArgumentException("row must be non-negative (" + row + ")");
        }
        if (col < 0) {
            throw new IllegalArgumentException("col must be non-negative (" + col + ")");
        }
        if (colspan < 1) {
            throw new IllegalArgumentException("colspan must be at least 1 (" + colspan + ")");
        }
        if (rowspan < 1) {
            throw new IllegalArgumentException("rowspan must be at least 1 (" + rowspan + ")");
        }
        this.row = row;
        this.col = col;
        this.colspan = colspan;
        this.effectiveColspan = 1;
        this.rowspan = rowspan;
        this.effectiveRowspan = 1;
        this.component = component;
        this.placeholder = placeholder;
        this.mainConstraints = mainConstraints;
    }

    ExtendedGridLayoutConstraints getColspanPlaceholder(boolean forUsage) {
        if (1 == this.colspan) {
            return null;
        }
        ExtendedGridLayoutConstraints result = new ExtendedGridLayoutConstraints(this.row, this.col + 1, this.colspan == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.colspan - 1, this.rowspan, this.component, true, null == this.mainConstraints ? this : this.mainConstraints);
        if (forUsage && result.mainConstraints.row == this.row) {
            ++result.mainConstraints.effectiveColspan;
        }
        return result;
    }

    ExtendedGridLayoutConstraints getRowspanPlaceholder(boolean forUsage) {
        if (1 == this.rowspan) {
            return null;
        }
        ExtendedGridLayoutConstraints result = new ExtendedGridLayoutConstraints(this.row + 1, this.col, this.colspan, this.rowspan == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.rowspan - 1, this.component, true, null == this.mainConstraints ? this : this.mainConstraints);
        if (forUsage && result.mainConstraints.col == this.col) {
            ++result.mainConstraints.effectiveRowspan;
        }
        return result;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    void setCol(int col) {
        if (col < 0) {
            throw new IllegalArgumentException("col must be non-negative (" + col + ")");
        }
        this.col = col;
    }

    public int getColspan() {
        return this.colspan;
    }

    int getEffectiveColspan() {
        return null == this.mainConstraints ? this.effectiveColspan : this.mainConstraints.effectiveColspan;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    int getEffectiveRowspan() {
        return null == this.mainConstraints ? this.effectiveRowspan : this.mainConstraints.effectiveRowspan;
    }

    Component getComponent() {
        return this.component;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    ExtendedGridLayoutConstraints getWorkCopy() {
        return new ExtendedGridLayoutConstraints(this.row, this.col, this.colspan, this.rowspan, this.component, this.placeholder, null == this.mainConstraints ? null : this.mainConstraints.getWorkCopy());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExtendedGridLayoutConstraints)) {
            return false;
        }
        if (this.component == null) {
            return ((ExtendedGridLayoutConstraints)o).component == null;
        }
        return this.component.equals(((ExtendedGridLayoutConstraints)o).component);
    }

    public int hashCode() {
        if (null == this.component) {
            return 0;
        }
        return this.component.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "[row=" + this.row + ",col=" + this.col + ",colspan=" + this.colspan + ",effectiveColspan=" + this.effectiveColspan + ",rowspan=" + this.rowspan + ",effectiveRowspan=" + this.effectiveRowspan + ",placeholder=" + this.placeholder + ",component=" + String.valueOf(this.component) + ",mainConstraints=" + String.valueOf(this.mainConstraints) + "]";
    }
}

