/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;

public class DialogChooser {
    public static int openChooserWindow(JFrame parent, String ... choices) {
        JDialog dialog = new JDialog(parent);
        JPanel panel = new JPanel(new FlowLayout(1));
        AtomicInteger atomicInteger = new AtomicInteger(-1);
        int i = 0;
        while (i < choices.length) {
            String choice = choices[i];
            JButton comp = new JButton(choice);
            int finalI = i++;
            comp.addActionListener(e -> {
                atomicInteger.set(finalI);
                dialog.dispose();
            });
            panel.add(comp);
        }
        dialog.setUndecorated(true);
        dialog.setModal(true);
        dialog.setContentPane(panel);
        dialog.setLocationRelativeTo(panel);
        dialog.pack();
        dialog.setVisible(true);
        return atomicInteger.get();
    }

    public static void openListChooserWindow(JComponent parent, Object initialValue, ListSelectionListener listSelectionListener, Object[] choices) {
        JList<Object> list = new JList<Object>(choices);
        list.setVisibleRowCount(Math.min(30, choices.length));
        list.setLayoutOrientation(1);
        list.setSelectionMode(0);
        list.setSelectedValue(initialValue, true);
        list.setBorder(BorderFactory.createEtchedBorder());
        final JDialog window = new JDialog((Frame)SwingUtilities.getRoot(parent));
        window.setUndecorated(true);
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                window.dispose();
            }
        });
        list.addListSelectionListener(e1 -> {
            if (!e1.getValueIsAdjusting()) {
                Object selectedValue = list.getSelectedValue();
                if (selectedValue != null && !Objects.equals(selectedValue, initialValue)) {
                    listSelectionListener.valueChanged(e1);
                }
                window.dispose();
            }
        });
        window.getContentPane().add(new JScrollPane(list));
        window.pack();
        window.setLocationRelativeTo(parent);
        window.setLocation(window.getX(), window.getY() - 60);
        window.setVisible(true);
        list.ensureIndexIsVisible(list.getSelectedIndex());
        EventQueue.invokeLater(list::requestFocus);
    }
}

