/*
 * Decompiled with CFR 0.152.
 */
package isabelle.vscode;

import isabelle.Command;
import isabelle.Document;
import isabelle.Editor;
import isabelle.Line;
import isabelle.Pretty$;
import isabelle.Query_Operation;
import isabelle.Query_Operation$Status$;
import isabelle.XML$;
import isabelle.vscode.LSP$Sledgehammer_Insert$;
import isabelle.vscode.LSP$Sledgehammer_Output$;
import isabelle.vscode.LSP$Sledgehammer_Provers_Response$;
import isabelle.vscode.LSP$Sledgehammer_Status$;
import isabelle.vscode.Language_Server;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;

public class VSCode_Sledgehammer {
    private final Language_Server server;
    private final Query_Operation query_operation;

    public VSCode_Sledgehammer(Language_Server server) {
        this.server = server;
        this.query_operation = new Query_Operation(server.editor(), BoxedUnit.UNIT, "sledgehammer", (Function1<Query_Operation.Status, BoxedUnit>)(JProcedure1 & Serializable)status -> this.consume_status((Query_Operation.Status)status), (Function1<Editor.Output, BoxedUnit>)(JProcedure1 & Serializable)output -> this.consume_output((Editor.Output)output));
    }

    private void consume_status(Query_Operation.Status status) {
        String string;
        Query_Operation.Status status2 = status;
        Query_Operation.Status status3 = Query_Operation$Status$.waiting;
        Query_Operation.Status status4 = status2;
        if (!(status3 != null ? !status3.equals(status4) : status4 != null)) {
            string = "Waiting for evaluation of context ...";
        } else {
            Query_Operation.Status status5 = Query_Operation$Status$.running;
            Query_Operation.Status status6 = status2;
            if (!(status5 != null ? !status5.equals(status6) : status6 != null)) {
                string = "Sledgehammering ...";
            } else {
                Query_Operation.Status status7 = Query_Operation$Status$.finished;
                Query_Operation.Status status8 = status2;
                if (!(status7 != null ? !status7.equals(status8) : status8 != null)) {
                    string = "Finished";
                } else {
                    throw new MatchError((Object)status2);
                }
            }
        }
        String message = string;
        this.server.channel().write(LSP$Sledgehammer_Status$.MODULE$.apply(message));
    }

    private void consume_output(Editor.Output output) {
        String content = XML$.MODULE$.string_of_body(Pretty$.MODULE$.unbreakable(output.messages()));
        this.server.channel().write(LSP$Sledgehammer_Output$.MODULE$.apply(content));
    }

    public void provers() {
        this.server.channel().write(LSP$Sledgehammer_Provers_Response$.MODULE$.apply(this.server.options().string().apply("sledgehammer_provers")));
    }

    public void request(List<String> args) {
        this.server.editor().send_dispatcher((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.request$$anonfun$1(args);
            return BoxedUnit.UNIT;
        });
    }

    public void sendback(String text) {
        this.server.editor().send_dispatcher((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.sendback$$anonfun$1(text);
            return BoxedUnit.UNIT;
        });
    }

    public void cancel() {
        this.server.editor().send_dispatcher((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.cancel$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public void locate() {
        this.server.editor().send_dispatcher((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.locate$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public void init() {
        this.query_operation.activate();
    }

    public void exit() {
        this.query_operation.deactivate();
    }

    private final void request$$anonfun$1(List args$1) {
        this.query_operation.apply_query((List<String>)args$1);
    }

    private final void sendback$$anonfun$1(String text$2) {
        this.query_operation.query_command().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Document.Snapshot snapshot = (Document.Snapshot)tuple2._1();
                Command command = (Command)tuple2._2();
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Document.Snapshot snapshot = (Document.Snapshot)tuple2._1();
                Command command = (Command)tuple2._2();
                snapshot.find_command_position(command.id(), 0).foreach((Function1)(JProcedure1 & Serializable)node_pos -> {
                    Line.Node_Position node_pos1 = node_pos.advance(command.source(command.core_range()));
                    this.server.channel().write(LSP$Sledgehammer_Insert$.MODULE$.apply(node_pos1, text$2));
                });
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final void cancel$$anonfun$1() {
        this.query_operation.cancel_query();
    }

    private final void locate$$anonfun$1() {
        this.query_operation.locate_query();
    }
}

