/*
 * Decompiled with CFR 0.152.
 */
package isabelle.vscode;

import isabelle.Byte_Message$;
import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.JSON$;
import isabelle.JSON$Format$;
import isabelle.Logger;
import isabelle.Output$;
import isabelle.Progress;
import isabelle.Progress$Kind$;
import isabelle.UTF8$;
import isabelle.Value$Int$;
import isabelle.package$;
import isabelle.vscode.Channel$;
import isabelle.vscode.Channel$Error_Logger$;
import isabelle.vscode.LSP$DisplayMessage$;
import isabelle.vscode.LSP$Message$;
import isabelle.vscode.LSP$MessageType$;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public class Channel {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Channel.class.getDeclaredField("Error_Logger$lzy1"));
    private final InputStream in;
    private final OutputStream out;
    private final Logger log;
    private final boolean verbose;
    private final Regex Content_Length;
    private volatile Object Error_Logger$lzy1;

    public static Logger $lessinit$greater$default$3() {
        return Channel$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$4() {
        return Channel$.MODULE$.$lessinit$greater$default$4();
    }

    public Channel(InputStream in, OutputStream out, Logger log, boolean verbose) {
        this.in = in;
        this.out = out;
        this.log = log;
        this.verbose = verbose;
        this.Content_Length = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\s*Content-Length:\\s*(\\d+)\\s*$"));
    }

    private String read_line() {
        Option<Bytes> option = Byte_Message$.MODULE$.read_line(this.in);
        if (option instanceof Some) {
            Bytes bytes = (Bytes)((Some)option).value();
            return bytes.text();
        }
        if (None$.MODULE$.equals(option)) {
            return "";
        }
        throw new MatchError(option);
    }

    private List<String> read_header() {
        ListBuffer header = new ListBuffer();
        String line = "";
        while (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(line = this.read_line()))) {
            header.$plus$eq((Object)line);
        }
        return header.toList();
    }

    private String read_content(int n) {
        Bytes bytes = Bytes$.MODULE$.read_stream(this.in, Int$.MODULE$.int2long(n), Bytes$.MODULE$.read_stream$default$3());
        if (bytes.size() == (long)n) {
            return bytes.text();
        }
        return (String)package$.MODULE$.error().apply((Object)("Bad message content (unexpected EOF after " + bytes.size() + " of " + n + " bytes)"));
    }

    public Option<Object> read() {
        List<String> list = this.read_header();
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List<String> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return None$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            List list3;
            Option option;
            String string = (String)((.colon.colon)list).head();
            List list4 = ((.colon.colon)list).next$access$1();
            if (string != null && !(option = this.Content_Length.unapplySeq((CharSequence)string)).isEmpty() && (list3 = (List)option.get()).lengthCompare(1) == 0) {
                int n;
                int n2;
                Option<Object> option2;
                String string2 = (String)list3.apply(0);
                String s = string2;
                String string3 = s;
                if (string3 != null && !(option2 = Value$Int$.MODULE$.unapply(string3)).isEmpty() && (n2 = (n = BoxesRunTime.unboxToInt((Object)option2.get()))) >= 0) {
                    String msg = this.read_content(n2);
                    Object json = JSON$.MODULE$.parse(msg, JSON$.MODULE$.parse$default$2());
                    LSP$Message$.MODULE$.log("IN: " + n2, json, this.log, this.verbose);
                    return Some$.MODULE$.apply(json);
                }
                return (Some)package$.MODULE$.error().apply((Object)("Bad Content-Length: " + s));
            }
        }
        List<String> header = list;
        return (Option)package$.MODULE$.error().apply(package$.MODULE$.cat_lines().apply((Object)header.$colon$colon((Object)"Malformed header:")));
    }

    public void write(Object json) {
        Bytes content = JSON$Format$.MODULE$.bytes(json, JSON$Format$.MODULE$.bytes$default$2());
        long n = content.size();
        byte[] header = UTF8$.MODULE$.bytes("Content-Length: " + n + "\r\n\r\n");
        LSP$Message$.MODULE$.log("OUT: " + n, json, this.log, this.verbose);
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            this.out.write(header);
            content.write_stream(this.out);
            this.out.flush();
        }
    }

    public void display_message(int message_type, String msg, boolean show) {
        this.write(LSP$DisplayMessage$.MODULE$.apply(message_type, Output$.MODULE$.writeln_text(msg), show));
    }

    public void error_message(String msg) {
        this.display_message(LSP$MessageType$.MODULE$.Error(), msg, true);
    }

    public void warning(String msg) {
        this.display_message(LSP$MessageType$.MODULE$.Warning(), msg, true);
    }

    public void writeln(String msg) {
        this.display_message(LSP$MessageType$.MODULE$.Info(), msg, true);
    }

    public void log_error_message(String msg) {
        this.display_message(LSP$MessageType$.MODULE$.Error(), msg, false);
    }

    public void log_warning(String msg) {
        this.display_message(LSP$MessageType$.MODULE$.Warning(), msg, false);
    }

    public void log_writeln(String msg) {
        this.display_message(LSP$MessageType$.MODULE$.Info(), msg, false);
    }

    public final Channel$Error_Logger$ Error_Logger() {
        Object object = this.Error_Logger$lzy1;
        if (object instanceof Channel$Error_Logger$) {
            return (Channel$Error_Logger$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Channel$Error_Logger$)this.Error_Logger$lzyINIT1();
    }

    private Object Error_Logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Error_Logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Channel$Error_Logger$ channel$Error_Logger$ = null;
                    try {
                        channel$Error_Logger$ = new Channel$Error_Logger$(this);
                        object2 = channel$Error_Logger$ == null ? LazyVals.NullValue$.MODULE$ : channel$Error_Logger$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Error_Logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return channel$Error_Logger$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Progress progress(boolean verbose) {
        boolean progress_verbose = verbose;
        return (Progress)((Object)new Progress.Status(progress_verbose, this){
            private List _status;
            private final boolean verbose;
            private final /* synthetic */ Channel $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Progress.Status.$init$(this);
                this.verbose = progress_verbose$1;
            }

            public List _status() {
                return this._status;
            }

            public void _status_$eq(List x$1) {
                this._status = x$1;
            }

            public boolean verbose() {
                return this.verbose;
            }

            public void status_output(List msgs) {
                msgs.withFilter((Function1 & Serializable)msg -> this.do_output((Progress.Msg)msg)).foreach((Function1)(JProcedure1 & Serializable)msg -> {
                    Progress.Message message = msg.message();
                    Progress.Kind kind = message.kind();
                    Progress.Kind kind2 = Progress$Kind$.writeln;
                    Progress.Kind kind3 = kind;
                    if (!(kind2 != null ? !kind2.equals(kind3) : kind3 != null)) {
                        this.$outer.log_writeln(message.text());
                        return;
                    }
                    Progress.Kind kind4 = Progress$Kind$.warning;
                    Progress.Kind kind5 = kind;
                    if (!(kind4 != null ? !kind4.equals(kind5) : kind5 != null)) {
                        this.$outer.log_warning(message.text());
                        return;
                    }
                    Progress.Kind kind6 = Progress$Kind$.error_message;
                    Progress.Kind kind7 = kind;
                    if (!(kind6 != null ? !kind6.equals(kind7) : kind7 != null)) {
                        this.$outer.log_error_message(message.text());
                        return;
                    }
                    throw new MatchError((Object)kind);
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{status_output$$anonfun$1(isabelle.Progress$Msg ), status_output$$anonfun$2(isabelle.Progress$Msg )}, serializedLambda);
            }
        });
    }

    public boolean progress$default$1() {
        return false;
    }
}

