/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Library$;
import isabelle.Long_Name$;
import isabelle.Multi_Map;
import isabelle.Multi_Map$;
import isabelle.Path;
import isabelle.Path$Basic$;
import isabelle.Path$Parent$;
import isabelle.Path$Root$;
import isabelle.Path$Variable$;
import isabelle.Word$;
import isabelle.XML;
import isabelle.XML$Encode$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class Path$
implements Serializable {
    public static final Path$Root$ isabelle$Path$$$Root;
    public static final Path$Basic$ isabelle$Path$$$Basic;
    public static final Path$Variable$ isabelle$Path$$$Variable;
    private static final Path$Parent$ Parent;
    private static final Set<String> illegal_elem;
    private static final String illegal_char;
    private static final Path current;
    private static final Path root;
    private static final Path parent;
    private static final Path USER_HOME;
    private static final Path ISABELLE_HOME;
    private static final Path index_html;
    private static final Function1 encode;
    private static final Set<String> reserved_windows;
    public static final Path$ MODULE$;

    private Path$() {
    }

    static {
        MODULE$ = new Path$();
        illegal_elem = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "~", "~~", ".", ".."}));
        illegal_char = "/\\$:\"'<>|?*";
        current = new Path((List<Path.Elem>)scala.package$.MODULE$.Nil());
        root = new Path((List<Path.Elem>)((List)new .colon.colon((Object)Path$Root$.MODULE$.apply(""), (List)Nil$.MODULE$)));
        parent = new Path((List<Path.Elem>)((List)new .colon.colon((Object)Path$Parent$.MODULE$, (List)Nil$.MODULE$)));
        USER_HOME = MODULE$.variable("USER_HOME");
        ISABELLE_HOME = MODULE$.variable("ISABELLE_HOME");
        index_html = MODULE$.basic("index.html");
        encode = (Function1 & Serializable)path -> (List)XML$Encode$.MODULE$.string().apply((Object)path.implode());
        reserved_windows = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Path$.class);
    }

    private Nothing$ err_elem(String msg, String s) {
        return (Nothing$)package$.MODULE$.error().apply((Object)(msg + " path element " + package$.MODULE$.quote().apply((Object)s)));
    }

    private String check_elem(String s) {
        if (illegal_elem.contains((Object)s)) {
            throw this.err_elem("Illegal", s);
        }
        StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)v1 -> {
            Path$.check_elem$$anonfun$1(s, BoxesRunTime.unboxToChar((Object)v1));
            return BoxedUnit.UNIT;
        });
        return s;
    }

    private Path.Elem root_elem(String s) {
        return Path$Root$.MODULE$.apply(this.check_elem(s));
    }

    private Path.Elem basic_elem(String s) {
        return Path$Basic$.MODULE$.apply(this.check_elem(s));
    }

    private Path.Elem variable_elem(String s) {
        return Path$Variable$.MODULE$.apply(this.check_elem(s));
    }

    public List<Path.Elem> isabelle$Path$$$apply_elem(Path.Elem y, List<Path.Elem> xs) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)y, xs);
        if (tuple2 != null) {
            Path.Elem elem = (Path.Elem)tuple2._1();
            List list = (List)tuple2._2();
            if (elem instanceof Path.Root) {
                Path.Root root = Path$Root$.MODULE$.unapply((Path.Root)elem);
                String string = root._1();
                return (List)new .colon.colon((Object)y, (List)Nil$.MODULE$);
            }
            if (Path$Parent$.MODULE$.equals(elem) && list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                Path.Elem elem2 = (Path.Elem)colon2.head();
                List list2 = colon2.next$access$1();
                if (elem2 instanceof Path.Root) {
                    Path.Root root = Path$Root$.MODULE$.unapply((Path.Root)elem2);
                    String string = root._1();
                    return xs;
                }
                if (elem2 instanceof Path.Basic) {
                    Path.Basic basic = Path$Basic$.MODULE$.unapply((Path.Basic)elem2);
                    String string = basic._1();
                    List rest = list2;
                    return rest;
                }
            }
        }
        return xs.$colon$colon((Object)y);
    }

    public List<Path.Elem> isabelle$Path$$$norm_elems(List<Path.Elem> elems) {
        return (List)elems.foldRight((Object)scala.package$.MODULE$.List().empty(), (Function2 & Serializable)(y, xs) -> MODULE$.isabelle$Path$$$apply_elem((Path.Elem)y, (List<Path.Elem>)xs));
    }

    public String isabelle$Path$$$implode_elem(Path.Elem elem, boolean bl) {
        Path.Elem elem2 = elem;
        if (elem2 instanceof Path.Root) {
            Path.Root root = Path$Root$.MODULE$.unapply((Path.Root)elem2);
            String string = root._1();
            if ("".equals(string)) {
                return "";
            }
            String s = string;
            return "//" + s;
        }
        if (elem2 instanceof Path.Basic) {
            String string;
            Path.Basic basic = Path$Basic$.MODULE$.unapply((Path.Basic)elem2);
            String s = string = basic._1();
            return s;
        }
        if (elem2 instanceof Path.Variable) {
            Path.Variable variable = Path$Variable$.MODULE$.unapply((Path.Variable)elem2);
            String string = variable._1();
            if ("USER_HOME".equals(string) && bl) {
                return "~";
            }
            if ("ISABELLE_HOME".equals(string) && bl) {
                return "~~";
            }
            String s = string;
            return "$" + s;
        }
        if (Path$Parent$.MODULE$.equals(elem2)) {
            return "..";
        }
        throw new MatchError((Object)elem2);
    }

    public String isabelle$Path$$$squash_elem(Path.Elem elem) {
        Path.Elem elem2 = elem;
        if (elem2 instanceof Path.Root) {
            Path.Root root = Path$Root$.MODULE$.unapply((Path.Root)elem2);
            String string = root._1();
            if ("".equals(string)) {
                return "ROOT";
            }
            String s = string;
            return "SERVER_" + s;
        }
        if (elem2 instanceof Path.Basic) {
            String string;
            Path.Basic basic = Path$Basic$.MODULE$.unapply((Path.Basic)elem2);
            String s = string = basic._1();
            return s;
        }
        if (elem2 instanceof Path.Variable) {
            String string;
            Path.Variable variable = Path$Variable$.MODULE$.unapply((Path.Variable)elem2);
            String s = string = variable._1();
            return s;
        }
        if (Path$Parent$.MODULE$.equals(elem2)) {
            return "PARENT";
        }
        throw new MatchError((Object)elem2);
    }

    public Path current() {
        return current;
    }

    public Path root() {
        return root;
    }

    public Path named_root(String s) {
        return new Path((List<Path.Elem>)((List)new .colon.colon((Object)this.root_elem(s), (List)Nil$.MODULE$)));
    }

    public Path make(List<String> elems) {
        return new Path((List<Path.Elem>)elems.reverse().map((Function1 & Serializable)s -> MODULE$.basic_elem((String)s)));
    }

    public Path basic(String s) {
        return new Path((List<Path.Elem>)((List)new .colon.colon((Object)this.basic_elem(s), (List)Nil$.MODULE$)));
    }

    public Path variable(String s) {
        return new Path((List<Path.Elem>)((List)new .colon.colon((Object)this.variable_elem(s), (List)Nil$.MODULE$)));
    }

    public Path parent() {
        return parent;
    }

    public Path USER_HOME() {
        return USER_HOME;
    }

    public Path ISABELLE_HOME() {
        return ISABELLE_HOME;
    }

    public Path index_html() {
        return index_html;
    }

    public Path explode(String str) {
        List ss = (List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)'/'), (Object)str);
        int r = ss.takeWhile((Function1 & Serializable)_$1 -> _$1.isEmpty()).length();
        List es = (List)ss.dropWhile((Function1 & Serializable)_$2 -> _$2.isEmpty());
        Tuple2 tuple2 = r == 0 ? Tuple2$.MODULE$.apply((Object)scala.package$.MODULE$.Nil(), (Object)es) : (r == 1 ? Tuple2$.MODULE$.apply((Object)new .colon.colon((Object)Path$Root$.MODULE$.apply(""), (List)Nil$.MODULE$), (Object)es) : (es.isEmpty() ? Tuple2$.MODULE$.apply((Object)new .colon.colon((Object)Path$Root$.MODULE$.apply(""), (List)Nil$.MODULE$), (Object)scala.package$.MODULE$.Nil()) : Tuple2$.MODULE$.apply((Object)new .colon.colon((Object)this.root_elem((String)es.head()), (List)Nil$.MODULE$), es.tail())));
        List roots = (List)tuple2._1();
        List raw_elems = (List)tuple2._2();
        List elems = raw_elems.filterNot((Function1 & Serializable)s -> {
            if (s.isEmpty()) return true;
            String string = s;
            String string2 = ".";
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }).map((Function1 & Serializable)s -> this.explode_elem$1(str, (String)s));
        return new Path(this.isabelle$Path$$$norm_elems((List<Path.Elem>)roots.reverse_$colon$colon$colon(elems)));
    }

    public boolean is_wellformed(String str) {
        boolean bl;
        try {
            this.explode(str);
            bl = true;
        }
        catch (Throwable throwable) {
            Option<String> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                String string = (String)option.get();
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public boolean is_valid(String str) {
        boolean bl;
        try {
            this.explode(str).expand();
            bl = true;
        }
        catch (Throwable throwable) {
            Option<String> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                String string = (String)option.get();
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public List<Path> split(String str2) {
        return ((List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)':'), (Object)str2)).filterNot((Function1 & Serializable)_$3 -> _$3.isEmpty()).map((Function1 & Serializable)str -> MODULE$.explode((String)str));
    }

    public List<Tuple2<Path, Object>> split_permissive(String str) {
        return ((List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)':'), (Object)str)).flatMap((Function1 & Serializable)x$1 -> {
            String string = x$1;
            if ("".equals(string) || "?".equals(string)) {
                return None$.MODULE$;
            }
            String s = string;
            Option<String> option = Library$.MODULE$.try_unsuffix("?", s);
            if (None$.MODULE$.equals(option)) {
                Path path = (Path)Predef$.MODULE$.ArrowAssoc((Object)MODULE$.explode(s));
                return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path, (Object)BoxesRunTime.boxToBoolean((boolean)false)));
            }
            if (option instanceof Some) {
                String p = (String)((Some)option).value();
                Path path = (Path)Predef$.MODULE$.ArrowAssoc((Object)MODULE$.explode(p));
                return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path, (Object)BoxesRunTime.boxToBoolean((boolean)true)));
            }
            throw new MatchError(option);
        });
    }

    public List<Path> split_permissive_files(String str) {
        return (List)this.split_permissive(str).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path path = (Path)tuple2._1();
                boolean permissive = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                return true;
            }
            return false;
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path path = (Path)tuple2._1();
                boolean permissive = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                return !permissive || path.is_file();
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path path = (Path)tuple2._1();
                boolean permissive = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                return path;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Function1<Path, List<XML.Tree>> encode() {
        return encode;
    }

    public boolean is_reserved(String name) {
        return Long_Name$.MODULE$.explode(name).exists((Function1 & Serializable)a -> reserved_windows.contains((Object)Word$.MODULE$.uppercase((String)a)));
    }

    public void check_case_insensitive(List<Path> paths) {
        Multi_Map table = (Multi_Map)paths.foldLeft(Multi_Map$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Multi_Map tab = (Multi_Map)tuple2._1();
                Path path = (Path)tuple2._2();
                String name = path.expand().implode();
                return tab.insert(Word$.MODULE$.lowercase(name), name);
            }
            throw new MatchError((Object)tuple2);
        });
        List collisions = (List)table.iterator_list().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                List coll = (List)tuple2._2();
                return true;
            }
            return false;
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                List coll = (List)tuple2._2();
                return coll.length() > 1;
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                List coll = (List)tuple2._2();
                return coll;
            }
            throw new MatchError((Object)tuple2);
        }).toList().flatten(Predef$.MODULE$.$conforms());
        if (collisions.nonEmpty()) {
            package$.MODULE$.error().apply((Object)collisions.$colon$colon((Object)"Collision of file names due case-insensitivity:").mkString("\n  "));
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean eq_case_insensitive(Path path1, Path path2) {
        Path path = path1;
        Path path3 = path2;
        if (path == null) {
            if (path3 == null) return true;
        } else if (((Object)path).equals(path3)) return true;
        String string = Word$.MODULE$.lowercase(path1.expand().implode());
        String string2 = Word$.MODULE$.lowercase(path2.expand().implode());
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    private static final /* synthetic */ void check_elem$$anonfun$1(String s$1, char c) {
        if (c < ' ') {
            throw MODULE$.err_elem("Illegal control character " + c + " in", s$1);
        }
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(illegal_char), c)) {
            throw MODULE$.err_elem("Illegal character " + package$.MODULE$.quote().apply((Object)BoxesRunTime.boxToCharacter((char)c).toString()) + " in", s$1);
        }
    }

    private final Path.Elem explode_elem$1(String str$1, String s) {
        Path.Elem elem;
        try {
            String string = s;
            String string2 = "..";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                elem = Path$Parent$.MODULE$;
            } else {
                String string3 = s;
                String string4 = "~";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    elem = Path$Variable$.MODULE$.apply("USER_HOME");
                } else {
                    String string5 = s;
                    String string6 = "~~";
                    elem = !(string5 != null ? !string5.equals(string6) : string6 != null) ? Path$Variable$.MODULE$.apply("ISABELLE_HOME") : (s.startsWith("$") ? this.variable_elem(s.substring(1)) : this.basic_elem(s));
                }
            }
        }
        catch (Throwable throwable) {
            String string;
            Option<String> option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            String msg = string = (String)option.get();
            throw package$.MODULE$.cat_error((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{msg, "The error(s) above occurred in " + package$.MODULE$.quote().apply((Object)str$1)}));
        }
        return elem;
    }
}

