/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.Date;
import isabelle.File$;
import isabelle.Graph;
import isabelle.Isabelle_System$;
import isabelle.Library$;
import isabelle.Mailman$;
import isabelle.Mailman$Archive$;
import isabelle.Mailman$Message$;
import isabelle.Mailman$Message_Chunk$;
import isabelle.Mailman$Messages$;
import isabelle.Mailman$Messages$Cluster$;
import isabelle.Mailman$Messages$Node_Ordering$;
import isabelle.Output$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.Url;
import isabelle.Url$;
import isabelle.Word$;
import isabelle.package$;
import java.io.File;
import java.io.Serializable;
import java.net.URLConnection;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class Mailman {
    public static boolean is_address(String string) {
        return Mailman$.MODULE$.is_address(string);
    }

    public static List<String> standard_author_info(List<String> list) {
        return Mailman$.MODULE$.standard_author_info(list);
    }

    public static abstract class Archive {
        private final String tag;
        private final Url main_url;
        private final String main_html;
        private final String list_name;

        public static String $lessinit$greater$default$2() {
            return Mailman$Archive$.MODULE$.$lessinit$greater$default$2();
        }

        public static String $lessinit$greater$default$3() {
            return Mailman$Archive$.MODULE$.$lessinit$greater$default$3();
        }

        public Archive(Url url, String name, String tag) {
            this.tag = tag;
            this.main_url = Url$.MODULE$.apply(((IterableOnceOps)Library$.MODULE$.take_suffix((Function1 & Serializable)_$12 -> this.$init$$$anonfun$4(BoxesRunTime.unboxToChar((Object)_$12)), Predef$.MODULE$.wrapString(Url$.MODULE$.trim_index(url).toString()).toList())._1()).mkString() + "/");
            this.main_html = Url$.MODULE$.read(this.main_url);
            Option title = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("<title>The ([^</>]*) Archives</title>")).findFirstMatchIn((CharSequence)this.main_html).map((Function1 & Serializable)_$13 -> _$13.group(1));
            this.list_name = (String)((Option)package$.MODULE$.proper_string().apply((Object)name)).orElse(() -> this.$init$$$anonfun$5(title)).getOrElse(this::$init$$$anonfun$6);
        }

        public abstract Regex message_regex();

        public abstract Message message_content(String var1, List<String> var2);

        public Option<Regex.Match> message_match(List<String> lines, Regex re) {
            return lines.flatMap(arg_0 -> Mailman$.isabelle$Mailman$Archive$$_$message_match$$anonfun$1(re, arg_0)).headOption();
        }

        public String make_name(String str) {
            String s = str.trim().replaceAll("\\s+", " ").replaceAll(" at ", "@").replace("mailbroy.informatik.tu-muenchen.de", "in.tum.de").replace("informatik.tu-muenchen.de", "in.tum.de");
            if (s.startsWith("=") && s.endsWith("=")) {
                return "";
            }
            return s;
        }

        public String make_body(List<String> lines) {
            return (String)package$.MODULE$.cat_lines().apply(Library$.MODULE$.take_suffix(Mailman$::isabelle$Mailman$Archive$$_$make_body$$anonfun$1, lines)._1());
        }

        public String list_name() {
            return this.list_name;
        }

        public String toString() {
            return this.list_name();
        }

        public String full_name(String href) {
            return this.list_name() + "/" + href;
        }

        public String list_tag() {
            return (String)((Option)package$.MODULE$.proper_string().apply((Object)this.tag)).getOrElse(this::list_tag$$anonfun$1);
        }

        public String read_text(String href) {
            return Url$.MODULE$.read(this.main_url.resolve(href));
        }

        public List<String> hrefs_text() {
            return StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("href=\"([^\"]+\\.txt(?:\\.gz)?)\"")).findAllMatchIn((CharSequence)this.main_html).map(Mailman$::isabelle$Mailman$Archive$$_$hrefs_text$$anonfun$1).toList();
        }

        public List<String> hrefs_msg() {
            return StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("href=\"([^\"]+)/date.html\"")).findAllMatchIn((CharSequence)this.main_html).map(Mailman$::isabelle$Mailman$Archive$$_$hrefs_msg$$anonfun$1).map((Function1 & Serializable)href -> {
                String html = this.read_text(href + "/date.html");
                return Tuple2$.MODULE$.apply(href, (Object)html);
            }).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String href = (String)tuple2._1();
                    String html = (String)tuple2._2();
                    return this.message_regex().findAllMatchIn((CharSequence)html).map(Mailman$::isabelle$Mailman$Archive$$_$hrefs_msg$$anonfun$3$$anonfun$1).map(arg_0 -> Mailman$.isabelle$Mailman$Archive$$_$hrefs_msg$$anonfun$3$$anonfun$2(href, arg_0));
                }
                throw new MatchError((Object)tuple2);
            }).toList();
        }

        public Option<Path> get(Path target_dir, String href, Progress progress) {
            None$ none$;
            Path dir = target_dir.$plus(Path$.MODULE$.basic(this.list_name()));
            Path path = dir.$plus(Path$.MODULE$.explode(href));
            Url url = this.main_url.resolve(href);
            URLConnection connection = url.open_connection();
            try {
                long length = connection.getContentLengthLong();
                long timestamp = connection.getLastModified();
                if (path.is_file() && File$.MODULE$.size(path) == length && path.file().lastModified() == timestamp) {
                    none$ = None$.MODULE$;
                } else {
                    Isabelle_System$.MODULE$.make_directory(path.dir());
                    progress.echo("Getting " + url, progress.echo$default$2());
                    Bytes bytes = (Bytes)package$.MODULE$.using(connection.getInputStream(), arg_0 -> Mailman$.isabelle$Mailman$Archive$$_$_$$anonfun$7(length, arg_0));
                    Bytes$.MODULE$.write(path, bytes);
                    path.file().setLastModified(timestamp);
                    none$ = Some$.MODULE$.apply((Object)path);
                }
            }
            finally {
                connection.getInputStream().close();
            }
            return none$;
        }

        public Progress get$default$3() {
            return new Progress();
        }

        public List<Path> download_text(Path target_dir, Progress progress) {
            return this.hrefs_text().flatMap((Function1 & Serializable)_$18 -> this.get(target_dir, (String)_$18, progress));
        }

        public Progress download_text$default$2() {
            return new Progress();
        }

        public List<Path> download_msg(Path target_dir, Progress progress) {
            return this.hrefs_msg().flatMap((Function1 & Serializable)_$19 -> this.get(target_dir, (String)_$19, progress));
        }

        public Progress download_msg$default$2() {
            return new Progress();
        }

        public List<Path> download(Path target_dir, Progress progress) {
            List<Path> list = this.download_text(target_dir, progress);
            return this.download_msg(target_dir, progress).$colon$colon$colon(list);
        }

        public Progress download$default$2() {
            return new Progress();
        }

        public String make_title(String str) {
            Regex Trim1 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\s*\\Q[" + this.list_tag() + "]\\E\\s*(.*)"));
            Regex Trim2 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?i:(?:re|fw|fwd)\\s*:\\s*)(.*)"));
            Regex Trim3 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\[\\s*(.*?)\\s*\\]"));
            return this.trim$1(Trim1, Trim2, Trim3, str);
        }

        public List<Message> get_messages() {
            return this.hrefs_msg().map((Function1 & Serializable)href -> this.message_content((String)href, (List<String>)((List)package$.MODULE$.split_lines().apply((Object)this.read_text((String)href)))));
        }

        public List<Message> find_messages(Path dir) {
            return File$.MODULE$.find_files(dir.file(), (Function1<File, Object>)((Function1 & Serializable)Mailman$::isabelle$Mailman$Archive$$_$find_messages$$anonfun$1), File$.MODULE$.find_files$default$3(), File$.MODULE$.find_files$default$4()).flatMap((Function1 & Serializable)file -> File$.MODULE$.relative_path(dir, File$.MODULE$.path((File)file)).map((Function1 & Serializable)rel_path -> {
                String name = this.full_name(rel_path.implode());
                return this.message_content(name, (List<String>)((List)package$.MODULE$.split_lines().apply((Object)File$.MODULE$.read((File)file))));
            }));
        }

        private final /* synthetic */ boolean $init$$$anonfun$4(char _$12) {
            return _$12 == '/';
        }

        private final Option $init$$$anonfun$5(Option title$1) {
            return title$1;
        }

        private final String $init$$$anonfun$6() {
            return (String)package$.MODULE$.error().apply((Object)"Failed to determine mailing list name");
        }

        private final String list_tag$$anonfun$1() {
            return this.list_name();
        }

        private final String trim$1(Regex Trim1$1, Regex Trim2$1, Regex Trim3$1, String s) {
            String string;
            while ((string = s) != null) {
                String string2;
                String s1;
                List list;
                List list2;
                List list3;
                Option option = Trim1$1.unapplySeq((CharSequence)string);
                if (!option.isEmpty() && (list3 = (List)option.get()).lengthCompare(1) == 0) {
                    String string3;
                    String s12;
                    s = s12 = (string3 = (String)list3.apply(0));
                    continue;
                }
                Option option2 = Trim2$1.unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && (list2 = (List)option2.get()).lengthCompare(1) == 0) {
                    String string4;
                    String s13;
                    s = s13 = (string4 = (String)list2.apply(0));
                    continue;
                }
                Option option3 = Trim3$1.unapplySeq((CharSequence)string);
                if (option3.isEmpty() || (list = (List)option3.get()).lengthCompare(1) != 0) break;
                s = s1 = (string2 = (String)list.apply(0));
            }
            return s;
        }
    }

    public static class Message
    implements Product,
    Serializable {
        private final String name;
        private final Date date;
        private final String title;
        private final List author_info;
        private final String body;
        private final List tags;

        public static Message apply(String string, Date date, String string2, List<String> list, String string3, List<String> list2) {
            return Mailman$Message$.MODULE$.apply(string, date, string2, list, string3, list2);
        }

        public static Message fromProduct(Product product) {
            return Mailman$Message$.MODULE$.fromProduct(product);
        }

        public static Message unapply(Message message) {
            return Mailman$Message$.MODULE$.unapply(message);
        }

        public Message(String name, Date date, String title, List<String> author_info, String body, List<String> tags) {
            this.name = name;
            this.date = date;
            this.title = title;
            this.author_info = author_info;
            this.body = body;
            this.tags = tags;
            if (author_info.isEmpty() || author_info.exists((Function1 & Serializable)_$1 -> _$1.isEmpty())) {
                package$.MODULE$.error().apply((Object)("Bad author information in " + package$.MODULE$.quote().apply((Object)name)));
            }
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Message)) return false;
            Message message = (Message)object;
            String string = this.name();
            String string2 = message.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Date date = this.date();
            Date date2 = message.date();
            if (date == null) {
                if (date2 != null) {
                    return false;
                }
            } else if (!((Object)date).equals(date2)) return false;
            String string3 = this.title();
            String string4 = message.title();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            List<String> list = this.author_info();
            List<String> list2 = message.author_info();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            String string5 = this.body();
            String string6 = message.body();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            List<String> list3 = this.tags();
            List<String> list4 = message.tags();
            if (list3 == null) {
                if (list4 != null) {
                    return false;
                }
            } else if (!list3.equals(list4)) return false;
            if (!message.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Message;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "Message";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "date";
                }
                case 2: {
                    return "title";
                }
                case 3: {
                    return "author_info";
                }
                case 4: {
                    return "body";
                }
                case 5: {
                    return "tags";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public Date date() {
            return this.date;
        }

        public String title() {
            return this.title;
        }

        public List<String> author_info() {
            return this.author_info;
        }

        public String body() {
            return this.body;
        }

        public List<String> tags() {
            return this.tags;
        }

        public String toString() {
            return this.name();
        }

        public Message copy(String name, Date date, String title, List<String> author_info, String body, List<String> tags) {
            return new Message(name, date, title, author_info, body, tags);
        }

        public String copy$default$1() {
            return this.name();
        }

        public Date copy$default$2() {
            return this.date();
        }

        public String copy$default$3() {
            return this.title();
        }

        public List<String> copy$default$4() {
            return this.author_info();
        }

        public String copy$default$5() {
            return this.body();
        }

        public List<String> copy$default$6() {
            return this.tags();
        }

        public String _1() {
            return this.name();
        }

        public Date _2() {
            return this.date();
        }

        public String _3() {
            return this.title();
        }

        public List<String> _4() {
            return this.author_info();
        }

        public String _5() {
            return this.body();
        }

        public List<String> _6() {
            return this.tags();
        }
    }

    public static class Message_Chunk {
        private final String bg;
        private final String en;

        public static String $lessinit$greater$default$1() {
            return Mailman$Message_Chunk$.MODULE$.$lessinit$greater$default$1();
        }

        public static String $lessinit$greater$default$2() {
            return Mailman$Message_Chunk$.MODULE$.$lessinit$greater$default$2();
        }

        public Message_Chunk(String bg, String en) {
            this.bg = bg;
            this.en = en;
        }

        public Option<List<String>> unapply(List<String> lines) {
            Some some;
            if (this.bg.isEmpty()) {
                some = Some$.MODULE$.apply(lines);
            } else {
                List list = (List)lines.dropWhile((Function1 & Serializable)_$20 -> {
                    String string = _$20;
                    String string2 = this.bg;
                    return string == null ? string2 != null : !string.equals(string2);
                });
                Nil$ nil$ = scala.package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    some = None$.MODULE$;
                } else if (list instanceof .colon.colon) {
                    List list3;
                    List rest = list3 = ((.colon.colon)list).next$access$1();
                    some = Some$.MODULE$.apply((Object)rest);
                } else {
                    throw new MatchError((Object)list);
                }
            }
            Some res1 = some;
            if (this.en.isEmpty()) {
                return res1;
            }
            Some some2 = res1;
            if (None$.MODULE$.equals(some2)) {
                return None$.MODULE$;
            }
            if (some2 instanceof Some) {
                List lines2;
                List lines1 = (List)some2.value();
                if (((List)lines1.drop((lines2 = lines1.takeWhile((Function1 & Serializable)_$21 -> {
                    String string = _$21;
                    String string2 = this.en;
                    return string == null ? string2 != null : !string.equals(string2);
                })).length())).isEmpty()) {
                    return None$.MODULE$;
                }
                return Some$.MODULE$.apply((Object)lines2);
            }
            throw new MatchError((Object)some2);
        }

        public List<String> get(List<String> lines) {
            return (List)this.unapply(lines).getOrElse(this::get$$anonfun$1);
        }

        private final List get$$anonfun$1() {
            return (List)package$.MODULE$.error().apply((Object)("Missing delimiters:" + package$.MODULE$.if_proper(Predef$.MODULE$.wrapString(this.bg), (Function0<String>)((Function0 & Serializable)Mailman$::isabelle$Mailman$Message_Chunk$$_$get$$anonfun$1$$anonfun$1)) + this.bg + package$.MODULE$.if_proper(Predef$.MODULE$.wrapString(this.en), (Function0<String>)((Function0 & Serializable)Mailman$::isabelle$Mailman$Message_Chunk$$_$get$$anonfun$1$$anonfun$2)) + this.en));
        }
    }

    public static class Messages {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Messages.class.getDeclaredField("Node_Ordering$lzy1"));
        private final List sorted;
        private final Graph graph;
        private volatile Object Node_Ordering$lzy1;

        public static Messages apply(List<Message> list) {
            return Mailman$Messages$.MODULE$.apply(list);
        }

        public static Messages find(Path path) {
            return Mailman$Messages$.MODULE$.find(path);
        }

        public Messages(List<Message> sorted, Graph<String, Message> graph) {
            this.sorted = sorted;
            this.graph = graph;
        }

        public List<Message> sorted() {
            return this.sorted;
        }

        public Graph<String, Message> graph() {
            return this.graph;
        }

        public String toString() {
            return "Messages(" + this.sorted().size() + ")";
        }

        public final Mailman$Messages$Node_Ordering$ Node_Ordering() {
            Object object = this.Node_Ordering$lzy1;
            if (object instanceof Mailman$Messages$Node_Ordering$) {
                return (Mailman$Messages$Node_Ordering$)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Mailman$Messages$Node_Ordering$)this.Node_Ordering$lzyINIT1();
        }

        private Object Node_Ordering$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.Node_Ordering$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Mailman$Messages$Node_Ordering$ mailman$Messages$Node_Ordering$ = null;
                        try {
                            mailman$Messages$Node_Ordering$ = new Mailman$Messages$Node_Ordering$(this);
                            object2 = mailman$Messages$Node_Ordering$ == null ? LazyVals.NullValue$.MODULE$ : mailman$Messages$Node_Ordering$;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.Node_Ordering$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return mailman$Messages$Node_Ordering$;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public Cluster get_cluster(Message msg) {
            return Mailman$Messages$Cluster$.MODULE$.apply((List<String>)((List)((StrictOptimizedSeqOps)this.graph().all_succs(msg.author_info()).sorted((Ordering)Ordering.String$.MODULE$)).sorted((Ordering)this.Node_Ordering())));
        }

        public String get_name(Message msg) {
            return this.get_cluster(msg).name();
        }

        public String get_address(Message msg) {
            return (String)this.get_cluster(msg).get_address().getOrElse(() -> Mailman$.isabelle$Mailman$Messages$$_$get_address$$anonfun$1(msg));
        }

        public void check(boolean check_all, boolean check_multi) {
            List clusters = (List)((SeqOps)this.sorted().map((Function1 & Serializable)msg -> this.get_cluster((Message)msg)).distinct()).sortBy(Mailman$::isabelle$Mailman$Messages$$_$_$$anonfun$2, (Ordering)Ordering.String$.MODULE$);
            if (check_all) {
                Output$.MODULE$.writeln((String)package$.MODULE$.cat_lines().apply((Object)clusters.map(Mailman$::isabelle$Mailman$Messages$$_$check$$anonfun$1).$colon$colon((Object)"clusters:")), Output$.MODULE$.writeln$default$2(), Output$.MODULE$.writeln$default$3());
            } else {
                Nil$ multi;
                Object object = multi = check_multi ? clusters.filter(Mailman$::isabelle$Mailman$Messages$$_$_$$anonfun$3) : scala.package$.MODULE$.Nil();
                if (multi.nonEmpty()) {
                    Output$.MODULE$.writeln((String)package$.MODULE$.cat_lines().apply((Object)multi.map(Mailman$::isabelle$Mailman$Messages$$_$check$$anonfun$2).$colon$colon((Object)"ambiguous clusters:")), Output$.MODULE$.writeln$default$2(), Output$.MODULE$.writeln$default$3());
                }
            }
            List unknown = clusters.filter(Mailman$::isabelle$Mailman$Messages$$_$_$$anonfun$4);
            if (unknown.nonEmpty()) {
                Output$.MODULE$.writeln((String)package$.MODULE$.cat_lines().apply((Object)unknown.map(Mailman$::isabelle$Mailman$Messages$$_$check$$anonfun$3).$colon$colon((Object)"\nunknown mail:")), Output$.MODULE$.writeln$default$2(), Output$.MODULE$.writeln$default$3());
                return;
            }
        }

        public boolean check$default$2() {
            return false;
        }

        public static class Cluster
        implements Product,
        Serializable {
            private final List author_info;
            private final List addresses;
            private final List names;
            private final String name;
            private final String name_lowercase;

            public static Cluster apply(List<String> list) {
                return Mailman$Messages$Cluster$.MODULE$.apply(list);
            }

            public static Cluster fromProduct(Product product) {
                return Mailman$Messages$Cluster$.MODULE$.fromProduct(product);
            }

            public static Cluster unapply(Cluster cluster) {
                return Mailman$Messages$Cluster$.MODULE$.unapply(cluster);
            }

            public Cluster(List<String> author_info) {
                this.author_info = author_info;
                Tuple2 tuple2 = author_info.partition((Function1 & Serializable)s -> Mailman$.MODULE$.is_address((String)s));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List addresses = (List)tuple2._1();
                List names = (List)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)addresses, (Object)names);
                this.addresses = (List)tuple22._1();
                this.names = (List)tuple22._2();
                this.name = (String)this.names().headOption().getOrElse(this::$init$$$anonfun$3);
                this.name_lowercase = Word$.MODULE$.lowercase(this.name());
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Cluster)) return false;
                Cluster cluster = (Cluster)object;
                List<String> list = this.author_info();
                List<String> list2 = cluster.author_info();
                if (list == null) {
                    if (list2 != null) {
                        return false;
                    }
                } else if (!list.equals(list2)) return false;
                if (!cluster.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Cluster;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "Cluster";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "author_info";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public List<String> author_info() {
                return this.author_info;
            }

            public List<String> addresses() {
                return this.addresses;
            }

            public List<String> names() {
                return this.names;
            }

            public String name() {
                return this.name;
            }

            public String name_lowercase() {
                return this.name_lowercase;
            }

            public Option<String> get_address() {
                return this.addresses().headOption();
            }

            public boolean unique() {
                return this.names().length() == 1 && this.addresses().length() == 1;
            }

            public boolean multi() {
                return this.names().length() > 1 || this.addresses().length() > 1;
            }

            public String print() {
                Nil$ nil$ = this.addresses().isEmpty() ? scala.package$.MODULE$.Nil() : (List)new .colon.colon((Object)"", (List)Nil$.MODULE$);
                List entries = this.addresses().$colon$colon$colon((List)nil$).$colon$colon$colon(this.names());
                return entries.mkString("\n  * ", "\n    ", "");
            }

            public Cluster copy(List<String> author_info) {
                return new Cluster(author_info);
            }

            public List<String> copy$default$1() {
                return this.author_info();
            }

            public List<String> _1() {
                return this.author_info();
            }

            private final String $init$$$anonfun$3() {
                List<String> list = this.addresses();
                if (list instanceof .colon.colon) {
                    List list2 = ((.colon.colon)list).next$access$1();
                    String a = (String)((.colon.colon)list).head();
                    return a.substring(0, a.indexOf(64)).replace('.', ' ');
                }
                Nil$ nil$ = scala.package$.MODULE$.Nil();
                List<String> list3 = list;
                if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                    return (String)package$.MODULE$.error().apply((Object)"Empty cluster");
                }
                throw new MatchError(list);
            }
        }
    }
}

