/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Components;
import isabelle.Components$;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Go_Setup;
import isabelle.Go_Setup$Platform_Info$;
import isabelle.Isabelle_Platform$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$Info$;
import isabelle.Progress;
import isabelle.Scala_Project$;
import isabelle.Url$;
import isabelle.package$;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Go_Setup$
implements Serializable {
    public static final Go_Setup$Platform_Info$ Platform_Info;
    private static final List all_platforms;
    private static final String default_url;
    private static final Isabelle_Tool isabelle_tool;
    public static final Go_Setup$ MODULE$;

    private Go_Setup$() {
    }

    static {
        MODULE$ = new Go_Setup$();
        all_platforms = (List)new .colon.colon((Object)Go_Setup$Platform_Info$.MODULE$.apply("arm64-darwin", "darwin_arm64"), (List)new .colon.colon((Object)Go_Setup$Platform_Info$.MODULE$.apply("arm64-linux", "linux_arm64"), (List)new .colon.colon((Object)Go_Setup$Platform_Info$.MODULE$.apply("x86_64-darwin", "darwin_amd64"), (List)new .colon.colon((Object)Go_Setup$Platform_Info$.MODULE$.apply("x86_64-linux", "linux_amd64"), (List)new .colon.colon((Object)Go_Setup$Platform_Info$.MODULE$.apply("x86_64-windows", "windows_amd64"), (List)Nil$.MODULE$)))));
        default_url = "https://go.dev/dl";
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("go_setup", "dynamic setup of Go component", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)this.default_target_dir());
            ObjectRef base_url = ObjectRef.create((Object)this.default_url());
            ObjectRef version = ObjectRef.create((Object)this.default_version());
            BooleanRef force = BooleanRef.create((boolean)false);
            ObjectRef platforms = ObjectRef.create((Object)((List)new .colon.colon((Object)this.default_platform(), (List)Nil$.MODULE$)));
            Object[] objectArray = new Tuple2[5];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                base_url$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"V:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                version$1.elem = arg;
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"f");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)_$3 -> {
                force$1.elem = true;
            });
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"p:");
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (JProcedure1 & Serializable)arg -> {
                platforms$1.elem = ((List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)','), arg)).map((Function1 & Serializable)spec -> this.check_platform((String)spec));
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.go_setup((List<String>)((List)platforms.elem), (String)base_url.elem, (String)version.elem, (Path)target_dir.elem, progress, force.elem);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Go_Setup$.class);
    }

    public List<Go_Setup.Platform_Info> all_platforms() {
        return all_platforms;
    }

    public String check_platform(String spec) {
        return Platform$Info$.MODULE$.check(this.all_platforms(), spec);
    }

    public String default_platform() {
        return Isabelle_Platform$.MODULE$.local().ISABELLE_PLATFORM(true, true);
    }

    public Path default_target_dir() {
        return Components$.MODULE$.default_components_base();
    }

    public String default_url() {
        return default_url;
    }

    public String default_version() {
        return Isabelle_System$.MODULE$.getenv_strict("ISABELLE_GO_SETUP_VERSION", Isabelle_System$.MODULE$.getenv_strict$default$2());
    }

    public void go_setup(List<String> platforms, String base_url, String version, Path target_dir, Progress progress, boolean force) {
        platforms.foreach((Function1 & Serializable)spec -> MODULE$.check_platform((String)spec));
        Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic("go-" + version)), Components$Directory$.MODULE$.apply$default$2());
        Components.Directory component_dir = directory.create(directory.create$default$1(), true);
        progress.echo("Component directory " + component_dir, progress.echo$default$2());
        component_dir.write_settings("\nISABELLE_GOROOT=\"$COMPONENT\"\n\nif [ -n \"$ISABELLE_WINDOWS_PLATFORM64\" -a -d \"$ISABELLE_GOROOT/$ISABELLE_WINDOWS_PLATFORM64\" ]; then\n  ISABELLE_GOEXE=\"$ISABELLE_GOROOT/$ISABELLE_WINDOWS_PLATFORM64\"\nelif [ -n \"$ISABELLE_APPLE_PLATFORM64\" -a -d \"$ISABELLE_GOROOT/$ISABELLE_APPLE_PLATFORM64\" ]; then\n  ISABELLE_GOEXE=\"$ISABELLE_GOROOT/$ISABELLE_APPLE_PLATFORM64\"\nelif [ -d \"$ISABELLE_GOROOT/$ISABELLE_PLATFORM64\" ]; then\n  ISABELLE_GOEXE=\"$ISABELLE_GOROOT/$ISABELLE_PLATFORM64\"\nfi\n");
        File$.MODULE$.write(component_dir.platform_props(), this.all_platforms().groupBy((Function1 & Serializable)_$1 -> _$1.family_name()).iterator().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String a = (String)tuple2._1();
                List b = (List)tuple2._2();
                return true;
            }
            return false;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String a = (String)tuple2._1();
                List b = (List)tuple2._2();
                return a + " = " + b.flatMap((Function1 & Serializable)_$2 -> _$2.paths()).mkString(" ");
            }
            throw new MatchError((Object)tuple2);
        }).mkString("", "\n", "\n"));
        ((Option)package$.MODULE$.proper_string().apply((Object)Isabelle_System$.MODULE$.getenv("ISABELLE_GOROOT", Isabelle_System$.MODULE$.getenv$default$2()))).foreach((Function1)(JProcedure1 & Serializable)old -> Components$.MODULE$.update_components(false, Path$.MODULE$.explode((String)old), Components$.MODULE$.update_components$default$3()));
        Components$.MODULE$.update_components(true, component_dir.path(), Components$.MODULE$.update_components$default$3());
        Isabelle_System$.MODULE$.with_tmp_dir("download", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)download_dir -> MODULE$.all_platforms().withFilter((Function1 & Serializable)platform -> platforms.exists((Function1 & Serializable)spec -> platform.is((String)spec))).foreach((Function1)(JProcedure1 & Serializable)platform -> {
            Path platform_dir = component_dir.path().$plus(platform.path());
            if (platform_dir.is_dir() && !force) {
                progress.echo_warning("Platform " + platform + " already installed", progress.echo_warning$default$2());
                return;
            }
            progress.echo("Platform " + platform + " ...", progress.echo$default$2());
            progress.expose_interrupt();
            if (force) {
                platform.paths().foreach((Function1)(JProcedure1 & Serializable)name -> {
                    Path dir = component_dir.path().$plus(Path$.MODULE$.explode((String)name));
                    if (dir.is_dir()) {
                        Isabelle_System$.MODULE$.rm_tree(dir);
                        return;
                    }
                });
            }
            String download = platform.download(base_url, version);
            String archive_name = (String)Url$.MODULE$.get_base_name(download, Url$.MODULE$.get_base_name$default$2()).getOrElse(() -> Go_Setup$.$anonfun$7(download));
            Path archive_path = download_dir.$plus(Path$.MODULE$.basic(archive_name));
            Isabelle_System$.MODULE$.download_file(download, archive_path, Isabelle_System$.MODULE$.download_file$default$3());
            Isabelle_System$.MODULE$.extract(archive_path, component_dir.path(), true);
            Isabelle_System$.MODULE$.move_file(component_dir.bin(), platform_dir);
        }));
        File$.MODULE$.find_files(component_dir.path().file(), (Function1<File, Object>)(Function1 & Serializable)file -> File$.MODULE$.is_exe(file.getName()), File$.MODULE$.find_files$default$3(), File$.MODULE$.find_files$default$4()).foreach((Function1)(JProcedure1 & Serializable)file -> File$.MODULE$.set_executable(File$.MODULE$.path((File)file), File$.MODULE$.set_executable$default$2()));
        File$.MODULE$.write(component_dir.README(), "This installation of Go has been produced via \"isabelle go_setup\".\n\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
    }

    public List<String> go_setup$default$1() {
        return (List)new .colon.colon((Object)this.default_platform(), (List)Nil$.MODULE$);
    }

    public String go_setup$default$2() {
        return this.default_url();
    }

    public String go_setup$default$3() {
        return this.default_version();
    }

    public Path go_setup$default$4() {
        return this.default_target_dir();
    }

    public Progress go_setup$default$5() {
        return new Progress();
    }

    public boolean go_setup$default$6() {
        return false;
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle go_setup [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -U URL       download URL (default: \"" + this.default_url() + "\")\n    -V VERSION   version (default: ISABELLE_GO_SETUP_VERSION=" + package$.MODULE$.quote().apply((Object)this.default_version()) + ")\n    -f           force fresh installation of specified platforms\n    -p PLATFORMS comma-separated list of platform specifications: \"all\" or\n                 as family or formal name (default: " + package$.MODULE$.quote().apply((Object)this.default_platform()) + ")\n\n  Download the Go development environment and configure it as Isabelle\n  component. See also https://go.dev\n";
    }

    private static final String $anonfun$7(String download$1) {
        return (String)package$.MODULE$.error().apply((Object)("Malformed download URL " + package$.MODULE$.quote().apply((Object)download$1)));
    }
}

