/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Consumer_Thread;
import isabelle.Consumer_Thread$;
import isabelle.Database_Progress$;
import isabelle.Database_Progress$private_data$;
import isabelle.Database_Progress$private_data$Agents$;
import isabelle.Database_Progress$private_data$Base$;
import isabelle.Date;
import isabelle.Date$;
import isabelle.Exn$Res$;
import isabelle.Progress;
import isabelle.SQL;
import isabelle.Time;
import isabelle.UUID$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.function.JProcedure1;

public class Database_Progress
extends Progress
implements Progress.Status {
    private List _status;
    private final SQL.Database db;
    private final Progress base_progress;
    private final boolean input_messages;
    private final String kind;
    private final String hostname;
    private final String context_uuid;
    private final Option<Time> timeout;
    private final int tick_expire;
    private final Date start;
    private long _tick;
    private String _agent_uuid;
    private long _context;
    private long _serial;
    private Consumer_Thread<List<Progress.Msg>> _consumer;

    public static boolean $lessinit$greater$default$3() {
        return Database_Progress$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$4() {
        return Database_Progress$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$5() {
        return Database_Progress$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$6() {
        return Database_Progress$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<Time> $lessinit$greater$default$7() {
        return Database_Progress$.MODULE$.$lessinit$greater$default$7();
    }

    public static int $lessinit$greater$default$8() {
        return Database_Progress$.MODULE$.$lessinit$greater$default$8();
    }

    public Database_Progress(SQL.Database db, Progress base_progress, boolean input_messages, String kind, String hostname, String context_uuid, Option<Time> timeout, int tick_expire) {
        this.db = db;
        this.base_progress = base_progress;
        this.input_messages = input_messages;
        this.kind = kind;
        this.hostname = hostname;
        this.context_uuid = context_uuid;
        this.timeout = timeout;
        this.tick_expire = tick_expire;
        Progress.Status.$init$(this);
        this.start = this.now();
        if (UUID$.MODULE$.unapply(context_uuid).isEmpty()) {
            package$.MODULE$.error().apply((Object)("Bad Database_Progress.context_uuid: " + package$.MODULE$.quote().apply((Object)context_uuid)));
        }
        this._tick = 0L;
        this._agent_uuid = "";
        this._context = -1L;
        this._serial = 0L;
        this._consumer = null;
        this.init();
        this.sync();
    }

    public List _status() {
        return this._status;
    }

    public void _status_$eq(List x$1) {
        this._status = x$1;
    }

    @Override
    public Date now() {
        return this.db.now();
    }

    @Override
    public Date start() {
        return this.start;
    }

    public String agent_uuid() {
        String string;
        Database_Progress database_Progress = this;
        synchronized (database_Progress) {
            string = this._agent_uuid;
        }
        return string;
    }

    private void init() {
        Database_Progress database_Progress = this;
        synchronized (database_Progress) {
            this.db.listen(Database_Progress$private_data$.MODULE$.channel());
            Database_Progress$private_data$.MODULE$.transaction_lock(this.db, true, "Database_Progress.init", Database_Progress$private_data$.MODULE$.transaction_lock$default$4(), (Function0 & Serializable)() -> {
                this.init$$anonfun$1();
                return BoxedUnit.UNIT;
            });
            String string = this.context_uuid;
            String string2 = this._agent_uuid;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.db.vacuum(Database_Progress$private_data$.MODULE$.tables().list());
            }
            boolean bl = Consumer_Thread$.MODULE$.fork_bulk$default$2();
            this._consumer = Consumer_Thread$.MODULE$.fork_bulk("Database_Progress.consumer", bl, (Function1 & Serializable)_$7 -> true, (Function1 & Serializable)bulk_outputs -> {
                List bulk_output2 = (List)bulk_outputs.flatten(Predef$.MODULE$.$conforms());
                List results = bulk_output2.isEmpty() ? this.consume$1((List)scala.package$.MODULE$.Nil()) : bulk_output2.grouped(200).toList().flatMap((Function1 & Serializable)bulk_output -> this.consume$1((List)bulk_output));
                return Tuple2$.MODULE$.apply((Object)results, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }, this.timeout, Consumer_Thread$.MODULE$.fork_bulk$default$6("Database_Progress.consumer", bl), Consumer_Thread$.MODULE$.fork_bulk$default$7("Database_Progress.consumer", bl));
        }
    }

    public void close() {
        Database_Progress database_Progress = this;
        synchronized (database_Progress) {
            if (this._context > 0L) {
                this._consumer.shutdown();
                this._consumer = null;
                Database_Progress$private_data$.MODULE$.transaction_lock(this.db, Database_Progress$private_data$.MODULE$.transaction_lock$default$2(), "Database_Progress.exit", Database_Progress$private_data$.MODULE$.transaction_lock$default$4(), (Function0 & Serializable)() -> {
                    this.close$$anonfun$1();
                    return BoxedUnit.UNIT;
                });
                this._context = 0L;
            }
            this.db.close();
        }
    }

    private <A> A sync_context(Function0<A> body) {
        Object object;
        Database_Progress database_Progress = this;
        synchronized (database_Progress) {
            if (this._context < 0L) {
                throw new IllegalStateException("Database_Progress before init");
            }
            if (this._context == 0L) {
                throw new IllegalStateException("Database_Progress after exit");
            }
            object = body.apply();
        }
        return (A)object;
    }

    private <A> A sync_database(Function0<A> body) {
        Object a;
        Database_Progress database_Progress = this;
        synchronized (database_Progress) {
            a = Database_Progress$private_data$.MODULE$.transaction_lock(this.db, Database_Progress$private_data$.MODULE$.transaction_lock$default$2(), "Database_Progress.sync_database", Database_Progress$private_data$.MODULE$.transaction_lock$default$4(), () -> this.sync_database$$anonfun$1(body));
        }
        return a;
    }

    private void sync() {
        this.sync_database((Function0 & Serializable)() -> {
            Database_Progress.sync$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void status_output(List<Progress.Msg> msgs) {
        this.sync_context((Function0 & Serializable)() -> {
            this.status_output$$anonfun$1(msgs);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean verbose() {
        return this.base_progress.verbose();
    }

    @Override
    public void stop() {
        this.sync_context((Function0 & Serializable)() -> {
            this.stop$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean stopped() {
        return BoxesRunTime.unboxToBoolean(this.sync_context(this::stopped$$anonfun$1));
    }

    @Override
    public String toString() {
        return super.toString() + ": database " + this.db;
    }

    private final void init$$anonfun$1() {
        Option<Object> option = Database_Progress$private_data$.MODULE$.read_progress_context(this.db, this.context_uuid);
        if (option instanceof Some) {
            long context;
            this._context = context = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            this._agent_uuid = UUID$.MODULE$.random_string();
        } else if (None$.MODULE$.equals(option)) {
            this._context = Database_Progress$private_data$.MODULE$.next_progress_context(this.db);
            this._agent_uuid = this.context_uuid;
            this.db.execute_statement(Database_Progress$private_data$Base$.MODULE$.table().insert(Database_Progress$private_data$Base$.MODULE$.table().insert$default$1()), (Function1<SQL.Statement, BoxedUnit>)(JProcedure1 & Serializable)stmt -> {
                stmt.string().update(1, this.context_uuid);
                stmt.long().update(2, this._context);
                stmt.bool().update(3, false);
            });
        } else {
            throw new MatchError(option);
        }
        this.db.execute_statement(Database_Progress$private_data$Agents$.MODULE$.table().insert(Database_Progress$private_data$Agents$.MODULE$.table().insert$default$1()), (Function1<SQL.Statement, BoxedUnit>)(JProcedure1 & Serializable)stmt -> {
            ProcessHandle java = ProcessHandle.current();
            long java_pid = java.pid();
            Date java_start = Date$.MODULE$.instant(java.info().startInstant().get(), Date$.MODULE$.instant$default$2());
            stmt.string().update(1, this._agent_uuid);
            stmt.string().update(2, this.context_uuid);
            stmt.string().update(3, this.kind);
            stmt.string().update(4, this.hostname);
            stmt.long().update(5, java_pid);
            stmt.date().update(6, java_start);
            stmt.date().update(7, this.start());
            stmt.date().update(8, this.start());
            stmt.date().update(9, (Option<Date>)None$.MODULE$);
            stmt.long().update(10, 0L);
        });
    }

    private final List consume$1$$anonfun$1(List bulk_output$1) {
        if (bulk_output$1.nonEmpty()) {
            this.base_progress.output((List<Progress.Msg>)bulk_output$1);
            List messages = (List)((IterableOps)bulk_output$1.zipWithIndex()).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Progress.Msg out = (Progress.Msg)tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return true;
                }
                return false;
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Progress.Msg out = (Progress.Msg)tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    Long l = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)(this._serial + (long)i + 1L)));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l, (Object)out.message());
                }
                throw new MatchError((Object)tuple2);
            });
            Database_Progress$private_data$.MODULE$.write_messages(this.db, this._context, (List<Tuple2<Object, Progress.Message>>)messages);
            this._serial = BoxesRunTime.unboxToLong((Object)((Tuple2)messages.last())._1());
            this.db.send(Database_Progress$private_data$.MODULE$.channel_output());
        }
        return bulk_output$1.map((Function1 & Serializable)_$6 -> Exn$Res$.MODULE$.apply(BoxedUnit.UNIT));
    }

    private final List consume$1(List bulk_output) {
        boolean ok;
        boolean bl;
        Database_Progress database_Progress = this;
        synchronized (database_Progress) {
            ++this._tick;
            bl = this._tick % (long)this.tick_expire == 0L;
        }
        boolean expired = bl;
        Option<List<SQL.Notification>> received = this.db.receive((Function1<SQL.Notification, Object>)(Function1 & Serializable)n -> {
            String string = n.channel();
            String string2 = Database_Progress$private_data$.MODULE$.channel();
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        boolean bl2 = ok = bulk_output.nonEmpty() || expired || this.base_progress.stopped() || received.isEmpty() || ((List)received.get()).contains((Object)Database_Progress$private_data$.MODULE$.channel_ping()) || this.input_messages && ((List)received.get()).contains((Object)Database_Progress$private_data$.MODULE$.channel_output());
        if (ok) {
            return (List)this.sync_database(() -> this.consume$1$$anonfun$1(bulk_output));
        }
        return scala.package$.MODULE$.Nil();
    }

    private final void close$$anonfun$1() {
        Database_Progress$private_data$.MODULE$.update_agent(this.db, this._agent_uuid, this._serial, true);
    }

    private final Object sync_database$$anonfun$1(Function0 body$3) {
        boolean stopped_db = Database_Progress$private_data$.MODULE$.read_progress_stopped(this.db, this._context);
        if (stopped_db && !this.base_progress.stopped()) {
            this.base_progress.stop();
        }
        if (!stopped_db && this.base_progress.stopped()) {
            Database_Progress$private_data$.MODULE$.write_progress_stopped(this.db, this._context, true);
            this.db.send(Database_Progress$private_data$.MODULE$.channel_ping());
        }
        long serial0 = this._serial;
        if (this.input_messages) {
            SortedMap<Object, Progress.Message> messages = Database_Progress$private_data$.MODULE$.read_messages(this.db, this._context, this._serial);
            messages.withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    long message_serial = BoxesRunTime.unboxToLong((Object)tuple2._1());
                    Progress.Message message = (Progress.Message)tuple2._2();
                    return true;
                }
                return false;
            }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    long message_serial = BoxesRunTime.unboxToLong((Object)tuple2._1());
                    Progress.Message message = (Progress.Message)tuple2._2();
                    this.base_progress.output((List<Progress.Msg>)((List)new .colon.colon((Object)message, (List)Nil$.MODULE$)));
                    this._serial = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(this._serial), message_serial);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
        } else {
            this._serial = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(this._serial), Database_Progress$private_data$.MODULE$.read_messages_serial(this.db, this._context));
        }
        Object res = body$3.apply();
        if (this._serial != serial0) {
            Database_Progress$private_data$.MODULE$.update_agent(this.db, this._agent_uuid, this._serial, Database_Progress$private_data$.MODULE$.update_agent$default$4());
        }
        return res;
    }

    private static final void sync$$anonfun$1() {
    }

    private final void status_output$$anonfun$1(List msgs$1) {
        this._consumer.send((List<Progress.Msg>)msgs$1);
    }

    private final void stop$$anonfun$1() {
        this.base_progress.stop();
        this.sync();
    }

    private final boolean stopped$$anonfun$1() {
        return this.base_progress.stopped();
    }
}

