/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Component_MLton;
import isabelle.Component_MLton$Download_Platform$;
import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.Scala_Project$;
import isabelle.Url$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_MLton$
implements Serializable {
    public static final Component_MLton$Download_Platform$ Download_Platform;
    private static final List platforms;
    private static final String default_url;
    private static final String default_url_suffix;
    private static final String default_version;
    private static final String default_variant;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_MLton$ MODULE$;

    private Component_MLton$() {
    }

    static {
        MODULE$ = new Component_MLton$();
        platforms = (List)new .colon.colon((Object)Component_MLton$Download_Platform$.MODULE$.apply("arm64-darwin", "arm64-darwin.macos-14_gmp-static.tgz"), (List)new .colon.colon((Object)Component_MLton$Download_Platform$.MODULE$.apply("x86_64-darwin", "amd64-darwin.macos-13_gmp-static.tgz"), (List)new .colon.colon((Object)Component_MLton$Download_Platform$.MODULE$.apply("x86_64-linux", "amd64-linux.ubuntu-20.04_static.tgz"), (List)Nil$.MODULE$)));
        default_url = "https://master.dl.sourceforge.net/project/mlton/mlton";
        default_url_suffix = "?viasf=1";
        default_version = "20241230";
        default_variant = "mlton-20241230-1";
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_mlton", "build component for MLton", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef base_url_suffix = ObjectRef.create((Object)this.default_url_suffix());
            ObjectRef base_url = ObjectRef.create((Object)this.default_url());
            ObjectRef version = ObjectRef.create((Object)this.default_version());
            ObjectRef variant = ObjectRef.create((Object)this.default_variant());
            Object[] objectArray = new Tuple2[5];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"S:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                base_url_suffix$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                base_url$1.elem = arg;
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"V:");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)arg -> {
                version$1.elem = arg;
            });
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"W:");
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (JProcedure1 & Serializable)arg -> {
                variant$1.elem = arg;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_mlton((String)base_url.elem, (String)base_url_suffix.elem, (String)version.elem, (String)variant.elem, (Path)target_dir.elem, progress);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_MLton$.class);
    }

    public List<Component_MLton.Download_Platform> platforms() {
        return platforms;
    }

    public String default_url() {
        return default_url;
    }

    public String default_url_suffix() {
        return default_url_suffix;
    }

    public String default_version() {
        return default_version;
    }

    public String default_variant() {
        return default_variant;
    }

    public void build_mlton(String base_url, String base_url_suffix, String version, String variant, Path target_dir, Progress progress) {
        Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(variant)), Components$Directory$.MODULE$.apply$default$2());
        Components.Directory component_dir = directory.create(progress, directory.create$default$2());
        this.platforms().foreach((Function1)(JProcedure1 & Serializable)platform -> Isabelle_System$.MODULE$.with_tmp_dir("download", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)download_dir -> {
            String archive_name = platform.download_name();
            Path archive_path = download_dir.$plus(Path$.MODULE$.basic(archive_name));
            Path platform_dir = component_dir.path().$plus(Path$.MODULE$.explode(platform.platform_name()));
            Isabelle_System$.MODULE$.make_directory(platform_dir);
            String url = Url$.MODULE$.append_path(base_url, version) + "/" + variant + "." + archive_name + base_url_suffix;
            Isabelle_System$.MODULE$.download_file(url, archive_path, progress);
            Isabelle_System$.MODULE$.extract(archive_path, platform_dir, true);
            Isabelle_System$.MODULE$.copy_file(platform_dir.$plus(Path$.MODULE$.basic("LICENSE")), platform_dir.expand().dir());
        }));
        component_dir.write_settings("\nISABELLE_MLTON_HOME=\"$COMPONENT\"\n\nif [ -d \"$ISABELLE_MLTON_HOME/${ISABELLE_APPLE_PLATFORM64:-$ISABELLE_PLATFORM64}\" ]; then\n  ISABELLE_MLTON=\"$ISABELLE_MLTON_HOME/${ISABELLE_APPLE_PLATFORM64:-$ISABELLE_PLATFORM64}/bin/mlton\"\n  case \"$ISABELLE_PLATFORM_FAMILY\" in\n    linux*)\n      ISABELLE_MLTON_OPTIONS=\"-pi-style npi\"\n      ;;\n    *)\n      ISABELLE_MLTON_OPTIONS=\"\"\n      ;;\n  esac\nfi\n");
        File$.MODULE$.write(component_dir.README(), "This is the MLton SML compiler from\nhttps://sourceforge.net/projects/mlton using following downloads:" + this.platforms().map((Function1 & Serializable)_$1 -> _$1.download_name()).mkString("\n\n  ", "\n  ", "\n\n") + "Windows and Linux ARM are unsupported.\n\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
    }

    public String build_mlton$default$1() {
        return this.default_url();
    }

    public String build_mlton$default$2() {
        return this.default_url_suffix();
    }

    public String build_mlton$default$3() {
        return this.default_version();
    }

    public String build_mlton$default$4() {
        return this.default_variant();
    }

    public Path build_mlton$default$5() {
        return Path$.MODULE$.current();
    }

    public Progress build_mlton$default$6() {
        return new Progress();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_mlton [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -S SUFFIX    download URL suffix (default: \"" + this.default_url_suffix() + "\")\n    -U URL       download URL (default: \"" + this.default_url() + "\")\n    -V VERSION   version (default: \"" + this.default_version() + "\")\n    -W VARIANT   variant (default: \"" + this.default_variant() + "\")\n\n  Build component for MLton compiler.\n";
    }
}

