/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Component_JDK;
import isabelle.Component_JDK$Download_Platform$;
import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Library$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Progress;
import isabelle.Scala_Project$;
import isabelle.package$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_JDK$
implements Serializable {
    public static final Component_JDK$Download_Platform$ Download_Platform;
    private static final List platforms;
    private static final String default_base_url;
    private static final String default_jdk_version;
    private static final String default_zulu_version;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_JDK$ MODULE$;

    private Component_JDK$() {
    }

    static {
        MODULE$ = new Component_JDK$();
        platforms = (List)new .colon.colon((Object)Component_JDK$Download_Platform$.MODULE$.apply("arm64-darwin", "zulu{Z}-jdk{V}-macosx_aarch64.tar.gz"), (List)new .colon.colon((Object)Component_JDK$Download_Platform$.MODULE$.apply("arm64-linux", "zulu{Z}-jdk{V}-linux_aarch64.tar.gz"), (List)new .colon.colon((Object)Component_JDK$Download_Platform$.MODULE$.apply("x86_64-darwin", "zulu{Z}-jdk{V}-macosx_x64.tar.gz"), (List)new .colon.colon((Object)Component_JDK$Download_Platform$.MODULE$.apply("x86_64-linux", "zulu{Z}-jdk{V}-linux_x64.tar.gz"), (List)new .colon.colon((Object)Component_JDK$Download_Platform$.MODULE$.apply("x86_64-windows", "zulu{Z}-jdk{V}-win_x64.zip"), (List)Nil$.MODULE$)))));
        default_base_url = "https://cdn.azul.com/zulu/bin";
        default_jdk_version = "21.0.9";
        default_zulu_version = "21.46.19-ca";
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_jdk", "build Isabelle jdk component using downloads from Azul", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef base_url = ObjectRef.create((Object)this.default_base_url());
            ObjectRef jdk_version = ObjectRef.create((Object)this.default_jdk_version());
            ObjectRef zulu_version = ObjectRef.create((Object)this.default_zulu_version());
            Object[] objectArray = new Tuple2[4];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                base_url$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"V:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                jdk_version$1.elem = arg;
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Z:");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)arg -> {
                zulu_version$1.elem = arg;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_jdk((Path)target_dir.elem, (String)base_url.elem, (String)jdk_version.elem, (String)zulu_version.elem, progress);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_JDK$.class);
    }

    public List<Component_JDK.Download_Platform> platforms() {
        return platforms;
    }

    public String default_base_url() {
        return default_base_url;
    }

    public String default_jdk_version() {
        return default_jdk_version;
    }

    public String default_zulu_version() {
        return default_zulu_version;
    }

    public void build_jdk(Path target_dir, String base_url, String jdk_version, String zulu_version, Progress progress) {
        if (Platform$.MODULE$.is_windows()) {
            package$.MODULE$.error().apply((Object)"Cannot build on Windows");
        }
        String component = "jdk-" + jdk_version;
        Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component)), Components$Directory$.MODULE$.apply$default$2());
        Components.Directory component_dir = directory.create(progress, directory.create$default$2());
        this.platforms().foreach((Function1)(JProcedure1 & Serializable)platform -> Isabelle_System$.MODULE$.with_tmp_dir("download", component_dir.path().file(), (JProcedure1 & Serializable)dir -> {
            String url = platform.url(base_url, jdk_version, zulu_version);
            String name = ((IterableOnceOps)Library$.MODULE$.take_suffix((Function1 & Serializable)_$1 -> !BoxesRunTime.equals((Object)_$1, (Object)BoxesRunTime.boxToCharacter((char)'/')), Predef$.MODULE$.wrapString(url).toList())._2()).mkString();
            Path file = dir.$plus(Path$.MODULE$.basic(name));
            Isabelle_System$.MODULE$.download_file(url, file, progress);
            Path platform_dir = component_dir.path().$plus(Path$.MODULE$.basic(platform.name()));
            Isabelle_System$.MODULE$.extract(file, platform_dir, true);
        }));
        File file2 = component_dir.path().file();
        Function1<File, Object> function1 = File$.MODULE$.find_files$default$2();
        boolean bl = File$.MODULE$.find_files$default$4();
        File$.MODULE$.find_files(file2, function1, true, bl).foreach((Function1 & Serializable)file -> {
            String name = file.getName();
            java.nio.file.Path path = file.toPath();
            Set<PosixFilePermission> perms = Files.getPosixFilePermissions(path, new LinkOption[0]);
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.GROUP_READ);
            perms.add(PosixFilePermission.OTHERS_READ);
            perms.add(PosixFilePermission.OWNER_WRITE);
            if (File$.MODULE$.is_dll(name) || File$.MODULE$.is_exe(name) || file.isDirectory()) {
                perms.add(PosixFilePermission.OWNER_EXECUTE);
                perms.add(PosixFilePermission.GROUP_EXECUTE);
                perms.add(PosixFilePermission.OTHERS_EXECUTE);
            }
            return Files.setPosixFilePermissions(path, perms);
        });
        component_dir.write_settings("\ncase \"$ISABELLE_PLATFORM_FAMILY\" in\n  linux*)\n    ISABELLE_JAVA_PLATFORM=\"$ISABELLE_PLATFORM64\"\n    ISABELLE_JDK_HOME=\"$COMPONENT/$ISABELLE_JAVA_PLATFORM\"\n    ;;\n  windows*)\n    ISABELLE_JAVA_PLATFORM=\"$ISABELLE_WINDOWS_PLATFORM64\"\n    ISABELLE_JDK_HOME=\"$COMPONENT/$ISABELLE_JAVA_PLATFORM\"\n    ;;\n  macos*)\n    if [ -n \"$ISABELLE_APPLE_PLATFORM64\" -a -d \"$COMPONENT/$ISABELLE_APPLE_PLATFORM64\" ]\n    then\n      ISABELLE_JAVA_PLATFORM=\"$ISABELLE_APPLE_PLATFORM64\"\n    else\n      ISABELLE_JAVA_PLATFORM=\"$ISABELLE_PLATFORM64\"\n    fi\n    ISABELLE_JDK_HOME=\"$COMPONENT/$ISABELLE_JAVA_PLATFORM\"\n    ;;\nesac\n");
        File$.MODULE$.write(component_dir.README(), "This is OpenJDK " + jdk_version + " based on downloads by Azul, see also\nhttps://www.azul.com/downloads/?package=jdk\n\nThe main license is GPL2, but some modules are covered by other (more liberal)\nlicenses, see legal/* for details.\n\nLinux, Windows, macOS all work uniformly, depending on platform-specific\nsubdirectories.\n");
    }

    public Path build_jdk$default$1() {
        return Path$.MODULE$.current();
    }

    public String build_jdk$default$2() {
        return this.default_base_url();
    }

    public String build_jdk$default$3() {
        return this.default_jdk_version();
    }

    public String build_jdk$default$4() {
        return this.default_zulu_version();
    }

    public Progress build_jdk$default$5() {
        return new Progress();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_jdk [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -U URL       base URL (default: \"" + this.default_base_url() + "\")\n    -V NAME      JDK version (default: \"" + this.default_jdk_version() + "\")\n    -Z NAME      Zulu version (default: \"" + this.default_zulu_version() + "\")\n\n  Build Isabelle jdk component using downloads from Azul.\n";
    }
}

