/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Component_Fonts;
import isabelle.Component_Fonts$Family$;
import isabelle.Component_Fonts$Range$;
import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Fontforge;
import isabelle.Fontforge$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.Scala_Project$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_Fonts$
implements Serializable {
    public static final Component_Fonts$Range$ Range;
    public static final Component_Fonts$Family$ Family;
    private static final List<Object> hinting;
    private static final String default_download_url;
    private static final List default_sources;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_Fonts$ MODULE$;

    private Component_Fonts$() {
    }

    static {
        MODULE$ = new Component_Fonts$();
        hinting = (List)new .colon.colon((Object)BoxesRunTime.boxToBoolean((boolean)false), (List)new .colon.colon((Object)BoxesRunTime.boxToBoolean((boolean)true), (List)Nil$.MODULE$));
        default_download_url = "https://github.com/dejavu-fonts/dejavu-fonts/releases/download/version_2_37/dejavu-fonts-ttf-2.37.zip";
        default_sources = (List)new .colon.colon((Object)Component_Fonts$Family$.MODULE$.deja_vu_sans_mono(), (List)new .colon.colon((Object)Component_Fonts$Family$.MODULE$.deja_vu_sans(), (List)new .colon.colon((Object)Component_Fonts$Family$.MODULE$.deja_vu_serif(), (List)Nil$.MODULE$)));
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_fonts", "construct Isabelle fonts", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef download_url = ObjectRef.create((Object)this.default_download_url());
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$2.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                download_url$2.elem = arg;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            String string3 = (String)download_url.elem;
            Path path = (Path)target_dir.elem;
            String string4 = this.build_fonts$default$3();
            List<Component_Fonts.Family> list = this.build_fonts$default$4();
            this.build_fonts(string3, path, string4, list, progress);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_Fonts$.class);
    }

    private void auto_hint(Path source, Path target) {
        Isabelle_System$.MODULE$.bash("ttfautohint -i " + File$.MODULE$.bash_path(source) + " " + File$.MODULE$.bash_path(target), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check();
    }

    private Path make_path(boolean hinted) {
        if (hinted) {
            return Path$.MODULE$.basic("ttf-hinted");
        }
        return Path$.MODULE$.basic("ttf");
    }

    private boolean make_path$default$1() {
        return false;
    }

    private Path find_file(List<Path> dirs, String name) {
        Path path = Path$.MODULE$.explode(name);
        Option option = dirs.collectFirst((PartialFunction)new Serializable(path){
            private final Path path$1;
            {
                this.path$1 = path$2;
            }

            public final boolean isDefinedAt(Path x) {
                Path path = x;
                Path dir = path;
                return dir.$plus(this.path$1).is_file();
            }

            public final Object applyOrElse(Path x, Function1 function1) {
                Path path = x;
                Path dir = path;
                if (dir.$plus(this.path$1).is_file()) {
                    return dir.$plus(this.path$1);
                }
                return function1.apply((Object)x);
            }
        });
        if (option instanceof Some) {
            Path file = (Path)((Some)option).value();
            return file;
        }
        if (None$.MODULE$.equals(option)) {
            String string = "Failed to find font file " + path + " in directories:";
            return (Path)package$.MODULE$.error().apply(package$.MODULE$.cat_lines().apply((Object)dirs.map((Function1 & Serializable)dir -> "  " + dir.toString()).$colon$colon((Object)string)));
        }
        throw new MatchError((Object)option);
    }

    public String default_download_url() {
        return default_download_url;
    }

    public List<Component_Fonts.Family> default_sources() {
        return default_sources;
    }

    public void build_fonts(String download_url, Path target_dir, String target_prefix, List<Component_Fonts.Family> sources, Progress progress) {
        Isabelle_System$.MODULE$.require_command("ttfautohint", Isabelle_System$.MODULE$.require_command$default$2());
        Isabelle_System$.MODULE$.with_tmp_file("download", "zip", Isabelle_System$.MODULE$.with_tmp_file$default$3(), (JProcedure1 & Serializable)download_file -> Isabelle_System$.MODULE$.with_tmp_dir("download", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)download_dir -> {
            Isabelle_System$.MODULE$.download_file(download_url, (Path)download_file, progress);
            Isabelle_System$.MODULE$.extract((Path)download_file, (Path)download_dir, Isabelle_System$.MODULE$.extract$default$3());
            Path dejavu_dir = File$.MODULE$.get_dir((Path)download_dir, download_url).$plus(Path$.MODULE$.basic("ttf"));
            String component_date = Date$Format$.MODULE$.alt_date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1()));
            String component_name = "isabelle_fonts-" + component_date;
            Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component_name)), Components$Directory$.MODULE$.apply$default$2());
            Components.Directory component_dir = directory.create(progress, directory.create$default$2());
            hinting.foreach((Function1 & Serializable)hinted -> Isabelle_System$.MODULE$.make_directory(component_dir.path().$plus(Component_Fonts$.MODULE$.make_path(BoxesRunTime.unboxToBoolean((Object)hinted)))));
            List font_dirs = (List)new .colon.colon((Object)dejavu_dir, (List)new .colon.colon((Object)Path$.MODULE$.explode("~~/Admin/isabelle_fonts"), (List)Nil$.MODULE$));
            font_dirs.withFilter((Function1 & Serializable)dir -> !dir.is_dir()).foreach((Function1 & Serializable)dir -> package$.MODULE$.error().apply((Object)("Bad source directory: " + dir)));
            List fonts = sources.flatMap((Function1 & Serializable)source -> (IterableOnce)((IterableOps)source.fonts().zipWithIndex()).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String source_font = (String)tuple2._1();
                    int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return true;
                }
                return false;
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String source_font = (String)tuple2._1();
                    int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    Path isabelle_file = MODULE$.find_file((List<Path>)font_dirs, Component_Fonts$Family$.MODULE$.isabelle_symbols().get(index));
                    Path source_file = MODULE$.find_file((List<Path>)font_dirs, source_font);
                    Fontforge.Font_Names source_names = Fontforge$.MODULE$.font_names(source_file);
                    Fontforge.Font_Names font_names = source_names.update(target_prefix, component_date);
                    Isabelle_System$.MODULE$.with_tmp_file("font", "ttf", Isabelle_System$.MODULE$.with_tmp_file$default$3(), (JProcedure1 & Serializable)tmp_file -> hinting.foreach((Function1 & Serializable)hinted -> Component_Fonts$.$anonfun$4$$anonfun$2$$anonfun$1$$anonfun$1(component_dir, font_names, progress, source_file, tmp_file, isabelle_file, BoxesRunTime.unboxToBoolean((Object)hinted))));
                    return Tuple2$.MODULE$.apply((Object)font_names.ttf(), (Object)BoxesRunTime.boxToInteger((int)index));
                }
                throw new MatchError((Object)tuple2);
            }));
            Path vacuous_file = this.find_file((List<Path>)font_dirs, Component_Fonts$Family$.MODULE$.vacuous().get(0));
            Path font_dir = component_dir.path().$plus(this.make_path(this.make_path$default$1()));
            Fontforge.Font_Names font_names = Fontforge$.MODULE$.font_names(vacuous_file);
            Path font_file = font_dir.$plus(font_names.ttf());
            progress.echo("Font " + font_file + " ...", progress.echo$default$2());
            List domain = (List)((StrictOptimizedSeqOps)((SeqOps)((StrictOptimizedIterableOps)fonts.withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Path name = (Path)tuple2._1();
                    int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return true;
                }
                return false;
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Path name = (Path)tuple2._1();
                    int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return index == 0;
                }
                throw new MatchError((Object)tuple2);
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Path name = (Path)tuple2._1();
                    int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return Fontforge$.MODULE$.font_domain(font_dir.$plus(name), Fontforge$.MODULE$.font_domain$default$2());
                }
                throw new MatchError((Object)tuple2);
            })).flatten(Predef$.MODULE$.$conforms())).distinct()).sorted((Ordering)Ordering.Int$.MODULE$);
            Fontforge$.MODULE$.execute(Fontforge$.MODULE$.commands((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Fontforge$.MODULE$.open(vacuous_file), Fontforge$.MODULE$.select(Component_Fonts$Range$.MODULE$.vacuous_font()), Fontforge$.MODULE$.copy()})) + domain.map((Function1 & Serializable)code -> Fontforge$.MODULE$.commands((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Fontforge$.MODULE$.select((Seq<Object>)((Seq)((SeqOps)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)code)), (List)Nil$.MODULE$)))), Fontforge$.MODULE$.paste()}))).mkString("\n", "\n", "\n") + Fontforge$.MODULE$.commands((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Fontforge$.MODULE$.generate(font_file), Fontforge$.MODULE$.close()})), Fontforge$.MODULE$.execute$default$2(), Fontforge$.MODULE$.execute$default$3()).check();
            component_dir.write_settings("\nif grep \"isabelle_fonts_hinted.*=.*false\" \"$ISABELLE_HOME_USER/etc/preferences\" >/dev/null 2>/dev/null\nthen" + this.make_settings$1(fonts, this.make_settings$default$1$1()) + "\nelse" + this.make_settings$1(fonts, true) + "\nfi\n\nisabelle_fonts_hidden \"$COMPONENT/" + this.make_path(this.make_path$default$1()).file_name() + "/Vacuous.ttf\"\n");
            Isabelle_System$.MODULE$.copy_file(Path$.MODULE$.explode("~~/Admin/isabelle_fonts/README"), component_dir.README());
        }));
    }

    public String build_fonts$default$1() {
        return this.default_download_url();
    }

    public Path build_fonts$default$2() {
        return Path$.MODULE$.current();
    }

    public String build_fonts$default$3() {
        return "Isabelle";
    }

    public List<Component_Fonts.Family> build_fonts$default$4() {
        return this.default_sources();
    }

    public Progress build_fonts$default$5() {
        return new Progress();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_fonts [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -U URL       download URL (default: \"" + this.default_download_url() + "\")\n\n  Construct Isabelle fonts from DejaVu font families and Isabelle symbols.\n";
    }

    private static final /* synthetic */ Process_Result $anonfun$4$$anonfun$2$$anonfun$1$$anonfun$1(Components.Directory component_dir$5, Fontforge.Font_Names font_names$2, Progress progress$6, Path source_file$2, Path tmp_file$1, Path isabelle_file$2, boolean hinted) {
        Path font_file = component_dir$5.path().$plus(MODULE$.make_path(hinted)).$plus(font_names$2.ttf());
        progress$6.echo("Font " + font_file + " ...", progress$6.echo$default$2());
        if (hinted) {
            MODULE$.auto_hint(source_file$2, tmp_file$1);
        } else {
            Isabelle_System$.MODULE$.copy_file(source_file$2, tmp_file$1);
        }
        return Fontforge$.MODULE$.execute(Fontforge$.MODULE$.commands((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Fontforge$.MODULE$.open(isabelle_file$2), Fontforge$.MODULE$.select(Component_Fonts$Range$.MODULE$.isabelle_font()), Fontforge$.MODULE$.copy(), Fontforge$.MODULE$.close(), Fontforge$.MODULE$.open(tmp_file$1), Fontforge$.MODULE$.select(Component_Fonts$Range$.MODULE$.base_font()), Fontforge$.MODULE$.select_invert(), Fontforge$.MODULE$.clear(), Fontforge$.MODULE$.select(Component_Fonts$Range$.MODULE$.isabelle_font()), Fontforge$.MODULE$.paste(), font_names$2.set(), Fontforge$.MODULE$.generate(font_file), Fontforge$.MODULE$.close()})), Fontforge$.MODULE$.execute$default$2(), Fontforge$.MODULE$.execute$default$3()).check();
    }

    private final String make_settings$1(List fonts$1, boolean hinted) {
        return "\n  isabelle_fonts \\\n" + ((IterableOnceOps)fonts$1.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path ttf = (Path)tuple2._1();
                return true;
            }
            return false;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path ttf = (Path)tuple2._1();
                return "    \"$COMPONENT/" + MODULE$.make_path(hinted).file_name() + "/" + ttf.file_name() + "\"";
            }
            throw new MatchError((Object)tuple2);
        })).mkString(" \\\n");
    }

    private final boolean make_settings$default$1$1() {
        return false;
    }
}

