/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.HTTP$Content$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.Scala_Project$;
import isabelle.Url$;
import isabelle.find_facts.Find_Facts$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_Find_Facts_Web$
implements Serializable {
    private static final String default_roboto_url;
    private static final String default_roboto_version;
    private static final String default_mcwe_url;
    private static final String default_mcwe_version;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_Find_Facts_Web$ MODULE$;

    private Component_Find_Facts_Web$() {
    }

    static {
        MODULE$ = new Component_Find_Facts_Web$();
        default_roboto_url = "https://r2.fontsource.org/fonts/roboto";
        default_roboto_version = "5.2.8";
        default_mcwe_url = "https://unpkg.com/material-components-web-elm";
        default_mcwe_version = "9.1.0";
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_find_facts_web", "build Find_Facts web component from elm sources and external resources", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$2.elem = Path$.MODULE$.explode((String)arg);
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            Path path = (Path)target_dir.elem;
            String string2 = this.build_find_facts_web$default$1();
            String string3 = this.build_find_facts_web$default$2();
            String string4 = this.build_find_facts_web$default$3();
            String string5 = this.build_find_facts_web$default$4();
            this.build_find_facts_web(string2, string3, string4, string5, path, progress);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_Find_Facts_Web$.class);
    }

    public String default_roboto_url() {
        return default_roboto_url;
    }

    public String default_roboto_version() {
        return default_roboto_version;
    }

    public String default_mcwe_url() {
        return default_mcwe_url;
    }

    public String default_mcwe_version() {
        return default_mcwe_version;
    }

    public void build_find_facts_web(String roboto_base_url, String roboto_version, String mcwe_base_url, String mcwe_version, Path target_dir, Progress progress) {
        String component_name = "find_facts_web-" + Date$Format$.MODULE$.alt_date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1()));
        Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component_name)), Components$Directory$.MODULE$.apply$default$2());
        Components.Directory component_dir = directory.create(progress, directory.create$default$2());
        Path web_dir = Isabelle_System$.MODULE$.make_directory(component_dir.path().$plus(Path$.MODULE$.basic("web")));
        String roboto_download = roboto_base_url + "@" + roboto_version + "/download.zip";
        List roboto_fonts = ((List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)300), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)400), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)500), (List)Nil$.MODULE$)))).map((Function1 & Serializable)weight -> Component_Find_Facts_Web$.$anonfun$3(BoxesRunTime.unboxToInt((Object)weight)));
        Isabelle_System$.MODULE$.with_tmp_dir("download", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)download_dir -> {
            Path archive_path = download_dir.$plus(Path$.MODULE$.basic("download.zip"));
            Isabelle_System$.MODULE$.download_file(roboto_download, archive_path, Isabelle_System$.MODULE$.download_file$default$3());
            Isabelle_System$.MODULE$.extract(archive_path, (Path)download_dir, Isabelle_System$.MODULE$.extract$default$3());
            roboto_fonts.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                int n = BoxesRunTime.unboxToInt((Object)x$1._1());
                String string = (String)x$1._2();
                Isabelle_System$.MODULE$.copy_file(download_dir.$plus(Path$.MODULE$.make((List<String>)((List)new .colon.colon((Object)"webfonts", (List)new .colon.colon((Object)string, (List)Nil$.MODULE$))))), web_dir);
            });
            Isabelle_System$.MODULE$.copy_file(download_dir.$plus(Path$.MODULE$.basic("LICENSE")), component_dir.path().$plus(Path$.MODULE$.basic("LICENSE-roboto")));
            File$.MODULE$.write(web_dir.$plus(Path$.MODULE$.basic("roboto.css")), roboto_fonts.map((Function1 & Serializable)x$1 -> {
                int n = BoxesRunTime.unboxToInt((Object)x$1._1());
                String string = (String)x$1._2();
                return "\n@font-face {\n  font-family: 'Roboto';\n  font-weight: " + n + ";\n  src: url('./" + string + "') format('woff');\n}\n";
            }).mkString());
        });
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"roboto.css");
        Tuple2 roboto_css = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)HTTP$Content$.MODULE$.mime_type_css());
        List roboto_assets = roboto_fonts.map((Function1 & Serializable)x$1 -> {
            int n = BoxesRunTime.unboxToInt((Object)x$1._1());
            String string = (String)x$1._2();
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)string);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"font/woff");
        }).$colon$colon((Object)roboto_css);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"material-components-web-elm.min.js");
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"material-components-web-elm.min.css");
        List mcwe_assets = (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)HTTP$Content$.MODULE$.mime_type_js()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)HTTP$Content$.MODULE$.mime_type_css()), (List)Nil$.MODULE$));
        mcwe_assets.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Isabelle_System$.MODULE$.download_file(this.mcwe_file$1(mcwe_base_url, mcwe_version, "dist/" + name), web_dir.$plus(Path$.MODULE$.basic(name)), Isabelle_System$.MODULE$.download_file$default$3());
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        String assets = mcwe_assets.$colon$colon$colon(roboto_assets).map((Function1 & Serializable)x$1 -> {
            String string = (String)x$1._1();
            String string2 = (String)x$1._2();
            return string + ":" + string2;
        }).mkString(",");
        component_dir.write_settings("\nFIND_FACTS_WEB_ASSETS_DIR=\"$COMPONENT/web\"\nFIND_FACTS_WEB_ASSETS=\"" + assets + "\"\n");
        File$.MODULE$.write(component_dir.README(), "This component contains web assets (downloaded from recommended CDNs) for the Find_Facts\nweb application, and its compiled index.html.\n\nSources can be found in $FIND_FACTS_HOME/web.\n\n\n        Fabian Huch\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
        Isabelle_System$.MODULE$.with_tmp_dir("find_facts", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)dir -> Find_Facts$.MODULE$.build_html(web_dir.$plus(Find_Facts$.MODULE$.web_html()), (Path)dir, assets, progress));
        File$.MODULE$.write(component_dir.path().$plus(Path$.MODULE$.basic("LICENSE-material-components-web-elm")), Url$.MODULE$.read(this.mcwe_file$1(mcwe_base_url, mcwe_version, "LICENSE")));
    }

    public String build_find_facts_web$default$1() {
        return this.default_roboto_url();
    }

    public String build_find_facts_web$default$2() {
        return this.default_roboto_version();
    }

    public String build_find_facts_web$default$3() {
        return this.default_mcwe_url();
    }

    public String build_find_facts_web$default$4() {
        return this.default_mcwe_version();
    }

    public Path build_find_facts_web$default$5() {
        return Path$.MODULE$.current();
    }

    public Progress build_find_facts_web$default$6() {
        return new Progress();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_find_facts_web [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n\n  Build Find_Facts web component from the specified url and elm sources.\n";
    }

    private static final /* synthetic */ Tuple2 $anonfun$3(int weight) {
        Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)weight));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)("roboto-latin-" + weight + "-normal.woff"));
    }

    private final String mcwe_file$1(String mcwe_base_url$2, String mcwe_version$2, String path) {
        return mcwe_base_url$2 + "@" + mcwe_version$2 + "/" + path;
    }
}

