/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Component_CVC5;
import isabelle.Component_CVC5$Download_Platform$;
import isabelle.Components;
import isabelle.Components$Directory$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.Scala_Project$;
import isabelle.Url$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Component_CVC5$
implements Serializable {
    public static final Component_CVC5$Download_Platform$ Download_Platform;
    private static final List platforms;
    private static final String default_url;
    private static final String default_version;
    private static final Isabelle_Tool isabelle_tool;
    public static final Component_CVC5$ MODULE$;

    private Component_CVC5$() {
    }

    static {
        MODULE$ = new Component_CVC5$();
        platforms = (List)new .colon.colon((Object)Component_CVC5$Download_Platform$.MODULE$.apply("arm64-darwin", "cvc5-macOS-arm64-static.zip"), (List)new .colon.colon((Object)Component_CVC5$Download_Platform$.MODULE$.apply("arm64-linux", "cvc5-Linux-arm64-static.zip"), (List)new .colon.colon((Object)Component_CVC5$Download_Platform$.MODULE$.apply("x86_64-darwin", "cvc5-macOS-x86_64-static.zip"), (List)new .colon.colon((Object)Component_CVC5$Download_Platform$.MODULE$.apply("x86_64-linux", "cvc5-Linux-x86_64-static.zip"), (List)new .colon.colon((Object)Component_CVC5$Download_Platform$.MODULE$.apply("x86_64-windows", "cvc5-Win64-x86_64-static.zip"), (List)Nil$.MODULE$)))));
        default_url = "https://github.com/cvc5/cvc5/releases/download";
        default_version = "1.2.0";
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("component_cvc5", "build component for cvc5", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            ObjectRef base_url = ObjectRef.create((Object)this.default_url());
            ObjectRef version = ObjectRef.create((Object)this.default_version());
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode((String)arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                base_url$1.elem = arg;
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"V:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                version$1.elem = arg;
            });
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List<String> more_args = getopts.apply((List<String>)args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_cvc5((String)base_url.elem, (String)version.elem, (Path)target_dir.elem, progress);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Component_CVC5$.class);
    }

    public List<Component_CVC5.Download_Platform> platforms() {
        return platforms;
    }

    public String default_url() {
        return default_url;
    }

    public String default_version() {
        return default_version;
    }

    public void build_cvc5(String base_url, String version, Path target_dir, Progress progress) {
        String component = "cvc5-" + version;
        Components.Directory directory = Components$Directory$.MODULE$.apply(target_dir.$plus(Path$.MODULE$.basic(component)), Components$Directory$.MODULE$.apply$default$2());
        Components.Directory component_dir = directory.create(progress, directory.create$default$2());
        this.platforms().foreach((Function1)(JProcedure1 & Serializable)platform -> Isabelle_System$.MODULE$.with_tmp_dir("download", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (JProcedure1 & Serializable)download_dir -> {
            String download = base_url + "/cvc5-" + version + "/" + platform.download_name();
            String archive_name = (String)Url$.MODULE$.get_base_name(platform.download_name(), Url$.MODULE$.get_base_name$default$2()).getOrElse(() -> Component_CVC5$.$anonfun$5(platform));
            Path archive_path = download_dir.$plus(Path$.MODULE$.basic(archive_name));
            Path platform_dir = component_dir.path().$plus(Path$.MODULE$.explode(platform.platform_name()));
            Isabelle_System$.MODULE$.make_directory(platform_dir);
            Path exe_path = Path$.MODULE$.explode("cvc5").exe_if(platform.is_windows());
            Path exe_bin_path = Path$.MODULE$.explode("cvc5-bin").exe_if(platform.is_windows());
            Path exe = platform_dir.$plus(exe_path);
            Path exe_bin = platform_dir.$plus(exe_bin_path);
            Isabelle_System$.MODULE$.download_file(download, archive_path, progress);
            Isabelle_System$.MODULE$.extract(archive_path, (Path)download_dir, true);
            Isabelle_System$.MODULE$.copy_file(download_dir.$plus(Path$.MODULE$.basic("bin")).$plus(exe_path), exe_bin);
            File$.MODULE$.set_executable(exe_bin, File$.MODULE$.set_executable$default$2());
            File$.MODULE$.write(exe, "#!/usr/bin/env bash\n\n\"$CVC5_HOME/cvc5-bin\" \"$@\"\n");
            File$.MODULE$.set_executable(exe, File$.MODULE$.set_executable$default$2());
        }));
        component_dir.write_settings("\nCVC5_HOME=\"$COMPONENT/${ISABELLE_WINDOWS_PLATFORM64:-${ISABELLE_APPLE_PLATFORM64:-$ISABELLE_PLATFORM64}}\"\nCVC5_VERSION=" + Bash$.MODULE$.string(version) + "\n\nCVC5_SOLVER=\"$CVC5_HOME/cvc5\"\n\nif [ -e \"$CVC5_HOME\" ]\nthen\n  CVC5_INSTALLED=\"yes\"\nfi\n");
        File$.MODULE$.write(component_dir.README(), "This distribution of cvc5 was assembled from official downloads from\n" + base_url + " --- the static.zip variants\nfor macOS, Linux, and Windows, with ARM64 support on macOS and Linux.\n\nThe downloaded files were renamed and made executable.\n\n\n        Makarius\n        " + Date$Format$.MODULE$.date().apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1())) + "\n");
        this.raw_download$1(component_dir, "AUTHORS");
        this.raw_download$1(component_dir, "COPYING");
    }

    public String build_cvc5$default$1() {
        return this.default_url();
    }

    public String build_cvc5$default$2() {
        return this.default_version();
    }

    public Path build_cvc5$default$3() {
        return Path$.MODULE$.current();
    }

    public Progress build_cvc5$default$4() {
        return new Progress();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle component_cvc5 [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -U URL       download URL (default: \"" + this.default_url() + "\")\n    -V VERSION   version (default: \"" + this.default_version() + "\")\n\n  Build component for cvc5 solver.\n";
    }

    private static final String $anonfun$5(Component_CVC5.Download_Platform platform$2) {
        return (String)package$.MODULE$.error().apply((Object)("Malformed download name " + package$.MODULE$.quote().apply((Object)platform$2.download_name())));
    }

    private final void raw_download$1(Components.Directory component_dir$3, String name) {
        Isabelle_System$.MODULE$.download_file("https://raw.githubusercontent.com/cvc5/cvc5/main/" + name, component_dir$3.path().$plus(Path$.MODULE$.explode(name)), Isabelle_System$.MODULE$.download_file$default$3());
    }
}

