/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.Codepoint$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Mercurial;
import isabelle.Mercurial$;
import isabelle.Output$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Position$;
import isabelle.Position$Line_File$;
import isabelle.Scala_Project$;
import isabelle.Symbol$;
import isabelle.Word$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StrictOptimizedLinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class Check_Sources$
implements Serializable {
    private static final Isabelle_Tool isabelle_tool;
    public static final Check_Sources$ MODULE$;

    private Check_Sources$() {
    }

    static {
        MODULE$ = new Check_Sources$();
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("check_sources", "some sanity checks for Isabelle sources", Scala_Project$.MODULE$.here(), (Function1<List<String>, BoxedUnit>)(JProcedure1 & Serializable)args -> {
            Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::$anonfun$1), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            List<String> specs = getopts.apply((List<String>)args);
            if (specs.isEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            specs.foreach((Function1)(JProcedure1 & Serializable)root -> this.check_hg(Path$.MODULE$.explode((String)root)));
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Check_Sources$.class);
    }

    public void check_file(Path path) {
        String file_name = path.implode();
        List<Tuple2<String, String>> file_pos = Position$.MODULE$.File().apply(File$.MODULE$.symbolic_path(path));
        if (((List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)'/'), (Object)Word$.MODULE$.lowercase(path.expand().drop_ext().implode()))).contains((Object)"aux")) {
            Output$.MODULE$.warning("Illegal file-name on Windows" + Position$.MODULE$.here(file_pos, Position$.MODULE$.here$default$2()), Output$.MODULE$.warning$default$2(), Output$.MODULE$.warning$default$3());
        }
        Bytes bytes = Bytes$.MODULE$.read(path);
        String content = bytes.text();
        Bytes bytes2 = Bytes$.MODULE$.apply(content);
        Bytes bytes3 = bytes;
        if (bytes2 == null ? bytes3 != null : !((Object)bytes2).equals(bytes3)) {
            Output$.MODULE$.warning("Bad UTF8 encoding" + Position$.MODULE$.here(file_pos, Position$.MODULE$.here$default$2()), Output$.MODULE$.warning$default$2(), Output$.MODULE$.warning$default$3());
        }
        ((StrictOptimizedLinearSeqOps)package$.MODULE$.split_lines().apply((Object)content)).iterator().zipWithIndex().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String line = (String)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String line = (String)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                try {
                    Symbol$.MODULE$.decode_strict(line);
                    Codepoint$.MODULE$.iterator(line).withFilter((Function1)(JFunction1.mcZI.sp & Serializable)c -> c > 128 && !Character.isAlphabetic(c)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)c -> Output$.MODULE$.warning("Suspicious Unicode character " + package$.MODULE$.quote().apply((Object)Codepoint$.MODULE$.string(c)) + Position$.MODULE$.here((List<Tuple2<String, String>>)this.line_pos$1(file_name, i), Position$.MODULE$.here$default$2()), Output$.MODULE$.warning$default$2(), Output$.MODULE$.warning$default$3()));
                }
                catch (Throwable throwable) {
                    Option<String> option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                        String string;
                        String msg = string = (String)option.get();
                        Output$.MODULE$.warning(msg + Position$.MODULE$.here((List<Tuple2<String, String>>)this.line_pos$1(file_name, i), Position$.MODULE$.here$default$2()), Output$.MODULE$.warning$default$2(), Output$.MODULE$.warning$default$3());
                    }
                    throw throwable;
                }
                if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(line), '\t')) {
                    Output$.MODULE$.warning("TAB character" + Position$.MODULE$.here((List<Tuple2<String, String>>)this.line_pos$1(file_name, i), Position$.MODULE$.here$default$2()), Output$.MODULE$.warning$default$2(), Output$.MODULE$.warning$default$3());
                    return;
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(content), '\r')) {
            Output$.MODULE$.warning("CR character" + Position$.MODULE$.here(file_pos, Position$.MODULE$.here$default$2()), Output$.MODULE$.warning$default$2(), Output$.MODULE$.warning$default$3());
        }
        if (Word$.MODULE$.bidi_detect(content)) {
            Output$.MODULE$.warning("Bidirectional Unicode text" + Position$.MODULE$.here(file_pos, Position$.MODULE$.here$default$2()), Output$.MODULE$.warning$default$2(), Output$.MODULE$.warning$default$3());
            return;
        }
    }

    public void check_hg(Path root) {
        Output$.MODULE$.writeln("Checking " + root + " ...", Output$.MODULE$.writeln$default$2(), Output$.MODULE$.writeln$default$3());
        Mercurial.Repository hg = Mercurial$.MODULE$.repository(root, Mercurial$.MODULE$.repository$default$2());
        hg.known_files().withFilter((Function1 & Serializable)file -> File$.MODULE$.is_scala((String)file) || File$.MODULE$.is_thy((String)file) || File$.MODULE$.is_ML((String)file) || file.endsWith("/ROOT")).foreach((Function1)(JProcedure1 & Serializable)file -> MODULE$.check_file(root.$plus(Path$.MODULE$.explode((String)file))));
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle check_sources [ROOT_DIRS...]\n\n  Check .scala, .thy, .ML, ROOT against known files of Mercurial ROOT_DIRS.\n";
    }

    private final List line_pos$1(String file_name$1, int i) {
        return Position$Line_File$.MODULE$.apply(i + 1, file_name$1);
    }
}

